package jp.gr.java_conf.jaba2.util;

import javax.swing.tree.TreeNode;
import javax.swing.table.AbstractTableModel;

/**
 * SimpleTableModel
 *
 * @since   Jun. 19, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class SimpleTableModel extends AbstractTableModel {
    protected ColumnHandler[] handlers_;
    protected Object[] data_;

    /**
     * You must invoke the <code>_setup</code> to initialize in the
     * constructor.
     */
    protected SimpleTableModel() {
    }

    public SimpleTableModel(ColumnHandler[] handlers, Object[] data) {
	_init(handlers, data);
    }

    public SimpleTableModel(ColumnHandler[] handlers, TreeNode node) {
	_init(handlers, node);
    }

    protected void _setup(ColumnHandler[] handlers, Object[] data) {
	_init(handlers, data);
    }

    protected void _setup(ColumnHandler[] handlers, TreeNode node) {
	_init(handlers, node);
    }

    protected void _init(ColumnHandler[] handlers, TreeNode node) {
	int size = node.getChildCount();
	Object[] data = new Object[size];
	for (int i = 0;i < size;i++) {
	    data[i] = node.getChildAt(i);
	}
	_init(handlers, data);
    }

    protected void _init(ColumnHandler[] handlers, Object[] data) {
	handlers_ = handlers;
	data_ = data;
    }

    // TableModel
    public int getRowCount() {
	_updateData();
	return (data_.length);
    }

    // TableModel
    public int getColumnCount() {
	return (handlers_.length);
    }

    // TableModel
    public Object getValueAt(int row, int column) {
	_updateData();
	return (handlers_[column].getValue(data_[row]));
    }

    // AbstractTableModel
    public void setValueAt(Object value, int row, int column) {
	data_[row] = handlers_[column].setValue(data_[row], value);
	fireTableCellUpdated(row, column);
    }

    // AbstractTableModel
    public Class getColumnClass(int column) {
	return (handlers_[column].getType());
    }

    // AbstractTableModel
    public String getColumnName(int column) {
	return (handlers_[column].getLabel());
    }

    public void setData(Object[] data) {
	data_ = (Object[])data.clone();
	fireTableDataChanged();
    }

    public void addData(Object data) {
	Object[] array = new Object[data_.length + 1];
	System.arraycopy(data_, 0, array, 0, data_.length);
	array[data_.length] = data;
	data_ = array;
	fireTableDataChanged();
    }

    protected void _updateData() { // XXX : _syncData?
    }

    public static interface ColumnHandler {
	String getName();
	String getLabel();
	Class getType();
	Object getValue(Object object);
	Object setValue(Object container, Object value);
    }

    public static abstract class AbstractColumnHandler
        implements ColumnHandler {

	protected String name_;
	protected String label_;
	protected Class clazz_;

	public AbstractColumnHandler(
	    String name,
	    String label,
	    Class clazz
	) {
	    name_ = name;
	    label_ = label;
	    clazz_ = clazz;
	}

	public String getName() {
	    return (name_);
	}

	public String getLabel() {
	    return (label_);
	}

	public Class getType() {
	    return (clazz_);
	}

	public Object setValue(Object container, Object value) {
	    throw (new UnsupportedOperationException());
	}
    }
}
