/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2003  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.beans;

import java.util.*;
import jp.gr.java_conf.jaba2.jmodel.lang.*;

/**
 * BJProperty
 *
 * @since   Jan. 18, 2000
 * @version Mar. 28, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class BJProperty {
    private String name_;
    private LJType type_;
    private String varName_;
    private String paramName_;
    private String defaultValue_;
    private boolean primitiveAccess_;
    private boolean nullable_;
    private String methodPrefix_;
    private String methodNameStyle_ = "get";
    private List altAccesses_ = new ArrayList();
    private HashMap properties_ = new HashMap();

    public BJProperty(String name, LJType type) {
	name_ = name;
	type_ = type;
    }

    public final String getName() {
	return (name_);
    }

    public final LJType getType() {
	return (type_);
    }

    public final void setVarName(String name) {
	varName_ = name;
    }

    public final String getVarName() {
	if (varName_ != null) {
	    return (varName_);
	}
	return (name_);
    }

    public final void setParamName(String name) {
	paramName_ = name;
    }

    public final String getParamName() {
	if (paramName_ != null) {
	    return (paramName_);
	}
	return (getVarName());
    }

    public final void setDefaultValue(String value) {
	defaultValue_ = value;
    }

    public final String getDefaultValue() {
	return (defaultValue_);
    }

    public final void setPrimitiveAccess(boolean value) {
	primitiveAccess_ = value;
    }

    public final boolean isPrimitiveAccess() {
	return (primitiveAccess_);
    }

    public final void setNullable(boolean value) {
	nullable_ = value;
    }

    public final boolean isNullable() {
	return (nullable_);
    }

    public final void setMethodPrefix(String prefix) {
	methodPrefix_ = prefix;
    }

    public final String getMethodPrefix() {
	return (methodPrefix_);
    }

    public final void setMethodNameStyle(String style) {
	methodNameStyle_ = style;
    }

    public final String getMethodNameStyle() {
	return (methodNameStyle_);
    }

    public final void addAltAccess(String method) {
	altAccesses_.add(method);
    }

    public final String[] getAltAccess() {
	String[] result = new String[altAccesses_.size()];
	return ((String[])altAccesses_.toArray(result));
    }

    public final Object getProperty(String key) {
	return (properties_.get(key));
    }

    public final Map getProperties() {
	return ((Map)properties_.clone());
    }

    public final void setProperty(String key, Object value) {
//	System.out.println(key + ":" + value);
	properties_.put(key, value);
    }

    public final void setProperties(Map properties) {
	properties_.putAll(properties);
    }
}
