/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2003  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.beans;

import jp.gr.java_conf.jaba2.jmodel.lang.*;

/**
 * BJProperty
 *
 * @since   Jan. 21, 2000
 * @version Mar. 19, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class BJListProperty extends BJProperty {
    private MapProperty map_ = null;
    private String methodNameType_ = "size";

    public BJListProperty(String name, LJType type) {
	super(name, type);
    }

    public final void setMapProperty(String propertyName, LJType type) {
	if (map_ != null) {	// XXX : addMapProperty
	    throw (new UnsupportedOperationException());
	}
	map_ = new MapProperty(propertyName, type);
    }

    public final MapProperty getMapProperty() {
	return (map_);
    }

    public final void setMethodNameType(String type) {
	methodNameType_ = type;
    }

    public final String getMethodNameType() {
	return (methodNameType_);
    }

    public static class MapProperty {
	public String propertyName;
	public LJType type;

	public MapProperty(String propertyName, LJType type) {
	    this.propertyName = propertyName;
	    this.type = type;
	}
    }
}
