/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.domcomps;

import java.net.URL;
import java.net.MalformedURLException;
import jp.gr.java_conf.jaba2.parcel.UParcel;
import jp.gr.java_conf.jaba2.dombus.*;

/**
 * DOMBusURLStarter
 *
 * @since   Aug. 31, 2000
 * @version Sep.  1, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusURLStarter extends AbstractDOMBusComponent {
    private IDOMBusParameter param_;

    public boolean init() {
	param_ = context_.getParameter();
	return (param_.getArgumentCount() > 0);
    }

    public Object fire(DOMBusSignal signal) {
	try {
	    param_ = context_.getParameter();
	    URL url = param_.getArgumentAsURLByFilenameURI(0);
	    return (UParcel.makeLinkParcel(url));
	} catch (MalformedURLException e) {
	    throw (new DOMBusException(e));
	}
    }
}
