/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.domcomps;

import java.io.StringReader;
import java.io.IOException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.apache.xerces.parsers.DOMParser;
import jp.gr.java_conf.jaba2.dombus.*;

/**
 * DOMBusDOMProcessor
 *
 * @since   Apr. 26, 2000
 * @version Apr. 29, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusDOMProcessor extends AbstractDOMBusComponent {
    public boolean init() {
	return (false);
    }

    public void start() {
    }

    public Object fire(DOMBusSignal signal) {
	Object content = signal.getContent();
	Document doc;
	if (content instanceof Document) {
	    doc = (Document)content;
	} else {
	    doc = _makeDocument(content.toString());
	}
	_sendSignal("dombus:dom", doc);
	return (null);
    }

    private Document _makeDocument(String text) {
	try {
	    DOMParser parser = new DOMParser();
	    InputSource is = new InputSource(new StringReader(text));
	    parser.parse(is);
	    return (parser.getDocument());
	} catch (IOException e) {
	    throw (new DOMBusException(e));
	} catch (SAXException e) {
	    throw (new DOMBusException(e));
	}
    }
}
