package jp.gr.java_conf.jaba2.awt;

import java.awt.Component;
import java.awt.Dimension;

/**
 * NullComponent
 *
 * @since   May.  6, 1998
 * @version Jul. 18, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */

public class NullComponent extends Component {
    protected int width_ = 0;
    protected int height_ = 0;

    public NullComponent() {
	_init(width_, height_);
    }

    public NullComponent(int width, int height) {
	_init(width, height);
    }

    private void _init(int width, int height) {
	width_ = width;
	height_ = height;
    }

    public Dimension getMinimumSize() {
	return (new Dimension(0, 0));
    }

    public Dimension getPreferredSize() {
	return (getMinimumSize());
    }

    public Dimension getMaximumSize() {
	return (getMaximumSize());
    }

    private static NullComponent comp__ = new NullComponent();

    public static NullComponent getSingleton() {
	return (comp__);
    }
}
