/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.util;

import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.relaxer.tabular.ITabular;

/**
 * RObjectSlot
 *
 * @since   Aug. 12, 2001
 * @version Arp. 15, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */

public class RObjectSlot {
    private Class rType_ = null;
    private Document doc_ = null;
    private Object rObject_ = null;
    private ITabular tabular_ = null; // obsolate
    private Document[] docs_ = null;
    private Object[] rObjects_ = null;

    public RObjectSlot() {
    }

    public RObjectSlot(Document doc) {
	doc_ = doc;
    }

    public RObjectSlot(Document doc, Class type) {
	doc_ = doc;
	rType_ = type;
    }

    public RObjectSlot(Object rObject) {
	rObject_ = rObject;
    }

    public RObjectSlot(ITabular tabular) {
	tabular_ = tabular;
    }

    public RObjectSlot(Document[] docs) {
	docs_ = docs;
    }

    public RObjectSlot(Document[] docs, Class type) {
	docs_ = docs;
	rType_ = type;
    }

    public RObjectSlot(Object[] rObjects) {
	rObjects_ = rObjects;
    }

    public final void setDocument(Document doc) {
	_cleanup();
	doc_ = doc;
    }

    public final void setDocument(Document doc, Class type) {
	_cleanup();
	doc_ = doc;
	rType_ = type;
    }

    public final void setRObject(Object object) {
/*
	if (!URelaxer.isRelaxerObject(object)) {
	    throw (new IllegalArgumentException(
		"no Relaxer object : " + object));
	}
*/
	_cleanup();
	rObject_ = object;
    }

    public final void setTabular(ITabular tabular) {
	_cleanup();
	tabular_ = tabular;
    }

    public final void setDocuments(Document[] docs) {
	_cleanup();
	docs_ = docs;
    }

    public final void setDocuments(Document[] docs, Class type) {
	_cleanup();
	docs_ = docs;
	rType_ = type;
    }

    public final void setRObjects(Object[] objects) {
	_cleanup();
	rObjects_ = objects;
    }

    public final void setType(Class type) {
	rType_ = type;
    }

    public Class getType() {
	return (rType_);
    }

    public Class getTacitType() {
	if (rType_ != null) {
	    return (rType_);
	} else if (rObject_ != null) {
	    return (rObject_.getClass());
	} else {
	    return (null);
	}
    }

    // get value as natural form
    public final Object getValue() {
	if (doc_ != null) {
	    return (doc_);
	} else if (rObject_ != null) {
	    return (rObject_);
	} else if (tabular_ != null) {
	    return (tabular_);
	} else if (docs_ != null) {
	    return (docs_);
	} else if (rObjects_ != null) {
	    return (rObjects_);
	} else {
	    return (null);
	}
    }

    public final Document getDocument()
	throws ParserConfigurationException, IllegalStateException {

	if (doc_ != null) {
	    return (doc_);
	} else if (rObject_ != null) {
	    return (URelaxer.makeRelaxerDocument(rObject_));
	} else if (tabular_ != null) {
	    return (tabular_.getDocument());
	} else if (docs_ != null) {
	    return (URelaxer.makeRelaxerDocument(docs_));
	} else if (rObjects_ != null) {
	    return (URelaxer.makeRelaxerDocument(rObjects_));
	} else {
	    return (null);
	}
    }

    public final Object getRObject() throws IllegalStateException {
	if (rObject_ != null) {
	    return (rObject_);
	} else if (doc_ != null) {
	    if (rType_ != null) {
		return (URelaxer.makeRelaxerObject(rType_, doc_));
	    } else {
		throw (new IllegalStateException(
		    "get a Relaxer object against a document without type"));
	    }
	} else if (tabular_ != null) {
	    throw (new IllegalStateException(
		"get a Relaxer object against a tabular"));
	} else if (docs_ != null) {
	    return (URelaxer.makeRelaxerObject(rType_, docs_));
	} else if (rObjects_ != null) {
	    return (URelaxer.makeRelaxerObject(rObjects_));
	} else {
	    return (null);
	}
    }

    public final ITabular getTabular() throws IllegalStateException {
	if (rObject_ != null) {
	    throw (new IllegalStateException(
		"get a tabular against a Relaxer object"));
	} else if (doc_ != null) {
	    throw (new IllegalStateException(
		"get a tabular against a document"));
	} else if (tabular_ != null) {
	    return (tabular_);
	} else if (docs_ != null) {
	    throw (new IllegalStateException(
		"get a tabular against documents"));
	} else if (rObjects_ != null) {
	    throw (new IllegalStateException(
		"get a tabular against Relaxer objects"));
	} else {
	    return (null);
	}
    }

    public final Document[] getDocuments()
	throws ParserConfigurationException {

	if (doc_ != null) {
	    return (new Document[] { doc_ });
	} else if (rObject_ != null) {
	    return (new Document[] { URelaxer.makeRelaxerDocument(rObject_) });
	} else if (tabular_ != null) {
	    return (new Document[] { tabular_.getDocument() });
	} else if (docs_ != null) {
	    return ((Document[])docs_.clone());
	} else if (rObjects_ != null) {
	    Document[] docs = new Document[rObjects_.length];
	    for (int i = 0;i < docs.length;i++) {
		docs[i] = URelaxer.makeRelaxerDocument(rObjects_[i]);
	    }
	    return (docs);
	} else {
	    return (null);
	}
    }

    public final Object[] getRObjects() {
	if (rObject_ != null) {
	    return (new Object[] { rObject_ });
	} else if (doc_ != null) {
	    if (rType_ != null) {
		return (
		    new Object[] { URelaxer.makeRelaxerObject(rType_, doc_) }
		);
	    } else {
		throw (new IllegalStateException(
		    "get a Relaxer object against a document without type"));
	    }
	} else if (rObjects_ != null) {
	    return ((Object[])rObjects_.clone());
	} else if (docs_ != null) {
	    if (rType_ != null) {
		Object[] objects = new Object[docs_.length];
		for (int i = 0;i < objects.length;i++) {
		    objects[i] = URelaxer.makeRelaxerObject(rType_, docs_[i]);
		}
		return (objects);
	    } else {
		throw (new IllegalStateException(
		    "get a Relaxer object against documents without type"));
	    }
	} else {
	    return (null);
	}
    }

    private void _cleanup() {
	rObject_ = null;
	doc_ = null;
	tabular_ = null;
    }
}
