/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.util;

import java.util.*;

/**
 * D1Array is a 1-dimensional extensible array.
 *
 * @since   Aug. 12, 2001
 * @version Aug. 12, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class D1Array extends ArrayList implements Cloneable {
    public D1Array() {
    }

    public D1Array(List list) {
	addAll(list);
    }

    public Object put(int index, Object obj) {
	_ensureSpace(index);
	return (set(index, obj));
    }

    private void _ensureSpace(int index) {
	int size = size();
	for (int i = size;i <= index;i++) {
	    add(i, null);
	}
    }

    // Object
    public Object clone() {
	return (new D1Array(this));
    }
}
