/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib.tabular;

import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.relaxer.tabular.*;

/**
 * AbstractTabularBeanTag
 *
 * @since   Jul. 11, 2001
 * @version Aug. 13, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractTabularBeanTag extends TagSupport {
    public int doEndTag() throws JspTagException {
	ITabularAccepter parent =
	    (ITabularAccepter)findAncestorWithClass(
		this,
		ITabularAccepter.class
	    );
	if (parent == null) {
	    throw (new JspTagException("no parent"));
	}
	ITabular tabular = _getTabular();
	parent.acceptTabular(tabular);
	return (EVAL_PAGE);
    }

    protected abstract ITabular _getTabular() throws JspTagException;

    protected String _resolve(String uri) {
	try {
	    URL url = new URL(uri);
	    return (uri);
	} catch (MalformedURLException e) {
	    File file = new File(
		pageContext.getServletContext().getRealPath(uri)
	    );
	    try {
		return (file.toURL().toExternalForm());
	    } catch (MalformedURLException ee) {
		return (null);
	    }
	}
    }
}
