/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.lang.reflect.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.relaxer.beans.DialogSpaceBean;
import org.relaxer.util.RObjectSlot;
import org.relaxer.xml.XMLObject;

/**
 * UpdateValueTag
 *
 * @since   Jul. 13, 2001
 * @version Aug. 13, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class UpdateValueTag extends AbstractDialogTag {
    protected Object _doEvaluate(RObjectSlot[] params) throws JspTagException {
	try {
	    DialogSpaceBean dialog = _getDialogSpace();
	    Document doc = dialog.getSlotDocument(getSlot());
	    for (int i = 0;i < params.length;i++) {
		doc = _update(doc, params[i].getDocument());
	    }
	    return (doc);
	} catch (ParserConfigurationException e) {
	    throw (new JspTagException(e.getMessage()));
	}
    }

    private Document _update(Document doc, Document update) {
	XMLObject xml = new XMLObject(doc);
	xml.update(update);
	return (xml.getDocument());
    }
}
