/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.lang.reflect.*;
import java.beans.IntrospectionException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.w3c.dom.Document;
import org.relaxer.tabular.ITabular;
import org.relaxer.tabular.ITabularAccepter;
import org.relaxer.tabular.XMLTabular;
import org.relaxer.util.URelaxer;
import org.relaxer.util.UException;

/**
 * TabularTag
 *
 * @since   Jul. 15, 2001
 * @version Apr. 23, 2002
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class TabularTag extends AbstractDialogTag {
    protected int _doRelaxerEndTag() throws JspException, JspTagException {
	ITabularAccepter parent =
	    (ITabularAccepter)findAncestorWithClass(
		this,
		ITabularAccepter.class
	    );
	if (parent == null) {
	    throw (new JspTagException("no parent"));
	}
	ITabular tabular = _makeTabular();
	parent.acceptTabular(tabular);
//System.out.println(tabular);
	return (super._doRelaxerEndTag());
    }

    private ITabular _makeTabular() throws JspTagException {
	try {
	    return (_makeTabular(_getValue()));
	} catch (IntrospectionException e) {
	    throw (UException.makeJspTagException(e));
	} catch (InvocationTargetException e) {
	    throw (UException.makeJspTagException(e));
	} catch (IllegalAccessException e) {
	    throw (UException.makeJspTagException(e));
	}
    }

    private ITabular _makeTabular(Object object) {
	if (object instanceof Document) {
	    return (_makeTabularByDocument((Document)object));
	} else {
	    return (_makeTabularByRObject(object));
	}
    }

    private ITabular _makeTabularByDocument(Document doc) {
	return (new XMLTabular(doc));
    }

    private ITabular _makeTabularByRObject(Object object) {
	return (_makeTabularByDocument(URelaxer.makeRelaxerDocument(object)));
    }
}
