/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import java.sql.SQLException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.relaxer.beans.RJDBCCreateBean;

/**
 * RJDBCCreateBeanTag
 *
 * @since   Jul.  9, 2001
 * @version Apr. 23, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RJDBCCreateBeanTag extends AbstractRJDBCBeanTag {
    private boolean refresh_;

    public void setRefresh(String refresh) {
	refresh_ = "true".equals(refresh);
    }

    public RJDBCCreateBeanTag() {
	_setup(new RJDBCCreateBean());
    }

    protected int _doRelaxerEndTag() throws JspTagException {
	RJDBCCreateBean bean = (RJDBCCreateBean)bean_;
	try {
	    if (refresh_) {
		bean.dropCreateTable();
	    } else {
		bean.createTable();
	    }
	} catch (SQLException e) {
	    throw (new JspTagException(e.getMessage()));
	}
	return (EVAL_PAGE);
    }
}
