/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.io.IOException;
import java.lang.reflect.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.relaxer.beans.DialogSpaceBean;
import org.relaxer.dialog.IPathResolver;

/**
 * ExecuteCommandTag
 *
 * @since   Feb. 27, 2002
 * @version Mar.  6, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class ExecuteCommandTag extends AbstractDialogTag {
    private String command_;

    public final void setCommand(String command) {
	command_ = command;
    }

    protected int _doRelaxerEndTag() throws JspException, JspTagException {
	try {
	    JspWriter out = pageContext.getOut();
	    String result = _executeCommand();
	    if (result != null) {
		out.print(result);
	    }
	} catch (IOException e) {
	    throw (new JspTagException(e.getMessage()));
	}
	return (super._doRelaxerEndTag());
    }

    private String _executeCommand() throws JspTagException {
	DialogSpaceBean dialog = _getDialogSpace();
	Object result = dialog.executeCommand(command_);
	if (result == null) {
	    return (null);
	} else if (result instanceof Exception) {
	    throw (new JspTagException(result.toString())); // XXX
	} else {
	    return (result.toString());
	}
    }
}
