package org.relaxer.runtime.rFactory;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>FComponentRmi</b> is generated by Relaxer based on factory.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="rmi">
 *   <element name="name">
 *     <data type="token"/>
 *   </element>
 *   <optional>
 *     <ref name="componentClient"/>
 *   </optional>
 *   <optional>
 *     <ref name="componentServer"/>
 *   </optional>
 *   <optional>
 *     <ref name="componentProvider"/>
 *   </optional>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="rmi"&gt;
 *   &lt;element name="name"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/element&gt;
 *   &lt;optional&gt;
 *     &lt;ref name="componentClient"/&gt;
 *   &lt;/optional&gt;
 *   &lt;optional&gt;
 *     &lt;ref name="componentServer"/&gt;
 *   &lt;/optional&gt;
 *   &lt;optional&gt;
 *     &lt;ref name="componentProvider"/&gt;
 *   &lt;/optional&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version factory.rng (Thu Sep 05 12:38:32 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class FComponentRmi implements java.io.Serializable, IFComponentChoice {
    private String name_;
    private FComponentClient componentClient_;
    private FComponentServer componentServer_;
    private FComponentProvider componentProvider_;

    /**
     * Creates a <code>FComponentRmi</code>.
     *
     */
    public FComponentRmi() {
    }

    /**
     * Creates a <code>FComponentRmi</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FComponentRmi(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>FComponentRmi</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public FComponentRmi(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>FComponentRmi</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public FComponentRmi(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>FComponentRmi</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentRmi(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>FComponentRmi</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentRmi(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>FComponentRmi</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentRmi(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>FComponentRmi</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentRmi(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>FComponentRmi</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentRmi(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>FComponentRmi</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentRmi(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>FComponentRmi</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>FComponentRmi</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>FComponentRmi</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        name_ = URelaxer.getElementPropertyAsString(stack.popElement());
        if (FComponentClient.isMatch(stack)) {
            setComponentClient(new FComponentClient(stack));
        }
        if (FComponentServer.isMatch(stack)) {
            setComponentServer(new FComponentServer(stack));
        }
        if (FComponentProvider.isMatch(stack)) {
            setComponentProvider(new FComponentProvider(stack));
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("rmi");
        int size;
        URelaxer.setElementPropertyByString(element, "name", this.name_);
        if (this.componentClient_ != null) {
            this.componentClient_.makeElement(element);
        }
        if (this.componentServer_ != null) {
            this.componentServer_.makeElement(element);
        }
        if (this.componentProvider_ != null) {
            this.componentProvider_.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>FComponentRmi</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>FComponentRmi</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentRmi</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentRmi</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentRmi</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentRmi</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the FComponentClient property <b>componentClient</b>.
     *
     * @return FComponentClient
     */
    public final FComponentClient getComponentClient() {
        return (componentClient_);
    }

    /**
     * Sets the FComponentClient property <b>componentClient</b>.
     *
     * @param componentClient
     */
    public final void setComponentClient(FComponentClient componentClient) {
        this.componentClient_ = componentClient;
    }

    /**
     * Gets the FComponentServer property <b>componentServer</b>.
     *
     * @return FComponentServer
     */
    public final FComponentServer getComponentServer() {
        return (componentServer_);
    }

    /**
     * Sets the FComponentServer property <b>componentServer</b>.
     *
     * @param componentServer
     */
    public final void setComponentServer(FComponentServer componentServer) {
        this.componentServer_ = componentServer;
    }

    /**
     * Gets the FComponentProvider property <b>componentProvider</b>.
     *
     * @return FComponentProvider
     */
    public final FComponentProvider getComponentProvider() {
        return (componentProvider_);
    }

    /**
     * Sets the FComponentProvider property <b>componentProvider</b>.
     *
     * @param componentProvider
     */
    public final void setComponentProvider(FComponentProvider componentProvider) {
        this.componentProvider_ = componentProvider;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<rmi");
        buffer.append(">");
        buffer.append("<name>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(getName())));
        buffer.append("</name>");
        if (componentClient_ != null) {
            componentClient_.makeTextElement(buffer);
        }
        if (componentServer_ != null) {
            componentServer_.makeTextElement(buffer);
        }
        if (componentProvider_ != null) {
            componentProvider_.makeTextElement(buffer);
        }
        buffer.append("</rmi>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<rmi");
        buffer.print(">");
        buffer.print("<name>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(getName())));
        buffer.print("</name>");
        if (componentClient_ != null) {
            componentClient_.makeTextElement(buffer);
        }
        if (componentServer_ != null) {
            componentServer_.makeTextElement(buffer);
        }
        if (componentProvider_ != null) {
            componentProvider_.makeTextElement(buffer);
        }
        buffer.print("</rmi>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>FComponentRmi</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "rmi")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "name")) {
            return (false);
        }
        $match$ = true;
        if (FComponentClient.isMatchHungry(target)) {
        }
        $match$ = true;
        if (FComponentServer.isMatchHungry(target)) {
        }
        $match$ = true;
        if (FComponentProvider.isMatchHungry(target)) {
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FComponentRmi</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FComponentRmi</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
