package org.relaxer.runtime.rFactory;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>FAuthTable</b> is generated by Relaxer based on factory.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="table">
 *   <element name="uri">
 *     <data type="token"/>
 *   </element>
 *   <element name="tableName">
 *     <data type="token"/>
 *   </element>
 *   <optional>
 *     <element name="userName">
 *       <data type="token"/>
 *     </element>
 *   </optional>
 *   <optional>
 *     <element name="password">
 *       <data type="token"/>
 *     </element>
 *   </optional>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="table"&gt;
 *   &lt;element name="uri"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/element&gt;
 *   &lt;element name="tableName"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/element&gt;
 *   &lt;optional&gt;
 *     &lt;element name="userName"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/element&gt;
 *   &lt;/optional&gt;
 *   &lt;optional&gt;
 *     &lt;element name="password"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/element&gt;
 *   &lt;/optional&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version factory.rng (Thu Sep 05 12:38:32 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class FAuthTable implements java.io.Serializable, IFAuthChoice {
    private String uri_;
    private String tableName_;
    private String userName_;
    private String password_;

    /**
     * Creates a <code>FAuthTable</code>.
     *
     */
    public FAuthTable() {
    }

    /**
     * Creates a <code>FAuthTable</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FAuthTable(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>FAuthTable</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public FAuthTable(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>FAuthTable</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public FAuthTable(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>FAuthTable</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FAuthTable(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>FAuthTable</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FAuthTable(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>FAuthTable</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FAuthTable(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>FAuthTable</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FAuthTable(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>FAuthTable</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FAuthTable(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>FAuthTable</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FAuthTable(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>FAuthTable</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>FAuthTable</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>FAuthTable</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        uri_ = URelaxer.getElementPropertyAsString(stack.popElement());
        tableName_ = URelaxer.getElementPropertyAsString(stack.popElement());
        userName_ = URelaxer.getElementPropertyAsStringByStack(stack, "userName");
        password_ = URelaxer.getElementPropertyAsStringByStack(stack, "password");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("table");
        int size;
        URelaxer.setElementPropertyByString(element, "uri", this.uri_);
        URelaxer.setElementPropertyByString(element, "tableName", this.tableName_);
        if (this.userName_ != null) {
            URelaxer.setElementPropertyByString(element, "userName", this.userName_);
        }
        if (this.password_ != null) {
            URelaxer.setElementPropertyByString(element, "password", this.password_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>FAuthTable</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>FAuthTable</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FAuthTable</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FAuthTable</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FAuthTable</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FAuthTable</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>uri</b>.
     *
     * @return String
     */
    public final String getUri() {
        return (uri_);
    }

    /**
     * Sets the String property <b>uri</b>.
     *
     * @param uri
     */
    public final void setUri(String uri) {
        this.uri_ = uri;
    }

    /**
     * Gets the String property <b>tableName</b>.
     *
     * @return String
     */
    public final String getTableName() {
        return (tableName_);
    }

    /**
     * Sets the String property <b>tableName</b>.
     *
     * @param tableName
     */
    public final void setTableName(String tableName) {
        this.tableName_ = tableName;
    }

    /**
     * Gets the String property <b>userName</b>.
     *
     * @return String
     */
    public final String getUserName() {
        return (userName_);
    }

    /**
     * Sets the String property <b>userName</b>.
     *
     * @param userName
     */
    public final void setUserName(String userName) {
        this.userName_ = userName;
    }

    /**
     * Gets the String property <b>password</b>.
     *
     * @return String
     */
    public final String getPassword() {
        return (password_);
    }

    /**
     * Sets the String property <b>password</b>.
     *
     * @param password
     */
    public final void setPassword(String password) {
        this.password_ = password;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<table");
        buffer.append(">");
        buffer.append("<uri>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(getUri())));
        buffer.append("</uri>");
        buffer.append("<tableName>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(getTableName())));
        buffer.append("</tableName>");
        if (userName_ != null) {
            buffer.append("<userName>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getUserName())));
            buffer.append("</userName>");
        }
        if (password_ != null) {
            buffer.append("<password>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getPassword())));
            buffer.append("</password>");
        }
        buffer.append("</table>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<table");
        buffer.print(">");
        buffer.print("<uri>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(getUri())));
        buffer.print("</uri>");
        buffer.print("<tableName>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(getTableName())));
        buffer.print("</tableName>");
        if (userName_ != null) {
            buffer.print("<userName>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getUserName())));
            buffer.print("</userName>");
        }
        if (password_ != null) {
            buffer.print("<password>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getPassword())));
            buffer.print("</password>");
        }
        buffer.print("</table>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getUriAsString() {
        return (URelaxer.getString(getUri()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTableNameAsString() {
        return (URelaxer.getString(getTableName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getUserNameAsString() {
        return (URelaxer.getString(getUserName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getPasswordAsString() {
        return (URelaxer.getString(getPassword()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setUriByString(String string) {
        setUri(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTableNameByString(String string) {
        setTableName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setUserNameByString(String string) {
        setUserName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setPasswordByString(String string) {
        setPassword(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>FAuthTable</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "table")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "uri")) {
            return (false);
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "tableName")) {
            return (false);
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null) {
            if (URelaxer.isTargetElement(child, "userName")) {
                target.popElement();
            }
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null) {
            if (URelaxer.isTargetElement(child, "password")) {
                target.popElement();
            }
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FAuthTable</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FAuthTable</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
