/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2003  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.runtime.logger;

import java.util.*;
import java.io.*;
import org.relaxer.runtime.*;
import org.relaxer.runtime.datatype.RDateTime;

/**
 * AbstractPrintStreamLogger
 *
 * @since   Apr. 12, 2002
 * @version Jan. 19, 2003
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public abstract class AbstractPrintStreamLogger extends AbstractStreamLogger {
    protected AbstractPrintStreamLogger(RComponentContext context) {
	super(context);
    }

    protected AbstractPrintStreamLogger(
	RComponentContext context,
	Writer out
    ) {
	super(context, out);
    }

    protected AbstractPrintStreamLogger(
	RComponentContext context,
	OutputStream out
    ) {
	super(context, out);
    }

    public void setup(Properties properties) {
    }

    public void log(String message) {
	try {
	    formatter_.log(message, out_);
	} catch (IOException e) {
	    _loggingError(e);
	}
    }

    public void logEnter(Object object, String method) {
	try {
	    formatter_.logEnter(object, method, out_);
	} catch (IOException e) {
	    _loggingError(e);
	}
    }

    public void logEnter(Object object, String method, String arg) {
	try {
	    formatter_.logEnter(object, method, arg, out_);
	} catch (IOException e) {
	    _loggingError(e);
	}
    }

    public void logEnter(
	Object object,
	String method,
	String arg1,
	String arg2
    ) {
	try {
	    formatter_.logEnter(object, method, arg1, arg2, out_);
	} catch (IOException e) {
	    _loggingError(e);
	}
    }

    public void logEnter(
	Object object,
	String method,
	String arg1,
	String arg2,
	String arg3
    ) {
	try {
	    formatter_.logEnter(object, method, arg1, arg2, arg3, out_);
	} catch (IOException e) {
	    _loggingError(e);
	}
    }

    public void logEnter(Object object, String method, String[] args) {
	try {
	    formatter_.logEnter(object, method, args, out_);
	} catch (IOException e) {
	    _loggingError(e);
	}
    }

    public void logLeave(Object object, String method) {
	try {
	    formatter_.logLeave(object, method, out_);
	} catch (IOException e) {
	    _loggingError(e);
	}
    }

    public void logLeave(Object object, String method, String result) {
	try {
	    formatter_.logLeave(object, method, result, out_);
	} catch (IOException e) {
	    _loggingError(e);
	}
    }

    public void logLeave(Object object, String method, Exception e) {
	try {
	    formatter_.logLeave(object, method, e, out_);
	} catch (IOException ee) {
	    _loggingError(ee);
	}
    }
}
