/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2003  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.jaxb;

import java.util.*;
import java.io.*;
import java.lang.reflect.*;
import javax.xml.bind.*;
import javax.xml.bind.helpers.*;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.w3c.dom.*;
import org.relaxer.xml.sax.DOMSAXProducer;

/**
 * RelaxerMarshaller
 *
 * @since   Feb. 17, 2003
 * @version Feb. 25, 2003
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RelaxerMarshaller extends AbstractMarshallerImpl {
    private RelaxerJaxbContext context_;

    public RelaxerMarshaller(RelaxerJaxbContext context) {
	context_ = context;
    }

    public void marshal(Object ro, Result result) throws JAXBException {
	if (result instanceof StreamResult) {
	    _marshal(ro, (StreamResult)result);
	} else if (result instanceof DOMResult) {
	    _marshal(ro, (DOMResult)result);
	} else if (result instanceof SAXResult) {
	    _marshal(ro, (SAXResult)result);
	} else {
	    throw (new JAXBException(""));
	}
    }

    private void _marshal(Object ro, StreamResult result)
	throws JAXBException {

	OutputStream out = result.getOutputStream();
	if (out != null) {
	    _marshal(ro, out);
	} else {
	    Writer writer = result.getWriter();
	    if (writer != null) {
		_marshal(ro, writer);
	    } else {
		throw (new JAXBException(""));
	    }
	}
    }

    private void _marshal(Object ro, OutputStream out) throws JAXBException {
	try {
	    OutputStreamWriter writer = new OutputStreamWriter(out);
	    _marshal(ro, writer);
	    out.flush();
	} catch (IOException e) {
	    throw (new JAXBException(e.getMessage()));
	}
    }

    private void _marshal(Object ro, Writer writer) throws JAXBException {
	try {
	    Class clazz = ro.getClass();
	    Class[] params = new Class[] { Writer.class };
	    Method method = clazz.getMethod("makeTextElement", params);
	    Object[] args = new Object[] { writer };
	    method.invoke(ro, args);
	    writer.flush();
	} catch (IOException e) {
	    throw (new JAXBException(e.getMessage()));
	} catch (NoSuchMethodException e) {
	    throw (new JAXBException(e.getMessage()));
	} catch (IllegalAccessException e) {
	    throw (new JAXBException(e.getMessage()));
	} catch (InvocationTargetException e) {
	    throw (new JAXBException(e.getMessage()));
	}
    }

    private void _marshal(Object ro, DOMResult result) throws JAXBException {
	try {
	    Node node = result.getNode();
	    if (node == null) {
		Document doc = _makeDomDocument(ro);
		result.setNode(doc);
	    } else if (node instanceof Document) {
		Document doc = (Document)node;
		node.appendChild(_makeElement(ro, doc));
	    } else {
		Document doc = node.getOwnerDocument();
		node.appendChild(_makeElement(ro, doc));
	    }
	} catch (NoSuchMethodException e) {
	    throw (new JAXBException(e.getMessage()));
	} catch (IllegalAccessException e) {
	    throw (new JAXBException(e.getMessage()));
	} catch (InvocationTargetException e) {
	    throw (new JAXBException(e.getMessage()));
	}
    }

    private Document _makeDomDocument(Object ro)
	throws NoSuchMethodException, IllegalAccessException,
	       InvocationTargetException {

	Class clazz = ro.getClass();
	Class[] params = new Class[] {};
	Method method = clazz.getMethod("makeDocument", params);
	Object[] args = new Object[] {};
	return ((Document)method.invoke(ro, args));
    }

    private org.w3c.dom.Element _makeElement(Object ro, Document doc)
	throws NoSuchMethodException,
	       IllegalAccessException,
	       InvocationTargetException {

	Class clazz = ro.getClass();
	Class[] params = new Class[] { Document.class };
	Method method = clazz.getMethod("makeElement", params);
	Object[] args = new Object[] { doc };
	return ((org.w3c.dom.Element)method.invoke(ro, args));
    }

    private void _marshal(Object ro, SAXResult result) throws JAXBException {
	ContentHandler saxHandler = result.getHandler();
	try {
	    Class clazz = ro.getClass();
	    Class[] params = new Class[] { ContentHandler.class };
	    Method method = clazz.getMethod("makeDocument", params);
	    Object[] args = new Object[] { saxHandler };
	    method.invoke(ro, args);
	} catch (NoSuchMethodException e) {
	    try {
		Document doc = _makeDomDocument(ro);
		DOMSAXProducer producer = new DOMSAXProducer(doc);
		producer.setContentHandler(saxHandler);
		producer.makeEvent();
	    } catch (NoSuchMethodException ee) {
		throw (new JAXBException(ee.getMessage()));
	    } catch (IllegalAccessException ee) {
		throw (new JAXBException(ee.getMessage()));
	    } catch (InvocationTargetException ee) {
		throw (new JAXBException(ee.getMessage()));
	    } catch (SAXException ee) {
		throw (new JAXBException(e.getMessage()));
	    }
	} catch (IllegalAccessException e) {
	    throw (new JAXBException(e.getMessage()));
	} catch (InvocationTargetException e) {
	    throw (new JAXBException(e.getMessage()));
	}
    }
}
