/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.goldenport;

import java.util.*;
import org.w3c.dom.*;

/**
 * PortFactory
 *
 * @since   Feb. 10, 2002
 * @version Jul.  8, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class PortFactory {
    private List ports_ = new ArrayList(); // List<IPort>

    public void addPort(IPort port) {
	ports_.add(port);
    }

    public IPort[] getPorts() {
	IPort[] result = new IPort[ports_.size()];
	return ((IPort[])ports_.toArray(result));
    }

    public IPort getPort(Element element) {
	int size = ports_.size();
	for (int i = 0;i < size;i++) {
	    IPort port = (IPort)ports_.get(i);
	    if (port.isAccept(element)) {
		return (port);
	    }
	}
	return (null);
    }

    public IPort[] getPorts(Element element) {
	List list = new ArrayList();
	int size = ports_.size();
	for (int i = 0;i < size;i++) {
	    IPort port = (IPort)ports_.get(i);
	    if (port.isAccept(element)) {
		list.add(port);
	    }
	}
	if (list.size() == 0) {
	    return (null);
	}
	IPort[] result = new IPort[list.size()];
	return ((IPort[])list.toArray(result));
    }
}
