/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.goldenport;

import org.w3c.dom.*;

/**
 * PortEngine
 *
 * @since   Feb.  9, 2002
 * @version Jul.  8, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class PortEngine implements IPortConstants {
    private PortFactory factory_;

    public PortEngine(PortFactory factory) {
	factory_ = factory;
    }

    public Document eval(Document doc, PortContext context) {
	Element root = doc.getDocumentElement();
	Node result = eval(root, context);
	doc.removeChild(root);
	doc.appendChild(result);
	return (doc);
    }

    public Node eval(Element element, PortContext context) {
	IPort[] ports = factory_.getPorts();
	for (int i = 0;i < ports.length;i++) {
	    ports[i].setup(element);
	}
	Node node = element;
	for (int i = 0;i < ports.length;i++) {
	    context.setPort(ports[i]);
	    node = _evalChild(element, context);
	    if (node == null) {
		return (null);
	    }
	}
	return (node);
    }

    protected final PortNodeList _evalChildren(
	PortNodeList source,
	PortContext context
    ) {
	PortNodeList result = new PortNodeList(
	    source.getFactoryDocument()
	);
	result.setElement(source.getElement());
	int size = source.size();
	for (int i = 0;i < size;i++) {
	    Node child = source.getChild(i);
//System.out.println(child.toString());
	    switch (child.getNodeType()) {

	    case Node.ELEMENT_NODE:
		Node evaluated = _evalChild((Element)child, context);
		if (evaluated != null) {
		    result.addChild(evaluated);
		}
		break;
	    default:
		result.addChild(child);
	    }
	}
	return (result);
    }

    protected final Node _evalChild(
	Element child,
	PortContext context
    ) {
	IPort port = context.getPort();
	if (!port.isAccept(child)) {
	    Document doc = child.getOwnerDocument();
	    PortNodeList result = new PortNodeList(doc);
	    result.setElement(child);
	    result.addChildren(child);
	    result = _evalChildren(result, context);
	    return (result.makeNode());
	} else {
//System.out.println("evalChild = " + child.getLocalName());
	    Document doc = child.getOwnerDocument();
	    PortNodeList halfResult = new PortNodeList(doc);
	    PortNodeList result = new PortNodeList(doc);
	    int status = port.startElement(child, context, halfResult);
	    switch (status) {

	    case EVAL_DONE:
		return (halfResult.makeNode());
	    case EVAL_CHILDREN:
		halfResult = _evalChildren(halfResult, context);
		port.endElement(child, halfResult, context, result);
		return (result.makeNode());
	    default:
		throw (new InternalError());
	    }
	}
    }
}
