/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.evaluater;

import java.util.*;
import org.w3c.dom.*;

/**
 * EvaluaterNodeList
 *
 * @since   Mar. 11, 2002
 * @version Mar. 11, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class EvaluaterNodeList {
    private Document doc_;
    private List list_ = new ArrayList();

    public EvaluaterNodeList(Document doc) {
	doc_ = doc;
    }

    public Document getFactoryDocument() {
	return (doc_);
    }

    public void add(Node node) {
	list_.add(node);
    }

    public void addChildren(Node node) {
	NodeList children = node.getChildNodes();
	int size = children.getLength();
	for (int i = 0;i < size;i++) {
	    list_.add(children.item(i));
	}
    }

    public int size() {
	return (list_.size());
    }

    public Node get(int index) {
	return ((Node)list_.get(index));
    }

    public DocumentFragment getHedge() {
	DocumentFragment frag = doc_.createDocumentFragment();
	int size = list_.size();
	for (int i = 0;i < size;i++) {
	    Node child = (Node)list_.get(i);
	    frag.appendChild(child);
	}
	return (frag);
    }
}
