/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.evaluater;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import com.AsamiOffice.util.AbstractObjectFactory;

/**
 * EvaluaterFactory
 *
 * @since   Feb. 10, 2002
 * @version Feb. 10, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class EvaluaterFactory extends AbstractObjectFactory {
    public EvaluaterFactory(String uri) 
	throws IOException, SAXException, ParserConfigurationException {

	_loadConfig(uri);
    }

    public IEvaluater getEvaluater(String uri) {
	return ((IEvaluater)getConcreteObject(uri));
    }
}
