/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.evaluater;

import org.w3c.dom.*;

/**
 * EvaluaterEngine
 *
 * @since   Feb.  9, 2002
 * @version Feb. 11, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class EvaluaterEngine implements IEvaluaterConstants {
    private EvaluaterFactory factory_;

    public EvaluaterEngine(EvaluaterFactory factory) {
	factory_ = factory;
    }

    public Node eval(Element element, EvaluaterContext context) {
	return (_evalChild(element, context));
    }

    protected final EvaluaterNodeList _evalChildren(
	EvaluaterNodeList children,
	EvaluaterContext context
    ) {
	EvaluaterNodeList result = new EvaluaterNodeList(
	    children.getFactoryDocument()
	);
	int size = children.size();
	for (int i = 0;i < size;i++) {
	    Node child = children.get(i);
	    switch (child.getNodeType()) {

	    case Node.ELEMENT_NODE:
		Node evaluated = _evalChild((Element)child, context);
		if (evaluated != null) {
		    result.add(evaluated);
		}
		break;
	    default:
		result.add(child);
	    }
	}
	return (result);
    }

    protected final Node _evalChild(
	Element child,
	EvaluaterContext context
    ) {
	child = _filterChild(child, context);
	if (child == null) {
	    return (null);
	}
	String uri = child.getNamespaceURI();
	IEvaluater evaluater = factory_.getEvaluater(uri);
	if (evaluater == null) {
	    Document doc = child.getOwnerDocument();
	    Element result = (Element)doc.importNode(child, false);
	    EvaluaterNodeList children = new EvaluaterNodeList(doc);
	    children.addChildren(child);
	    EvaluaterNodeList evaluated	= _evalChildren(children, context);
	    result.appendChild(evaluated.getHedge());
	    return (result);
	} else {
	    Document doc = child.getOwnerDocument();
	    EvaluaterNodeList children = new EvaluaterNodeList(doc);
	    EvaluaterNodeList result = new EvaluaterNodeList(doc);
	    int startResult = evaluater.startElement(child, context, children);
	    switch (startResult) {

	    case EVAL_DONE:
		return (children.getHedge());
	    case EVAL_CHILDREN:
		children = _evalChildren(children, context);
		evaluater.endElement(child, children, context, result);
		return (result.getHedge());
	    default:
		throw (new InternalError());
	    }
	}
    }

    protected final Element _filterChild(
	Element child,
	EvaluaterContext context
    ) {
	return (child);
    }

/*
    protected final Node _adjustFragment(EvaluaterNodeList frag) {
	Node first = frag.getFirstChild();
	if (first == null) {
	    return (null);
	}
	if (first == frag.getLastChild()) {
	    return (first);
	}
	return (frag);
    }
*/
}
