package org.relaxer.dialog.rDialog;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>DReadAndWrite</b> is generated from dialog.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <define name="readAndWrite">
 *   <ref name="read"/>
 *   <ref name="write"/>
 * </define>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;define name="readAndWrite"&gt;
 *   &lt;ref name="read"/&gt;
 *   &lt;ref name="write"/&gt;
 * &lt;/define&gt;
 * </pre>
 *
 * @version dialog.rng (Tue Jun 03 11:20:58 GMT+09:00 2003)
 * @author  Relaxer 1.0beta (http://www.relaxer.org)
 */
public class DReadAndWrite implements java.io.Serializable, Cloneable, IREvaluatable, IRNode, IDSlotChoice {
    private DRead read_;
    private DWrite write_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>DReadAndWrite</code>.
     *
     */
    public DReadAndWrite() {
    }

    /**
     * Creates a <code>DReadAndWrite</code>.
     *
     * @param source
     */
    public DReadAndWrite(DReadAndWrite source) {
        setup(source);
    }

    /**
     * Creates a <code>DReadAndWrite</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public DReadAndWrite(RStack stack) {
        setup(stack);
    }

    /**
     * Initializes the <code>DReadAndWrite</code> by the DReadAndWrite <code>source</code>.
     *
     * @param source
     */
    public void setup(DReadAndWrite source) {
        int size;
        setRead((DRead)source.getRead());
        setWrite((DWrite)source.getWrite());
    }

    /**
     * Initializes the <code>DReadAndWrite</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        Element element = stack.getContextElement();
        IDialogFactory factory = DialogFactory.getFactory();
        if (DRead.isMatch(stack)) {
            setRead(factory.createDRead(stack));
        }
        if (DWrite.isMatch(stack)) {
            setWrite(factory.createDWrite(stack));
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        IDialogFactory factory = DialogFactory.getFactory();
        return (factory.createDReadAndWrite(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size;
        if (this.read_ != null) {
            this.read_.makeElement(element);
        }
        if (this.write_ != null) {
            this.write_.makeElement(element);
        }
    }

    /**
     * Gets the DRead property <b>read</b>.
     *
     * @return DRead
     */
    public final DRead getRead() {
        return (read_);
    }

    /**
     * Sets the DRead property <b>read</b>.
     *
     * @param read
     */
    public final void setRead(DRead read) {
        this.read_ = read;
        if (read != null) {
            read.rSetParentRNode(this);
        }
    }

    /**
     * Gets the DWrite property <b>write</b>.
     *
     * @return DWrite
     */
    public final DWrite getWrite() {
        return (write_);
    }

    /**
     * Sets the DWrite property <b>write</b>.
     *
     * @param write
     */
    public final void setWrite(DWrite write) {
        this.write_ = write;
        if (write != null) {
            write.rSetParentRNode(this);
        }
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        if (read_ != null) {
            read_.makeTextElement(buffer);
        }
        if (write_ != null) {
            write_.makeTextElement(buffer);
        }
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        if (read_ != null) {
            read_.makeTextElement(buffer);
        }
        if (write_ != null) {
            write_.makeTextElement(buffer);
        }
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        if (read_ != null) {
            read_.makeTextElement(buffer);
        }
        if (write_ != null) {
            write_.makeTextElement(buffer);
        }
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
        int size;
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
        int size;
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
        int size;
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Evaluates the node.
     *
     * @return Object
     */
    public Object eval() {
        return (eval(new RSimpleEvaluationContext()));
    }

    /**
     * Evaluates the node with the evaluation context.
     *
     * @param context
     * @return Object
     */
    public Object eval(IREvaluationContext context) {
        IRNode[] children = rGetRNodes();
        Object[] params = new Object[children.length];
        for (int i = 0;i < children.length;i++) {
            IRNode child = children[i];
            if (child instanceof IREvaluatable) {
                params[i] = ((IREvaluatable)child).eval(context);
            } else {
                params[i] = child;
            }
        }
        return (eval(params, context));
    }

    /**
     * Evaluates against the params.
     *
     * @param params
     * @param context
     * @return Object
     */
    public Object eval(Object[] params, IREvaluationContext context) {
        if (params == null) {
            return (null);
        }
        if (params.length == 0) {
            return (null);
        }
        return (params[params.length -1]);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        if (read_ != null) {
            classNodes.add(read_);
        }
        if (write_ != null) {
            classNodes.add(write_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DReadAndWrite</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        return (isMatchHungry(stack.makeClone()));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DReadAndWrite</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack;
        boolean $match$ = false;
        Element child;
        if (!DRead.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        if (!DWrite.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        return ($match$);
    }
}
