package org.relaxer.dialog.rDialog;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>DEjbMethod</b> is generated from dialog.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="method">
 *   <attribute name="name">
 *     <data type="token"/>
 *   </attribute>
 *   <zeroOrMore>
 *     <ref name="ejbParam"/>
 *   </zeroOrMore>
 *   <zeroOrMore>
 *     <ref name="methodIn"/>
 *   </zeroOrMore>
 *   <zeroOrMore>
 *     <ref name="methodOut"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="method"&gt;
 *   &lt;attribute name="name"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="ejbParam"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="methodIn"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="methodOut"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version dialog.rng (Tue Jun 03 11:20:58 GMT+09:00 2003)
 * @author  Relaxer 1.0beta (http://www.relaxer.org)
 */
public class DEjbMethod implements java.io.Serializable, Cloneable, IREvaluatable, IRNode {
    private String name_;
    // List<DEjbParam>
    private java.util.List ejbParam_ = new java.util.ArrayList();
    // List<DMethodIn>
    private java.util.List methodIn_ = new java.util.ArrayList();
    // List<DMethodOut>
    private java.util.List methodOut_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>DEjbMethod</code>.
     *
     */
    public DEjbMethod() {
        name_ = "";
    }

    /**
     * Creates a <code>DEjbMethod</code>.
     *
     * @param source
     */
    public DEjbMethod(DEjbMethod source) {
        setup(source);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public DEjbMethod(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public DEjbMethod(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>DEjbMethod</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public DEjbMethod(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbMethod(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>DEjbMethod</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbMethod(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbMethod(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbMethod(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbMethod(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbMethod(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>DEjbMethod</code> by the DEjbMethod <code>source</code>.
     *
     * @param source
     */
    public void setup(DEjbMethod source) {
        int size;
        setName(source.getName());
        this.ejbParam_.clear();
        size = source.ejbParam_.size();
        for (int i = 0;i < size;i++) {
            addEjbParam((DEjbParam)source.getEjbParam(i).clone());
        }
        this.methodIn_.clear();
        size = source.methodIn_.size();
        for (int i = 0;i < size;i++) {
            addMethodIn((DMethodIn)source.getMethodIn(i).clone());
        }
        this.methodOut_.clear();
        size = source.methodOut_.size();
        for (int i = 0;i < size;i++) {
            addMethodOut((DMethodOut)source.getMethodOut(i).clone());
        }
    }

    /**
     * Initializes the <code>DEjbMethod</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>DEjbMethod</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>DEjbMethod</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IDialogFactory factory = DialogFactory.getFactory();
        RStack stack = new RStack(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        ejbParam_.clear();
        while (true) {
            if (DEjbParam.isMatch(stack)) {
                addEjbParam(factory.createDEjbParam(stack));
            } else {
                break;
            }
        }
        methodIn_.clear();
        while (true) {
            if (DMethodIn.isMatch(stack)) {
                addMethodIn(factory.createDMethodIn(stack));
            } else {
                break;
            }
        }
        methodOut_.clear();
        while (true) {
            if (DMethodOut.isMatch(stack)) {
                addMethodOut(factory.createDMethodOut(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        IDialogFactory factory = DialogFactory.getFactory();
        return (factory.createDEjbMethod(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("method");
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        size = this.ejbParam_.size();
        for (int i = 0;i < size;i++) {
            DEjbParam value = (DEjbParam)this.ejbParam_.get(i);
            value.makeElement(element);
        }
        size = this.methodIn_.size();
        for (int i = 0;i < size;i++) {
            DMethodIn value = (DMethodIn)this.methodIn_.get(i);
            value.makeElement(element);
        }
        size = this.methodOut_.size();
        for (int i = 0;i < size;i++) {
            DMethodOut value = (DMethodOut)this.methodOut_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>DEjbMethod</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>DEjbMethod</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DEjbMethod</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DEjbMethod</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DEjbMethod</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DEjbMethod</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the DEjbParam property <b>ejbParam</b>.
     *
     * @return DEjbParam[]
     */
    public final DEjbParam[] getEjbParam() {
        DEjbParam[] array = new DEjbParam[ejbParam_.size()];
        return ((DEjbParam[])ejbParam_.toArray(array));
    }

    /**
     * Sets the DEjbParam property <b>ejbParam</b>.
     *
     * @param ejbParam
     */
    public final void setEjbParam(DEjbParam[] ejbParam) {
        this.ejbParam_.clear();
        for (int i = 0;i < ejbParam.length;i++) {
            addEjbParam(ejbParam[i]);
        }
        for (int i = 0;i < ejbParam.length;i++) {
            ejbParam[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the DEjbParam property <b>ejbParam</b>.
     *
     * @param ejbParam
     */
    public final void setEjbParam(DEjbParam ejbParam) {
        this.ejbParam_.clear();
        addEjbParam(ejbParam);
        if (ejbParam != null) {
            ejbParam.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DEjbParam property <b>ejbParam</b>.
     *
     * @param ejbParam
     */
    public final void addEjbParam(DEjbParam ejbParam) {
        this.ejbParam_.add(ejbParam);
        if (ejbParam != null) {
            ejbParam.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DEjbParam property <b>ejbParam</b>.
     *
     * @param ejbParam
     */
    public final void addEjbParam(DEjbParam[] ejbParam) {
        for (int i = 0;i < ejbParam.length;i++) {
            addEjbParam(ejbParam[i]);
        }
        for (int i = 0;i < ejbParam.length;i++) {
            ejbParam[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the DEjbParam property <b>ejbParam</b>.
     *
     * @return int
     */
    public final int sizeEjbParam() {
        return (ejbParam_.size());
    }

    /**
     * Gets the DEjbParam property <b>ejbParam</b> by index.
     *
     * @param index
     * @return DEjbParam
     */
    public final DEjbParam getEjbParam(int index) {
        return ((DEjbParam)ejbParam_.get(index));
    }

    /**
     * Sets the DEjbParam property <b>ejbParam</b> by index.
     *
     * @param index
     * @param ejbParam
     */
    public final void setEjbParam(int index, DEjbParam ejbParam) {
        this.ejbParam_.set(index, ejbParam);
        if (ejbParam != null) {
            ejbParam.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DEjbParam property <b>ejbParam</b> by index.
     *
     * @param index
     * @param ejbParam
     */
    public final void addEjbParam(int index, DEjbParam ejbParam) {
        this.ejbParam_.add(index, ejbParam);
        if (ejbParam != null) {
            ejbParam.rSetParentRNode(this);
        }
    }

    /**
     * Remove the DEjbParam property <b>ejbParam</b> by index.
     *
     * @param index
     */
    public final void removeEjbParam(int index) {
        this.ejbParam_.remove(index);
    }

    /**
     * Remove the DEjbParam property <b>ejbParam</b> by object.
     *
     * @param ejbParam
     */
    public final void removeEjbParam(DEjbParam ejbParam) {
        this.ejbParam_.remove(ejbParam);
    }

    /**
     * Clear the DEjbParam property <b>ejbParam</b>.
     *
     */
    public final void clearEjbParam() {
        this.ejbParam_.clear();
    }

    /**
     * Gets the DMethodIn property <b>methodIn</b>.
     *
     * @return DMethodIn[]
     */
    public final DMethodIn[] getMethodIn() {
        DMethodIn[] array = new DMethodIn[methodIn_.size()];
        return ((DMethodIn[])methodIn_.toArray(array));
    }

    /**
     * Sets the DMethodIn property <b>methodIn</b>.
     *
     * @param methodIn
     */
    public final void setMethodIn(DMethodIn[] methodIn) {
        this.methodIn_.clear();
        for (int i = 0;i < methodIn.length;i++) {
            addMethodIn(methodIn[i]);
        }
        for (int i = 0;i < methodIn.length;i++) {
            methodIn[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the DMethodIn property <b>methodIn</b>.
     *
     * @param methodIn
     */
    public final void setMethodIn(DMethodIn methodIn) {
        this.methodIn_.clear();
        addMethodIn(methodIn);
        if (methodIn != null) {
            methodIn.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DMethodIn property <b>methodIn</b>.
     *
     * @param methodIn
     */
    public final void addMethodIn(DMethodIn methodIn) {
        this.methodIn_.add(methodIn);
        if (methodIn != null) {
            methodIn.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DMethodIn property <b>methodIn</b>.
     *
     * @param methodIn
     */
    public final void addMethodIn(DMethodIn[] methodIn) {
        for (int i = 0;i < methodIn.length;i++) {
            addMethodIn(methodIn[i]);
        }
        for (int i = 0;i < methodIn.length;i++) {
            methodIn[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the DMethodIn property <b>methodIn</b>.
     *
     * @return int
     */
    public final int sizeMethodIn() {
        return (methodIn_.size());
    }

    /**
     * Gets the DMethodIn property <b>methodIn</b> by index.
     *
     * @param index
     * @return DMethodIn
     */
    public final DMethodIn getMethodIn(int index) {
        return ((DMethodIn)methodIn_.get(index));
    }

    /**
     * Sets the DMethodIn property <b>methodIn</b> by index.
     *
     * @param index
     * @param methodIn
     */
    public final void setMethodIn(int index, DMethodIn methodIn) {
        this.methodIn_.set(index, methodIn);
        if (methodIn != null) {
            methodIn.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DMethodIn property <b>methodIn</b> by index.
     *
     * @param index
     * @param methodIn
     */
    public final void addMethodIn(int index, DMethodIn methodIn) {
        this.methodIn_.add(index, methodIn);
        if (methodIn != null) {
            methodIn.rSetParentRNode(this);
        }
    }

    /**
     * Remove the DMethodIn property <b>methodIn</b> by index.
     *
     * @param index
     */
    public final void removeMethodIn(int index) {
        this.methodIn_.remove(index);
    }

    /**
     * Remove the DMethodIn property <b>methodIn</b> by object.
     *
     * @param methodIn
     */
    public final void removeMethodIn(DMethodIn methodIn) {
        this.methodIn_.remove(methodIn);
    }

    /**
     * Clear the DMethodIn property <b>methodIn</b>.
     *
     */
    public final void clearMethodIn() {
        this.methodIn_.clear();
    }

    /**
     * Gets the DMethodOut property <b>methodOut</b>.
     *
     * @return DMethodOut[]
     */
    public final DMethodOut[] getMethodOut() {
        DMethodOut[] array = new DMethodOut[methodOut_.size()];
        return ((DMethodOut[])methodOut_.toArray(array));
    }

    /**
     * Sets the DMethodOut property <b>methodOut</b>.
     *
     * @param methodOut
     */
    public final void setMethodOut(DMethodOut[] methodOut) {
        this.methodOut_.clear();
        for (int i = 0;i < methodOut.length;i++) {
            addMethodOut(methodOut[i]);
        }
        for (int i = 0;i < methodOut.length;i++) {
            methodOut[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the DMethodOut property <b>methodOut</b>.
     *
     * @param methodOut
     */
    public final void setMethodOut(DMethodOut methodOut) {
        this.methodOut_.clear();
        addMethodOut(methodOut);
        if (methodOut != null) {
            methodOut.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DMethodOut property <b>methodOut</b>.
     *
     * @param methodOut
     */
    public final void addMethodOut(DMethodOut methodOut) {
        this.methodOut_.add(methodOut);
        if (methodOut != null) {
            methodOut.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DMethodOut property <b>methodOut</b>.
     *
     * @param methodOut
     */
    public final void addMethodOut(DMethodOut[] methodOut) {
        for (int i = 0;i < methodOut.length;i++) {
            addMethodOut(methodOut[i]);
        }
        for (int i = 0;i < methodOut.length;i++) {
            methodOut[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the DMethodOut property <b>methodOut</b>.
     *
     * @return int
     */
    public final int sizeMethodOut() {
        return (methodOut_.size());
    }

    /**
     * Gets the DMethodOut property <b>methodOut</b> by index.
     *
     * @param index
     * @return DMethodOut
     */
    public final DMethodOut getMethodOut(int index) {
        return ((DMethodOut)methodOut_.get(index));
    }

    /**
     * Sets the DMethodOut property <b>methodOut</b> by index.
     *
     * @param index
     * @param methodOut
     */
    public final void setMethodOut(int index, DMethodOut methodOut) {
        this.methodOut_.set(index, methodOut);
        if (methodOut != null) {
            methodOut.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DMethodOut property <b>methodOut</b> by index.
     *
     * @param index
     * @param methodOut
     */
    public final void addMethodOut(int index, DMethodOut methodOut) {
        this.methodOut_.add(index, methodOut);
        if (methodOut != null) {
            methodOut.rSetParentRNode(this);
        }
    }

    /**
     * Remove the DMethodOut property <b>methodOut</b> by index.
     *
     * @param index
     */
    public final void removeMethodOut(int index) {
        this.methodOut_.remove(index);
    }

    /**
     * Remove the DMethodOut property <b>methodOut</b> by object.
     *
     * @param methodOut
     */
    public final void removeMethodOut(DMethodOut methodOut) {
        this.methodOut_.remove(methodOut);
    }

    /**
     * Clear the DMethodOut property <b>methodOut</b>.
     *
     */
    public final void clearMethodOut() {
        this.methodOut_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<method");
        if (name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.ejbParam_.size();
        for (int i = 0;i < size;i++) {
            DEjbParam value = (DEjbParam)this.ejbParam_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.methodIn_.size();
        for (int i = 0;i < size;i++) {
            DMethodIn value = (DMethodIn)this.methodIn_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.methodOut_.size();
        for (int i = 0;i < size;i++) {
            DMethodOut value = (DMethodOut)this.methodOut_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</method>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<method");
        if (name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        size = this.ejbParam_.size();
        for (int i = 0;i < size;i++) {
            DEjbParam value = (DEjbParam)this.ejbParam_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.methodIn_.size();
        for (int i = 0;i < size;i++) {
            DMethodIn value = (DMethodIn)this.methodIn_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.methodOut_.size();
        for (int i = 0;i < size;i++) {
            DMethodOut value = (DMethodOut)this.methodOut_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</method>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<method");
        if (name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.ejbParam_.size();
        for (int i = 0;i < size;i++) {
            DEjbParam value = (DEjbParam)this.ejbParam_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.methodIn_.size();
        for (int i = 0;i < size;i++) {
            DMethodIn value = (DMethodIn)this.methodIn_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.methodOut_.size();
        for (int i = 0;i < size;i++) {
            DMethodOut value = (DMethodOut)this.methodOut_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</method>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Evaluates the node.
     *
     * @return Object
     */
    public Object eval() {
        return (eval(new RSimpleEvaluationContext()));
    }

    /**
     * Evaluates the node with the evaluation context.
     *
     * @param context
     * @return Object
     */
    public Object eval(IREvaluationContext context) {
        IRNode[] children = rGetRNodes();
        Object[] params = new Object[children.length];
        for (int i = 0;i < children.length;i++) {
            IRNode child = children[i];
            if (child instanceof IREvaluatable) {
                params[i] = ((IREvaluatable)child).eval(context);
            } else {
                params[i] = child;
            }
        }
        return (eval(params, context));
    }

    /**
     * Evaluates against the params.
     *
     * @param params
     * @param context
     * @return Object
     */
    public Object eval(Object[] params, IREvaluationContext context) {
        if (params == null) {
            return (null);
        }
        if (params.length == 0) {
            return (null);
        }
        return (params[params.length -1]);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(ejbParam_);
        classNodes.addAll(methodIn_);
        classNodes.addAll(methodOut_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>DEjbMethod</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "method")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!DEjbParam.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        while (true) {
            if (!DMethodIn.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        while (true) {
            if (!DMethodOut.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DEjbMethod</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DEjbMethod</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
