package org.relaxer.dialog.rDialog;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>DEjbAction</b> is generated from dialog.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="ejb">
 *   <attribute name="uri">
 *     <data type="anyURI"/>
 *   </attribute>
 *   <optional>
 *     <attribute name="javaClass">
 *       <data type="token"/>
 *     </attribute>
 *   </optional>
 *   <ref name="ejbMethod"/>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="ejb"&gt;
 *   &lt;attribute name="uri"&gt;
 *     &lt;data type="anyURI"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;optional&gt;
 *     &lt;attribute name="javaClass"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;ref name="ejbMethod"/&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version dialog.rng (Tue Jun 03 11:20:58 GMT+09:00 2003)
 * @author  Relaxer 1.0beta (http://www.relaxer.org)
 */
public class DEjbAction implements java.io.Serializable, Cloneable, IREvaluatable, IRNode, IDEvaluatableChoice {
    private String uri_;
    private String javaClass_;
    private DEjbMethod ejbMethod_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>DEjbAction</code>.
     *
     */
    public DEjbAction() {
        uri_ = "";
    }

    /**
     * Creates a <code>DEjbAction</code>.
     *
     * @param source
     */
    public DEjbAction(DEjbAction source) {
        setup(source);
    }

    /**
     * Creates a <code>DEjbAction</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public DEjbAction(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>DEjbAction</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public DEjbAction(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>DEjbAction</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public DEjbAction(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>DEjbAction</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbAction(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>DEjbAction</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbAction(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>DEjbAction</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbAction(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>DEjbAction</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbAction(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>DEjbAction</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbAction(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>DEjbAction</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DEjbAction(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>DEjbAction</code> by the DEjbAction <code>source</code>.
     *
     * @param source
     */
    public void setup(DEjbAction source) {
        int size;
        setUri(source.getUri());
        setJavaClass(source.getJavaClass());
        setEjbMethod((DEjbMethod)source.getEjbMethod());
    }

    /**
     * Initializes the <code>DEjbAction</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>DEjbAction</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>DEjbAction</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IDialogFactory factory = DialogFactory.getFactory();
        RStack stack = new RStack(element);
        uri_ = URelaxer.getAttributePropertyAsString(element, "uri");
        javaClass_ = URelaxer.getAttributePropertyAsString(element, "javaClass");
        if (DEjbMethod.isMatch(stack)) {
            setEjbMethod(factory.createDEjbMethod(stack));
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        IDialogFactory factory = DialogFactory.getFactory();
        return (factory.createDEjbAction(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("ejb");
        int size;
        if (this.uri_ != null) {
            URelaxer.setAttributePropertyByString(element, "uri", this.uri_);
        }
        if (this.javaClass_ != null) {
            URelaxer.setAttributePropertyByString(element, "javaClass", this.javaClass_);
        }
        if (this.ejbMethod_ != null) {
            this.ejbMethod_.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>DEjbAction</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>DEjbAction</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DEjbAction</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DEjbAction</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DEjbAction</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DEjbAction</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>uri</b>.
     *
     * @return String
     */
    public final String getUri() {
        return (uri_);
    }

    /**
     * Sets the String property <b>uri</b>.
     *
     * @param uri
     */
    public final void setUri(String uri) {
        this.uri_ = uri;
    }

    /**
     * Gets the String property <b>javaClass</b>.
     *
     * @return String
     */
    public final String getJavaClass() {
        return (javaClass_);
    }

    /**
     * Sets the String property <b>javaClass</b>.
     *
     * @param javaClass
     */
    public final void setJavaClass(String javaClass) {
        this.javaClass_ = javaClass;
    }

    /**
     * Gets the DEjbMethod property <b>ejbMethod</b>.
     *
     * @return DEjbMethod
     */
    public final DEjbMethod getEjbMethod() {
        return (ejbMethod_);
    }

    /**
     * Sets the DEjbMethod property <b>ejbMethod</b>.
     *
     * @param ejbMethod
     */
    public final void setEjbMethod(DEjbMethod ejbMethod) {
        this.ejbMethod_ = ejbMethod;
        if (ejbMethod != null) {
            ejbMethod.rSetParentRNode(this);
        }
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<ejb");
        if (uri_ != null) {
            buffer.append(" uri=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getUri())));
            buffer.append("\"");
        }
        if (javaClass_ != null) {
            buffer.append(" javaClass=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getJavaClass())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (ejbMethod_ != null) {
            ejbMethod_.makeTextElement(buffer);
        }
        buffer.append("</ejb>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<ejb");
        if (uri_ != null) {
            buffer.write(" uri=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getUri())));
            buffer.write("\"");
        }
        if (javaClass_ != null) {
            buffer.write(" javaClass=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getJavaClass())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (ejbMethod_ != null) {
            ejbMethod_.makeTextElement(buffer);
        }
        buffer.write("</ejb>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<ejb");
        if (uri_ != null) {
            buffer.print(" uri=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getUri())));
            buffer.print("\"");
        }
        if (javaClass_ != null) {
            buffer.print(" javaClass=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getJavaClass())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (ejbMethod_ != null) {
            ejbMethod_.makeTextElement(buffer);
        }
        buffer.print("</ejb>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getUriAsString() {
        return (URelaxer.getString(getUri()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getJavaClassAsString() {
        return (URelaxer.getString(getJavaClass()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setUriByString(String string) {
        setUri(URelaxer.getString(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setJavaClassByString(String string) {
        setJavaClass(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Evaluates the node.
     *
     * @return Object
     */
    public Object eval() {
        return (eval(new RSimpleEvaluationContext()));
    }

    /**
     * Evaluates the node with the evaluation context.
     *
     * @param context
     * @return Object
     */
    public Object eval(IREvaluationContext context) {
        IRNode[] children = rGetRNodes();
        Object[] params = new Object[children.length];
        for (int i = 0;i < children.length;i++) {
            IRNode child = children[i];
            if (child instanceof IREvaluatable) {
                params[i] = ((IREvaluatable)child).eval(context);
            } else {
                params[i] = child;
            }
        }
        return (eval(params, context));
    }

    /**
     * Evaluates against the params.
     *
     * @param params
     * @param context
     * @return Object
     */
    public Object eval(Object[] params, IREvaluationContext context) {
        if (params == null) {
            return (null);
        }
        if (params.length == 0) {
            return (null);
        }
        return (params[params.length -1]);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        if (ejbMethod_ != null) {
            classNodes.add(ejbMethod_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>DEjbAction</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "ejb")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "uri")) {
            return (false);
        }
        $match$ = true;
        if (!DEjbMethod.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DEjbAction</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DEjbAction</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
