package org.relaxer.dialog.rDialog;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * AbstractDialogFactory is generated by Relaxer based on dialog.rng.
 *
 * @version dialog.rng 1.0 (Tue Jun 03 11:21:01 GMT+09:00 2003)
 * @author  Relaxer 1.0beta (http://www.relaxer.org)
 */
public abstract class AbstractDialogFactory implements IDialogFactory {
    protected org.xml.sax.ErrorHandler errorHandler;
    protected org.xml.sax.EntityResolver entityResolver;
    protected String baseUri;

    /**
     * Sets a <b>errorHandler</b>.
     *
     * @param errorHandler
     */
    public void setErrorHandler(org.xml.sax.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /**
     * Gets a <b>errorHandler</b>.
     *
     * @return org.xml.sax.ErrorHandler
     */
    public org.xml.sax.ErrorHandler getErrorHandler() {
        return (errorHandler);
    }

    /**
     * Sets a <b>entityResolver</b>.
     *
     * @param entityResolver
     */
    public void setEntityResolver(org.xml.sax.EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    /**
     * Gets a <b>entityResolver</b>.
     *
     * @return org.xml.sax.EntityResolver
     */
    public org.xml.sax.EntityResolver getEntityResolver() {
        return (entityResolver);
    }

    /**
     * Sets a <b>baseUri</b>.
     *
     * @param baseUri
     */
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    /**
     * Gets a <b>baseUri</b>.
     *
     * @return String
     */
    public String getBaseUri() {
        return (baseUri);
    }

    /**
     * Creates a <code>Object</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(File file) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(String uri) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(URL url) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the copy <code>Object</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Object source) throws IOException, SAXException, ParserConfigurationException {
        if (source instanceof DDialog) {
            DDialog node = createDDialog();
            node.setup((DDialog)source);
            return(node);
        } else if (source instanceof DSlot) {
            DSlot node = createDSlot();
            node.setup((DSlot)source);
            return(node);
        } else if (source instanceof DRead) {
            DRead node = createDRead();
            node.setup((DRead)source);
            return(node);
        } else if (source instanceof DJdbc) {
            DJdbc node = createDJdbc();
            node.setup((DJdbc)source);
            return(node);
        } else if (source instanceof DJaxm) {
            DJaxm node = createDJaxm();
            node.setup((DJaxm)source);
            return(node);
        } else if (source instanceof DBean) {
            DBean node = createDBean();
            node.setup((DBean)source);
            return(node);
        } else if (source instanceof DFile) {
            DFile node = createDFile();
            node.setup((DFile)source);
            return(node);
        } else if (source instanceof DJms) {
            DJms node = createDJms();
            node.setup((DJms)source);
            return(node);
        } else if (source instanceof DWrite) {
            DWrite node = createDWrite();
            node.setup((DWrite)source);
            return(node);
        } else if (source instanceof DReadWrite) {
            DReadWrite node = createDReadWrite();
            node.setup((DReadWrite)source);
            return(node);
        } else if (source instanceof DCommand) {
            DCommand node = createDCommand();
            node.setup((DCommand)source);
            return(node);
        } else if (source instanceof DEjbAction) {
            DEjbAction node = createDEjbAction();
            node.setup((DEjbAction)source);
            return(node);
        } else if (source instanceof DEjbMethod) {
            DEjbMethod node = createDEjbMethod();
            node.setup((DEjbMethod)source);
            return(node);
        } else if (source instanceof DEjbParam) {
            DEjbParam node = createDEjbParam();
            node.setup((DEjbParam)source);
            return(node);
        } else if (source instanceof DMethodIn) {
            DMethodIn node = createDMethodIn();
            node.setup((DMethodIn)source);
            return(node);
        } else if (source instanceof DMethodOut) {
            DMethodOut node = createDMethodOut();
            node.setup((DMethodOut)source);
            return(node);
        } else if (source instanceof DBeanAction) {
            DBeanAction node = createDBeanAction();
            node.setup((DBeanAction)source);
            return(node);
        } else if (source instanceof DGenericMethod) {
            DGenericMethod node = createDGenericMethod();
            node.setup((DGenericMethod)source);
            return(node);
        } else if (source instanceof DGenericParam) {
            DGenericParam node = createDGenericParam();
            node.setup((DGenericParam)source);
            return(node);
        } else if (source instanceof DSwitch) {
            DSwitch node = createDSwitch();
            node.setup((DSwitch)source);
            return(node);
        } else if (source instanceof DCase) {
            DCase node = createDCase();
            node.setup((DCase)source);
            return(node);
        } else if (source instanceof DJaxmAction) {
            DJaxmAction node = createDJaxmAction();
            node.setup((DJaxmAction)source);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>Object</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Document doc) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(doc.getDocumentElement());
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Element element) throws IOException, SAXException, ParserConfigurationException {
        if (DDialog.isMatch(element)) {
            DDialog node = createDDialog();
            node.setup(element);
            return(node);
        } else if (DSlot.isMatch(element)) {
            DSlot node = createDSlot();
            node.setup(element);
            return(node);
        } else if (DRead.isMatch(element)) {
            DRead node = createDRead();
            node.setup(element);
            return(node);
        } else if (DJdbc.isMatch(element)) {
            DJdbc node = createDJdbc();
            node.setup(element);
            return(node);
        } else if (DJaxm.isMatch(element)) {
            DJaxm node = createDJaxm();
            node.setup(element);
            return(node);
        } else if (DBean.isMatch(element)) {
            DBean node = createDBean();
            node.setup(element);
            return(node);
        } else if (DFile.isMatch(element)) {
            DFile node = createDFile();
            node.setup(element);
            return(node);
        } else if (DJms.isMatch(element)) {
            DJms node = createDJms();
            node.setup(element);
            return(node);
        } else if (DWrite.isMatch(element)) {
            DWrite node = createDWrite();
            node.setup(element);
            return(node);
        } else if (DReadWrite.isMatch(element)) {
            DReadWrite node = createDReadWrite();
            node.setup(element);
            return(node);
        } else if (DCommand.isMatch(element)) {
            DCommand node = createDCommand();
            node.setup(element);
            return(node);
        } else if (DEjbAction.isMatch(element)) {
            DEjbAction node = createDEjbAction();
            node.setup(element);
            return(node);
        } else if (DEjbMethod.isMatch(element)) {
            DEjbMethod node = createDEjbMethod();
            node.setup(element);
            return(node);
        } else if (DEjbParam.isMatch(element)) {
            DEjbParam node = createDEjbParam();
            node.setup(element);
            return(node);
        } else if (DMethodIn.isMatch(element)) {
            DMethodIn node = createDMethodIn();
            node.setup(element);
            return(node);
        } else if (DMethodOut.isMatch(element)) {
            DMethodOut node = createDMethodOut();
            node.setup(element);
            return(node);
        } else if (DBeanAction.isMatch(element)) {
            DBeanAction node = createDBeanAction();
            node.setup(element);
            return(node);
        } else if (DGenericMethod.isMatch(element)) {
            DGenericMethod node = createDGenericMethod();
            node.setup(element);
            return(node);
        } else if (DGenericParam.isMatch(element)) {
            DGenericParam node = createDGenericParam();
            node.setup(element);
            return(node);
        } else if (DSwitch.isMatch(element)) {
            DSwitch node = createDSwitch();
            node.setup(element);
            return(node);
        } else if (DCase.isMatch(element)) {
            DCase node = createDCase();
            node.setup(element);
            return(node);
        } else if (DJaxmAction.isMatch(element)) {
            DJaxmAction node = createDJaxmAction();
            node.setup(element);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>DDialog</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    public DDialog createDDialog(File file) throws IOException, SAXException, ParserConfigurationException {
        DDialog dDialog_ = createDDialog();
        dDialog_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dDialog_);
    }

    /**
     * Creates a <code>DSlot</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    public DSlot createDSlot(File file) throws IOException, SAXException, ParserConfigurationException {
        DSlot dSlot_ = createDSlot();
        dSlot_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSlot_);
    }

    /**
     * Creates a <code>DRead</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    public DRead createDRead(File file) throws IOException, SAXException, ParserConfigurationException {
        DRead dRead_ = createDRead();
        dRead_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dRead_);
    }

    /**
     * Creates a <code>DJdbc</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    public DJdbc createDJdbc(File file) throws IOException, SAXException, ParserConfigurationException {
        DJdbc dJdbc_ = createDJdbc();
        dJdbc_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJdbc_);
    }

    /**
     * Creates a <code>DJaxm</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    public DJaxm createDJaxm(File file) throws IOException, SAXException, ParserConfigurationException {
        DJaxm dJaxm_ = createDJaxm();
        dJaxm_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxm_);
    }

    /**
     * Creates a <code>DBean</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    public DBean createDBean(File file) throws IOException, SAXException, ParserConfigurationException {
        DBean dBean_ = createDBean();
        dBean_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBean_);
    }

    /**
     * Creates a <code>DFile</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    public DFile createDFile(File file) throws IOException, SAXException, ParserConfigurationException {
        DFile dFile_ = createDFile();
        dFile_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dFile_);
    }

    /**
     * Creates a <code>DJms</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    public DJms createDJms(File file) throws IOException, SAXException, ParserConfigurationException {
        DJms dJms_ = createDJms();
        dJms_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJms_);
    }

    /**
     * Creates a <code>DWrite</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    public DWrite createDWrite(File file) throws IOException, SAXException, ParserConfigurationException {
        DWrite dWrite_ = createDWrite();
        dWrite_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dWrite_);
    }

    /**
     * Creates a <code>DReadWrite</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    public DReadWrite createDReadWrite(File file) throws IOException, SAXException, ParserConfigurationException {
        DReadWrite dReadWrite_ = createDReadWrite();
        dReadWrite_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dReadWrite_);
    }

    /**
     * Creates a <code>DCommand</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    public DCommand createDCommand(File file) throws IOException, SAXException, ParserConfigurationException {
        DCommand dCommand_ = createDCommand();
        dCommand_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCommand_);
    }

    /**
     * Creates a <code>DEjbAction</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    public DEjbAction createDEjbAction(File file) throws IOException, SAXException, ParserConfigurationException {
        DEjbAction dEjbAction_ = createDEjbAction();
        dEjbAction_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbAction_);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    public DEjbMethod createDEjbMethod(File file) throws IOException, SAXException, ParserConfigurationException {
        DEjbMethod dEjbMethod_ = createDEjbMethod();
        dEjbMethod_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbMethod_);
    }

    /**
     * Creates a <code>DEjbParam</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    public DEjbParam createDEjbParam(File file) throws IOException, SAXException, ParserConfigurationException {
        DEjbParam dEjbParam_ = createDEjbParam();
        dEjbParam_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbParam_);
    }

    /**
     * Creates a <code>DMethodIn</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodIn
     */
    public DMethodIn createDMethodIn(File file) throws IOException, SAXException, ParserConfigurationException {
        DMethodIn dMethodIn_ = createDMethodIn();
        dMethodIn_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodIn_);
    }

    /**
     * Creates a <code>DMethodOut</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodOut
     */
    public DMethodOut createDMethodOut(File file) throws IOException, SAXException, ParserConfigurationException {
        DMethodOut dMethodOut_ = createDMethodOut();
        dMethodOut_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodOut_);
    }

    /**
     * Creates a <code>DBeanAction</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    public DBeanAction createDBeanAction(File file) throws IOException, SAXException, ParserConfigurationException {
        DBeanAction dBeanAction_ = createDBeanAction();
        dBeanAction_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBeanAction_);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    public DGenericMethod createDGenericMethod(File file) throws IOException, SAXException, ParserConfigurationException {
        DGenericMethod dGenericMethod_ = createDGenericMethod();
        dGenericMethod_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericMethod_);
    }

    /**
     * Creates a <code>DGenericParam</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    public DGenericParam createDGenericParam(File file) throws IOException, SAXException, ParserConfigurationException {
        DGenericParam dGenericParam_ = createDGenericParam();
        dGenericParam_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericParam_);
    }

    /**
     * Creates a <code>DSwitch</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    public DSwitch createDSwitch(File file) throws IOException, SAXException, ParserConfigurationException {
        DSwitch dSwitch_ = createDSwitch();
        dSwitch_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSwitch_);
    }

    /**
     * Creates a <code>DCase</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    public DCase createDCase(File file) throws IOException, SAXException, ParserConfigurationException {
        DCase dCase_ = createDCase();
        dCase_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCase_);
    }

    /**
     * Creates a <code>DJaxmAction</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    public DJaxmAction createDJaxmAction(File file) throws IOException, SAXException, ParserConfigurationException {
        DJaxmAction dJaxmAction_ = createDJaxmAction();
        dJaxmAction_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxmAction_);
    }

    /**
     * Creates a <code>DDialog</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    public DDialog createDDialog(String uri) throws IOException, SAXException, ParserConfigurationException {
        DDialog dDialog_ = createDDialog();
        dDialog_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dDialog_);
    }

    /**
     * Creates a <code>DSlot</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    public DSlot createDSlot(String uri) throws IOException, SAXException, ParserConfigurationException {
        DSlot dSlot_ = createDSlot();
        dSlot_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSlot_);
    }

    /**
     * Creates a <code>DRead</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    public DRead createDRead(String uri) throws IOException, SAXException, ParserConfigurationException {
        DRead dRead_ = createDRead();
        dRead_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dRead_);
    }

    /**
     * Creates a <code>DJdbc</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    public DJdbc createDJdbc(String uri) throws IOException, SAXException, ParserConfigurationException {
        DJdbc dJdbc_ = createDJdbc();
        dJdbc_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJdbc_);
    }

    /**
     * Creates a <code>DJaxm</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    public DJaxm createDJaxm(String uri) throws IOException, SAXException, ParserConfigurationException {
        DJaxm dJaxm_ = createDJaxm();
        dJaxm_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxm_);
    }

    /**
     * Creates a <code>DBean</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    public DBean createDBean(String uri) throws IOException, SAXException, ParserConfigurationException {
        DBean dBean_ = createDBean();
        dBean_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBean_);
    }

    /**
     * Creates a <code>DFile</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    public DFile createDFile(String uri) throws IOException, SAXException, ParserConfigurationException {
        DFile dFile_ = createDFile();
        dFile_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dFile_);
    }

    /**
     * Creates a <code>DJms</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    public DJms createDJms(String uri) throws IOException, SAXException, ParserConfigurationException {
        DJms dJms_ = createDJms();
        dJms_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJms_);
    }

    /**
     * Creates a <code>DWrite</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    public DWrite createDWrite(String uri) throws IOException, SAXException, ParserConfigurationException {
        DWrite dWrite_ = createDWrite();
        dWrite_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dWrite_);
    }

    /**
     * Creates a <code>DReadWrite</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    public DReadWrite createDReadWrite(String uri) throws IOException, SAXException, ParserConfigurationException {
        DReadWrite dReadWrite_ = createDReadWrite();
        dReadWrite_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dReadWrite_);
    }

    /**
     * Creates a <code>DCommand</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    public DCommand createDCommand(String uri) throws IOException, SAXException, ParserConfigurationException {
        DCommand dCommand_ = createDCommand();
        dCommand_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCommand_);
    }

    /**
     * Creates a <code>DEjbAction</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    public DEjbAction createDEjbAction(String uri) throws IOException, SAXException, ParserConfigurationException {
        DEjbAction dEjbAction_ = createDEjbAction();
        dEjbAction_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbAction_);
    }

    /**
     * Creates a <code>DEjbMethod</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    public DEjbMethod createDEjbMethod(String uri) throws IOException, SAXException, ParserConfigurationException {
        DEjbMethod dEjbMethod_ = createDEjbMethod();
        dEjbMethod_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbMethod_);
    }

    /**
     * Creates a <code>DEjbParam</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    public DEjbParam createDEjbParam(String uri) throws IOException, SAXException, ParserConfigurationException {
        DEjbParam dEjbParam_ = createDEjbParam();
        dEjbParam_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbParam_);
    }

    /**
     * Creates a <code>DMethodIn</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodIn
     */
    public DMethodIn createDMethodIn(String uri) throws IOException, SAXException, ParserConfigurationException {
        DMethodIn dMethodIn_ = createDMethodIn();
        dMethodIn_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodIn_);
    }

    /**
     * Creates a <code>DMethodOut</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodOut
     */
    public DMethodOut createDMethodOut(String uri) throws IOException, SAXException, ParserConfigurationException {
        DMethodOut dMethodOut_ = createDMethodOut();
        dMethodOut_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodOut_);
    }

    /**
     * Creates a <code>DBeanAction</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    public DBeanAction createDBeanAction(String uri) throws IOException, SAXException, ParserConfigurationException {
        DBeanAction dBeanAction_ = createDBeanAction();
        dBeanAction_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBeanAction_);
    }

    /**
     * Creates a <code>DGenericMethod</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    public DGenericMethod createDGenericMethod(String uri) throws IOException, SAXException, ParserConfigurationException {
        DGenericMethod dGenericMethod_ = createDGenericMethod();
        dGenericMethod_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericMethod_);
    }

    /**
     * Creates a <code>DGenericParam</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    public DGenericParam createDGenericParam(String uri) throws IOException, SAXException, ParserConfigurationException {
        DGenericParam dGenericParam_ = createDGenericParam();
        dGenericParam_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericParam_);
    }

    /**
     * Creates a <code>DSwitch</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    public DSwitch createDSwitch(String uri) throws IOException, SAXException, ParserConfigurationException {
        DSwitch dSwitch_ = createDSwitch();
        dSwitch_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSwitch_);
    }

    /**
     * Creates a <code>DCase</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    public DCase createDCase(String uri) throws IOException, SAXException, ParserConfigurationException {
        DCase dCase_ = createDCase();
        dCase_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCase_);
    }

    /**
     * Creates a <code>DJaxmAction</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    public DJaxmAction createDJaxmAction(String uri) throws IOException, SAXException, ParserConfigurationException {
        DJaxmAction dJaxmAction_ = createDJaxmAction();
        dJaxmAction_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxmAction_);
    }

    /**
     * Creates a <code>DDialog</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    public DDialog createDDialog(URL url) throws IOException, SAXException, ParserConfigurationException {
        DDialog dDialog_ = createDDialog();
        dDialog_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dDialog_);
    }

    /**
     * Creates a <code>DSlot</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    public DSlot createDSlot(URL url) throws IOException, SAXException, ParserConfigurationException {
        DSlot dSlot_ = createDSlot();
        dSlot_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSlot_);
    }

    /**
     * Creates a <code>DRead</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    public DRead createDRead(URL url) throws IOException, SAXException, ParserConfigurationException {
        DRead dRead_ = createDRead();
        dRead_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dRead_);
    }

    /**
     * Creates a <code>DJdbc</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    public DJdbc createDJdbc(URL url) throws IOException, SAXException, ParserConfigurationException {
        DJdbc dJdbc_ = createDJdbc();
        dJdbc_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJdbc_);
    }

    /**
     * Creates a <code>DJaxm</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    public DJaxm createDJaxm(URL url) throws IOException, SAXException, ParserConfigurationException {
        DJaxm dJaxm_ = createDJaxm();
        dJaxm_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxm_);
    }

    /**
     * Creates a <code>DBean</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    public DBean createDBean(URL url) throws IOException, SAXException, ParserConfigurationException {
        DBean dBean_ = createDBean();
        dBean_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBean_);
    }

    /**
     * Creates a <code>DFile</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    public DFile createDFile(URL url) throws IOException, SAXException, ParserConfigurationException {
        DFile dFile_ = createDFile();
        dFile_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dFile_);
    }

    /**
     * Creates a <code>DJms</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    public DJms createDJms(URL url) throws IOException, SAXException, ParserConfigurationException {
        DJms dJms_ = createDJms();
        dJms_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJms_);
    }

    /**
     * Creates a <code>DWrite</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    public DWrite createDWrite(URL url) throws IOException, SAXException, ParserConfigurationException {
        DWrite dWrite_ = createDWrite();
        dWrite_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dWrite_);
    }

    /**
     * Creates a <code>DReadWrite</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    public DReadWrite createDReadWrite(URL url) throws IOException, SAXException, ParserConfigurationException {
        DReadWrite dReadWrite_ = createDReadWrite();
        dReadWrite_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dReadWrite_);
    }

    /**
     * Creates a <code>DCommand</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    public DCommand createDCommand(URL url) throws IOException, SAXException, ParserConfigurationException {
        DCommand dCommand_ = createDCommand();
        dCommand_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCommand_);
    }

    /**
     * Creates a <code>DEjbAction</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    public DEjbAction createDEjbAction(URL url) throws IOException, SAXException, ParserConfigurationException {
        DEjbAction dEjbAction_ = createDEjbAction();
        dEjbAction_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbAction_);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    public DEjbMethod createDEjbMethod(URL url) throws IOException, SAXException, ParserConfigurationException {
        DEjbMethod dEjbMethod_ = createDEjbMethod();
        dEjbMethod_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbMethod_);
    }

    /**
     * Creates a <code>DEjbParam</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    public DEjbParam createDEjbParam(URL url) throws IOException, SAXException, ParserConfigurationException {
        DEjbParam dEjbParam_ = createDEjbParam();
        dEjbParam_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbParam_);
    }

    /**
     * Creates a <code>DMethodIn</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodIn
     */
    public DMethodIn createDMethodIn(URL url) throws IOException, SAXException, ParserConfigurationException {
        DMethodIn dMethodIn_ = createDMethodIn();
        dMethodIn_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodIn_);
    }

    /**
     * Creates a <code>DMethodOut</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodOut
     */
    public DMethodOut createDMethodOut(URL url) throws IOException, SAXException, ParserConfigurationException {
        DMethodOut dMethodOut_ = createDMethodOut();
        dMethodOut_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodOut_);
    }

    /**
     * Creates a <code>DBeanAction</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    public DBeanAction createDBeanAction(URL url) throws IOException, SAXException, ParserConfigurationException {
        DBeanAction dBeanAction_ = createDBeanAction();
        dBeanAction_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBeanAction_);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    public DGenericMethod createDGenericMethod(URL url) throws IOException, SAXException, ParserConfigurationException {
        DGenericMethod dGenericMethod_ = createDGenericMethod();
        dGenericMethod_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericMethod_);
    }

    /**
     * Creates a <code>DGenericParam</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    public DGenericParam createDGenericParam(URL url) throws IOException, SAXException, ParserConfigurationException {
        DGenericParam dGenericParam_ = createDGenericParam();
        dGenericParam_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericParam_);
    }

    /**
     * Creates a <code>DSwitch</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    public DSwitch createDSwitch(URL url) throws IOException, SAXException, ParserConfigurationException {
        DSwitch dSwitch_ = createDSwitch();
        dSwitch_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSwitch_);
    }

    /**
     * Creates a <code>DCase</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    public DCase createDCase(URL url) throws IOException, SAXException, ParserConfigurationException {
        DCase dCase_ = createDCase();
        dCase_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCase_);
    }

    /**
     * Creates a <code>DJaxmAction</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    public DJaxmAction createDJaxmAction(URL url) throws IOException, SAXException, ParserConfigurationException {
        DJaxmAction dJaxmAction_ = createDJaxmAction();
        dJaxmAction_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxmAction_);
    }

    /**
     * Creates a <code>DDialog</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    public DDialog createDDialog(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DDialog dDialog_ = createDDialog();
        dDialog_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dDialog_);
    }

    /**
     * Creates a <code>DSlot</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    public DSlot createDSlot(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DSlot dSlot_ = createDSlot();
        dSlot_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSlot_);
    }

    /**
     * Creates a <code>DRead</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    public DRead createDRead(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DRead dRead_ = createDRead();
        dRead_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dRead_);
    }

    /**
     * Creates a <code>DJdbc</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    public DJdbc createDJdbc(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DJdbc dJdbc_ = createDJdbc();
        dJdbc_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJdbc_);
    }

    /**
     * Creates a <code>DJaxm</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    public DJaxm createDJaxm(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DJaxm dJaxm_ = createDJaxm();
        dJaxm_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxm_);
    }

    /**
     * Creates a <code>DBean</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    public DBean createDBean(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DBean dBean_ = createDBean();
        dBean_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBean_);
    }

    /**
     * Creates a <code>DFile</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    public DFile createDFile(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DFile dFile_ = createDFile();
        dFile_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dFile_);
    }

    /**
     * Creates a <code>DJms</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    public DJms createDJms(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DJms dJms_ = createDJms();
        dJms_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJms_);
    }

    /**
     * Creates a <code>DWrite</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    public DWrite createDWrite(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DWrite dWrite_ = createDWrite();
        dWrite_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dWrite_);
    }

    /**
     * Creates a <code>DReadWrite</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    public DReadWrite createDReadWrite(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DReadWrite dReadWrite_ = createDReadWrite();
        dReadWrite_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dReadWrite_);
    }

    /**
     * Creates a <code>DCommand</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    public DCommand createDCommand(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DCommand dCommand_ = createDCommand();
        dCommand_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCommand_);
    }

    /**
     * Creates a <code>DEjbAction</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    public DEjbAction createDEjbAction(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DEjbAction dEjbAction_ = createDEjbAction();
        dEjbAction_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbAction_);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    public DEjbMethod createDEjbMethod(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DEjbMethod dEjbMethod_ = createDEjbMethod();
        dEjbMethod_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbMethod_);
    }

    /**
     * Creates a <code>DEjbParam</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    public DEjbParam createDEjbParam(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DEjbParam dEjbParam_ = createDEjbParam();
        dEjbParam_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbParam_);
    }

    /**
     * Creates a <code>DMethodIn</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodIn
     */
    public DMethodIn createDMethodIn(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DMethodIn dMethodIn_ = createDMethodIn();
        dMethodIn_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodIn_);
    }

    /**
     * Creates a <code>DMethodOut</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodOut
     */
    public DMethodOut createDMethodOut(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DMethodOut dMethodOut_ = createDMethodOut();
        dMethodOut_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodOut_);
    }

    /**
     * Creates a <code>DBeanAction</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    public DBeanAction createDBeanAction(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DBeanAction dBeanAction_ = createDBeanAction();
        dBeanAction_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBeanAction_);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    public DGenericMethod createDGenericMethod(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DGenericMethod dGenericMethod_ = createDGenericMethod();
        dGenericMethod_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericMethod_);
    }

    /**
     * Creates a <code>DGenericParam</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    public DGenericParam createDGenericParam(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DGenericParam dGenericParam_ = createDGenericParam();
        dGenericParam_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericParam_);
    }

    /**
     * Creates a <code>DSwitch</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    public DSwitch createDSwitch(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DSwitch dSwitch_ = createDSwitch();
        dSwitch_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSwitch_);
    }

    /**
     * Creates a <code>DCase</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    public DCase createDCase(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DCase dCase_ = createDCase();
        dCase_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCase_);
    }

    /**
     * Creates a <code>DJaxmAction</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    public DJaxmAction createDJaxmAction(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DJaxmAction dJaxmAction_ = createDJaxmAction();
        dJaxmAction_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxmAction_);
    }

    /**
     * Creates a <code>DDialog</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    public DDialog createDDialog(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DDialog dDialog_ = createDDialog();
        dDialog_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dDialog_);
    }

    /**
     * Creates a <code>DSlot</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    public DSlot createDSlot(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DSlot dSlot_ = createDSlot();
        dSlot_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSlot_);
    }

    /**
     * Creates a <code>DRead</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    public DRead createDRead(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DRead dRead_ = createDRead();
        dRead_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dRead_);
    }

    /**
     * Creates a <code>DJdbc</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    public DJdbc createDJdbc(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DJdbc dJdbc_ = createDJdbc();
        dJdbc_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJdbc_);
    }

    /**
     * Creates a <code>DJaxm</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    public DJaxm createDJaxm(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DJaxm dJaxm_ = createDJaxm();
        dJaxm_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxm_);
    }

    /**
     * Creates a <code>DBean</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    public DBean createDBean(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DBean dBean_ = createDBean();
        dBean_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBean_);
    }

    /**
     * Creates a <code>DFile</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    public DFile createDFile(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DFile dFile_ = createDFile();
        dFile_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dFile_);
    }

    /**
     * Creates a <code>DJms</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    public DJms createDJms(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DJms dJms_ = createDJms();
        dJms_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJms_);
    }

    /**
     * Creates a <code>DWrite</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    public DWrite createDWrite(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DWrite dWrite_ = createDWrite();
        dWrite_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dWrite_);
    }

    /**
     * Creates a <code>DReadWrite</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    public DReadWrite createDReadWrite(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DReadWrite dReadWrite_ = createDReadWrite();
        dReadWrite_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dReadWrite_);
    }

    /**
     * Creates a <code>DCommand</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    public DCommand createDCommand(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DCommand dCommand_ = createDCommand();
        dCommand_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCommand_);
    }

    /**
     * Creates a <code>DEjbAction</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    public DEjbAction createDEjbAction(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DEjbAction dEjbAction_ = createDEjbAction();
        dEjbAction_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbAction_);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    public DEjbMethod createDEjbMethod(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DEjbMethod dEjbMethod_ = createDEjbMethod();
        dEjbMethod_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbMethod_);
    }

    /**
     * Creates a <code>DEjbParam</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    public DEjbParam createDEjbParam(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DEjbParam dEjbParam_ = createDEjbParam();
        dEjbParam_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbParam_);
    }

    /**
     * Creates a <code>DMethodIn</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodIn
     */
    public DMethodIn createDMethodIn(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DMethodIn dMethodIn_ = createDMethodIn();
        dMethodIn_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodIn_);
    }

    /**
     * Creates a <code>DMethodOut</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodOut
     */
    public DMethodOut createDMethodOut(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DMethodOut dMethodOut_ = createDMethodOut();
        dMethodOut_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodOut_);
    }

    /**
     * Creates a <code>DBeanAction</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    public DBeanAction createDBeanAction(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DBeanAction dBeanAction_ = createDBeanAction();
        dBeanAction_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBeanAction_);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    public DGenericMethod createDGenericMethod(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DGenericMethod dGenericMethod_ = createDGenericMethod();
        dGenericMethod_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericMethod_);
    }

    /**
     * Creates a <code>DGenericParam</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    public DGenericParam createDGenericParam(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DGenericParam dGenericParam_ = createDGenericParam();
        dGenericParam_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericParam_);
    }

    /**
     * Creates a <code>DSwitch</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    public DSwitch createDSwitch(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DSwitch dSwitch_ = createDSwitch();
        dSwitch_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSwitch_);
    }

    /**
     * Creates a <code>DCase</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    public DCase createDCase(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DCase dCase_ = createDCase();
        dCase_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCase_);
    }

    /**
     * Creates a <code>DJaxmAction</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    public DJaxmAction createDJaxmAction(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        DJaxmAction dJaxmAction_ = createDJaxmAction();
        dJaxmAction_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxmAction_);
    }

    /**
     * Creates a <code>DDialog</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DDialog
     */
    public DDialog createDDialog(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DDialog dDialog_ = createDDialog();
        dDialog_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dDialog_);
    }

    /**
     * Creates a <code>DSlot</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSlot
     */
    public DSlot createDSlot(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DSlot dSlot_ = createDSlot();
        dSlot_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSlot_);
    }

    /**
     * Creates a <code>DRead</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DRead
     */
    public DRead createDRead(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DRead dRead_ = createDRead();
        dRead_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dRead_);
    }

    /**
     * Creates a <code>DJdbc</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJdbc
     */
    public DJdbc createDJdbc(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DJdbc dJdbc_ = createDJdbc();
        dJdbc_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJdbc_);
    }

    /**
     * Creates a <code>DJaxm</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxm
     */
    public DJaxm createDJaxm(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DJaxm dJaxm_ = createDJaxm();
        dJaxm_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxm_);
    }

    /**
     * Creates a <code>DBean</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBean
     */
    public DBean createDBean(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DBean dBean_ = createDBean();
        dBean_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBean_);
    }

    /**
     * Creates a <code>DFile</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DFile
     */
    public DFile createDFile(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DFile dFile_ = createDFile();
        dFile_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dFile_);
    }

    /**
     * Creates a <code>DJms</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJms
     */
    public DJms createDJms(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DJms dJms_ = createDJms();
        dJms_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJms_);
    }

    /**
     * Creates a <code>DWrite</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DWrite
     */
    public DWrite createDWrite(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DWrite dWrite_ = createDWrite();
        dWrite_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dWrite_);
    }

    /**
     * Creates a <code>DReadWrite</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DReadWrite
     */
    public DReadWrite createDReadWrite(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DReadWrite dReadWrite_ = createDReadWrite();
        dReadWrite_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dReadWrite_);
    }

    /**
     * Creates a <code>DCommand</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCommand
     */
    public DCommand createDCommand(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DCommand dCommand_ = createDCommand();
        dCommand_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCommand_);
    }

    /**
     * Creates a <code>DEjbAction</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbAction
     */
    public DEjbAction createDEjbAction(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DEjbAction dEjbAction_ = createDEjbAction();
        dEjbAction_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbAction_);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbMethod
     */
    public DEjbMethod createDEjbMethod(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DEjbMethod dEjbMethod_ = createDEjbMethod();
        dEjbMethod_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbMethod_);
    }

    /**
     * Creates a <code>DEjbParam</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DEjbParam
     */
    public DEjbParam createDEjbParam(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DEjbParam dEjbParam_ = createDEjbParam();
        dEjbParam_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dEjbParam_);
    }

    /**
     * Creates a <code>DMethodIn</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodIn
     */
    public DMethodIn createDMethodIn(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DMethodIn dMethodIn_ = createDMethodIn();
        dMethodIn_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodIn_);
    }

    /**
     * Creates a <code>DMethodOut</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DMethodOut
     */
    public DMethodOut createDMethodOut(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DMethodOut dMethodOut_ = createDMethodOut();
        dMethodOut_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dMethodOut_);
    }

    /**
     * Creates a <code>DBeanAction</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DBeanAction
     */
    public DBeanAction createDBeanAction(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DBeanAction dBeanAction_ = createDBeanAction();
        dBeanAction_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dBeanAction_);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericMethod
     */
    public DGenericMethod createDGenericMethod(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DGenericMethod dGenericMethod_ = createDGenericMethod();
        dGenericMethod_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericMethod_);
    }

    /**
     * Creates a <code>DGenericParam</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DGenericParam
     */
    public DGenericParam createDGenericParam(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DGenericParam dGenericParam_ = createDGenericParam();
        dGenericParam_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dGenericParam_);
    }

    /**
     * Creates a <code>DSwitch</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DSwitch
     */
    public DSwitch createDSwitch(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DSwitch dSwitch_ = createDSwitch();
        dSwitch_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dSwitch_);
    }

    /**
     * Creates a <code>DCase</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DCase
     */
    public DCase createDCase(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DCase dCase_ = createDCase();
        dCase_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dCase_);
    }

    /**
     * Creates a <code>DJaxmAction</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return DJaxmAction
     */
    public DJaxmAction createDJaxmAction(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DJaxmAction dJaxmAction_ = createDJaxmAction();
        dJaxmAction_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (dJaxmAction_);
    }

    /**
     * Creates a <code>DDialog</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DDialog
     */
    public DDialog createDDialog(DDialog source) {
        DDialog dDialog_ = createDDialog();
        dDialog_.setup(source);
        return (dDialog_);
    }

    /**
     * Creates a <code>DSlot</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DSlot
     */
    public DSlot createDSlot(DSlot source) {
        DSlot dSlot_ = createDSlot();
        dSlot_.setup(source);
        return (dSlot_);
    }

    /**
     * Creates a <code>DRead</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DRead
     */
    public DRead createDRead(DRead source) {
        DRead dRead_ = createDRead();
        dRead_.setup(source);
        return (dRead_);
    }

    /**
     * Creates a <code>DJdbc</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DJdbc
     */
    public DJdbc createDJdbc(DJdbc source) {
        DJdbc dJdbc_ = createDJdbc();
        dJdbc_.setup(source);
        return (dJdbc_);
    }

    /**
     * Creates a <code>DJaxm</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DJaxm
     */
    public DJaxm createDJaxm(DJaxm source) {
        DJaxm dJaxm_ = createDJaxm();
        dJaxm_.setup(source);
        return (dJaxm_);
    }

    /**
     * Creates a <code>DBean</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DBean
     */
    public DBean createDBean(DBean source) {
        DBean dBean_ = createDBean();
        dBean_.setup(source);
        return (dBean_);
    }

    /**
     * Creates a <code>DFile</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DFile
     */
    public DFile createDFile(DFile source) {
        DFile dFile_ = createDFile();
        dFile_.setup(source);
        return (dFile_);
    }

    /**
     * Creates a <code>DJms</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DJms
     */
    public DJms createDJms(DJms source) {
        DJms dJms_ = createDJms();
        dJms_.setup(source);
        return (dJms_);
    }

    /**
     * Creates a <code>DWrite</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DWrite
     */
    public DWrite createDWrite(DWrite source) {
        DWrite dWrite_ = createDWrite();
        dWrite_.setup(source);
        return (dWrite_);
    }

    /**
     * Creates a <code>DReadWrite</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DReadWrite
     */
    public DReadWrite createDReadWrite(DReadWrite source) {
        DReadWrite dReadWrite_ = createDReadWrite();
        dReadWrite_.setup(source);
        return (dReadWrite_);
    }

    /**
     * Creates a <code>DCommand</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DCommand
     */
    public DCommand createDCommand(DCommand source) {
        DCommand dCommand_ = createDCommand();
        dCommand_.setup(source);
        return (dCommand_);
    }

    /**
     * Creates a <code>DEjbAction</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DEjbAction
     */
    public DEjbAction createDEjbAction(DEjbAction source) {
        DEjbAction dEjbAction_ = createDEjbAction();
        dEjbAction_.setup(source);
        return (dEjbAction_);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DEjbMethod
     */
    public DEjbMethod createDEjbMethod(DEjbMethod source) {
        DEjbMethod dEjbMethod_ = createDEjbMethod();
        dEjbMethod_.setup(source);
        return (dEjbMethod_);
    }

    /**
     * Creates a <code>DEjbParam</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DEjbParam
     */
    public DEjbParam createDEjbParam(DEjbParam source) {
        DEjbParam dEjbParam_ = createDEjbParam();
        dEjbParam_.setup(source);
        return (dEjbParam_);
    }

    /**
     * Creates a <code>DMethodIn</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DMethodIn
     */
    public DMethodIn createDMethodIn(DMethodIn source) {
        DMethodIn dMethodIn_ = createDMethodIn();
        dMethodIn_.setup(source);
        return (dMethodIn_);
    }

    /**
     * Creates a <code>DMethodOut</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DMethodOut
     */
    public DMethodOut createDMethodOut(DMethodOut source) {
        DMethodOut dMethodOut_ = createDMethodOut();
        dMethodOut_.setup(source);
        return (dMethodOut_);
    }

    /**
     * Creates a <code>DBeanAction</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DBeanAction
     */
    public DBeanAction createDBeanAction(DBeanAction source) {
        DBeanAction dBeanAction_ = createDBeanAction();
        dBeanAction_.setup(source);
        return (dBeanAction_);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DGenericMethod
     */
    public DGenericMethod createDGenericMethod(DGenericMethod source) {
        DGenericMethod dGenericMethod_ = createDGenericMethod();
        dGenericMethod_.setup(source);
        return (dGenericMethod_);
    }

    /**
     * Creates a <code>DGenericParam</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DGenericParam
     */
    public DGenericParam createDGenericParam(DGenericParam source) {
        DGenericParam dGenericParam_ = createDGenericParam();
        dGenericParam_.setup(source);
        return (dGenericParam_);
    }

    /**
     * Creates a <code>DSwitch</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DSwitch
     */
    public DSwitch createDSwitch(DSwitch source) {
        DSwitch dSwitch_ = createDSwitch();
        dSwitch_.setup(source);
        return (dSwitch_);
    }

    /**
     * Creates a <code>DCase</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DCase
     */
    public DCase createDCase(DCase source) {
        DCase dCase_ = createDCase();
        dCase_.setup(source);
        return (dCase_);
    }

    /**
     * Creates a <code>DJaxmAction</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DJaxmAction
     */
    public DJaxmAction createDJaxmAction(DJaxmAction source) {
        DJaxmAction dJaxmAction_ = createDJaxmAction();
        dJaxmAction_.setup(source);
        return (dJaxmAction_);
    }

    /**
     * Creates a <code>DDialog</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DDialog
     */
    public DDialog createDDialog(Document doc) {
        DDialog dDialog_ = createDDialog();
        dDialog_.setup(doc);
        return (dDialog_);
    }

    /**
     * Creates a <code>DSlot</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DSlot
     */
    public DSlot createDSlot(Document doc) {
        DSlot dSlot_ = createDSlot();
        dSlot_.setup(doc);
        return (dSlot_);
    }

    /**
     * Creates a <code>DRead</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DRead
     */
    public DRead createDRead(Document doc) {
        DRead dRead_ = createDRead();
        dRead_.setup(doc);
        return (dRead_);
    }

    /**
     * Creates a <code>DJdbc</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DJdbc
     */
    public DJdbc createDJdbc(Document doc) {
        DJdbc dJdbc_ = createDJdbc();
        dJdbc_.setup(doc);
        return (dJdbc_);
    }

    /**
     * Creates a <code>DJaxm</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DJaxm
     */
    public DJaxm createDJaxm(Document doc) {
        DJaxm dJaxm_ = createDJaxm();
        dJaxm_.setup(doc);
        return (dJaxm_);
    }

    /**
     * Creates a <code>DBean</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DBean
     */
    public DBean createDBean(Document doc) {
        DBean dBean_ = createDBean();
        dBean_.setup(doc);
        return (dBean_);
    }

    /**
     * Creates a <code>DFile</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DFile
     */
    public DFile createDFile(Document doc) {
        DFile dFile_ = createDFile();
        dFile_.setup(doc);
        return (dFile_);
    }

    /**
     * Creates a <code>DJms</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DJms
     */
    public DJms createDJms(Document doc) {
        DJms dJms_ = createDJms();
        dJms_.setup(doc);
        return (dJms_);
    }

    /**
     * Creates a <code>DWrite</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DWrite
     */
    public DWrite createDWrite(Document doc) {
        DWrite dWrite_ = createDWrite();
        dWrite_.setup(doc);
        return (dWrite_);
    }

    /**
     * Creates a <code>DReadWrite</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DReadWrite
     */
    public DReadWrite createDReadWrite(Document doc) {
        DReadWrite dReadWrite_ = createDReadWrite();
        dReadWrite_.setup(doc);
        return (dReadWrite_);
    }

    /**
     * Creates a <code>DCommand</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DCommand
     */
    public DCommand createDCommand(Document doc) {
        DCommand dCommand_ = createDCommand();
        dCommand_.setup(doc);
        return (dCommand_);
    }

    /**
     * Creates a <code>DEjbAction</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DEjbAction
     */
    public DEjbAction createDEjbAction(Document doc) {
        DEjbAction dEjbAction_ = createDEjbAction();
        dEjbAction_.setup(doc);
        return (dEjbAction_);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DEjbMethod
     */
    public DEjbMethod createDEjbMethod(Document doc) {
        DEjbMethod dEjbMethod_ = createDEjbMethod();
        dEjbMethod_.setup(doc);
        return (dEjbMethod_);
    }

    /**
     * Creates a <code>DEjbParam</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DEjbParam
     */
    public DEjbParam createDEjbParam(Document doc) {
        DEjbParam dEjbParam_ = createDEjbParam();
        dEjbParam_.setup(doc);
        return (dEjbParam_);
    }

    /**
     * Creates a <code>DMethodIn</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DMethodIn
     */
    public DMethodIn createDMethodIn(Document doc) {
        DMethodIn dMethodIn_ = createDMethodIn();
        dMethodIn_.setup(doc);
        return (dMethodIn_);
    }

    /**
     * Creates a <code>DMethodOut</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DMethodOut
     */
    public DMethodOut createDMethodOut(Document doc) {
        DMethodOut dMethodOut_ = createDMethodOut();
        dMethodOut_.setup(doc);
        return (dMethodOut_);
    }

    /**
     * Creates a <code>DBeanAction</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DBeanAction
     */
    public DBeanAction createDBeanAction(Document doc) {
        DBeanAction dBeanAction_ = createDBeanAction();
        dBeanAction_.setup(doc);
        return (dBeanAction_);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DGenericMethod
     */
    public DGenericMethod createDGenericMethod(Document doc) {
        DGenericMethod dGenericMethod_ = createDGenericMethod();
        dGenericMethod_.setup(doc);
        return (dGenericMethod_);
    }

    /**
     * Creates a <code>DGenericParam</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DGenericParam
     */
    public DGenericParam createDGenericParam(Document doc) {
        DGenericParam dGenericParam_ = createDGenericParam();
        dGenericParam_.setup(doc);
        return (dGenericParam_);
    }

    /**
     * Creates a <code>DSwitch</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DSwitch
     */
    public DSwitch createDSwitch(Document doc) {
        DSwitch dSwitch_ = createDSwitch();
        dSwitch_.setup(doc);
        return (dSwitch_);
    }

    /**
     * Creates a <code>DCase</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DCase
     */
    public DCase createDCase(Document doc) {
        DCase dCase_ = createDCase();
        dCase_.setup(doc);
        return (dCase_);
    }

    /**
     * Creates a <code>DJaxmAction</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return DJaxmAction
     */
    public DJaxmAction createDJaxmAction(Document doc) {
        DJaxmAction dJaxmAction_ = createDJaxmAction();
        dJaxmAction_.setup(doc);
        return (dJaxmAction_);
    }

    /**
     * Creates a <code>DDialog</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DDialog
     */
    public DDialog createDDialog(Element element) {
        DDialog dDialog_ = createDDialog();
        dDialog_.setup(element);
        return (dDialog_);
    }

    /**
     * Creates a <code>DSlot</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DSlot
     */
    public DSlot createDSlot(Element element) {
        DSlot dSlot_ = createDSlot();
        dSlot_.setup(element);
        return (dSlot_);
    }

    /**
     * Creates a <code>DRead</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DRead
     */
    public DRead createDRead(Element element) {
        DRead dRead_ = createDRead();
        dRead_.setup(element);
        return (dRead_);
    }

    /**
     * Creates a <code>DJdbc</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DJdbc
     */
    public DJdbc createDJdbc(Element element) {
        DJdbc dJdbc_ = createDJdbc();
        dJdbc_.setup(element);
        return (dJdbc_);
    }

    /**
     * Creates a <code>DJaxm</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DJaxm
     */
    public DJaxm createDJaxm(Element element) {
        DJaxm dJaxm_ = createDJaxm();
        dJaxm_.setup(element);
        return (dJaxm_);
    }

    /**
     * Creates a <code>DBean</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DBean
     */
    public DBean createDBean(Element element) {
        DBean dBean_ = createDBean();
        dBean_.setup(element);
        return (dBean_);
    }

    /**
     * Creates a <code>DFile</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DFile
     */
    public DFile createDFile(Element element) {
        DFile dFile_ = createDFile();
        dFile_.setup(element);
        return (dFile_);
    }

    /**
     * Creates a <code>DJms</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DJms
     */
    public DJms createDJms(Element element) {
        DJms dJms_ = createDJms();
        dJms_.setup(element);
        return (dJms_);
    }

    /**
     * Creates a <code>DWrite</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DWrite
     */
    public DWrite createDWrite(Element element) {
        DWrite dWrite_ = createDWrite();
        dWrite_.setup(element);
        return (dWrite_);
    }

    /**
     * Creates a <code>DReadWrite</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DReadWrite
     */
    public DReadWrite createDReadWrite(Element element) {
        DReadWrite dReadWrite_ = createDReadWrite();
        dReadWrite_.setup(element);
        return (dReadWrite_);
    }

    /**
     * Creates a <code>DCommand</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DCommand
     */
    public DCommand createDCommand(Element element) {
        DCommand dCommand_ = createDCommand();
        dCommand_.setup(element);
        return (dCommand_);
    }

    /**
     * Creates a <code>DEjbAction</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DEjbAction
     */
    public DEjbAction createDEjbAction(Element element) {
        DEjbAction dEjbAction_ = createDEjbAction();
        dEjbAction_.setup(element);
        return (dEjbAction_);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DEjbMethod
     */
    public DEjbMethod createDEjbMethod(Element element) {
        DEjbMethod dEjbMethod_ = createDEjbMethod();
        dEjbMethod_.setup(element);
        return (dEjbMethod_);
    }

    /**
     * Creates a <code>DEjbParam</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DEjbParam
     */
    public DEjbParam createDEjbParam(Element element) {
        DEjbParam dEjbParam_ = createDEjbParam();
        dEjbParam_.setup(element);
        return (dEjbParam_);
    }

    /**
     * Creates a <code>DMethodIn</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DMethodIn
     */
    public DMethodIn createDMethodIn(Element element) {
        DMethodIn dMethodIn_ = createDMethodIn();
        dMethodIn_.setup(element);
        return (dMethodIn_);
    }

    /**
     * Creates a <code>DMethodOut</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DMethodOut
     */
    public DMethodOut createDMethodOut(Element element) {
        DMethodOut dMethodOut_ = createDMethodOut();
        dMethodOut_.setup(element);
        return (dMethodOut_);
    }

    /**
     * Creates a <code>DBeanAction</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DBeanAction
     */
    public DBeanAction createDBeanAction(Element element) {
        DBeanAction dBeanAction_ = createDBeanAction();
        dBeanAction_.setup(element);
        return (dBeanAction_);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DGenericMethod
     */
    public DGenericMethod createDGenericMethod(Element element) {
        DGenericMethod dGenericMethod_ = createDGenericMethod();
        dGenericMethod_.setup(element);
        return (dGenericMethod_);
    }

    /**
     * Creates a <code>DGenericParam</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DGenericParam
     */
    public DGenericParam createDGenericParam(Element element) {
        DGenericParam dGenericParam_ = createDGenericParam();
        dGenericParam_.setup(element);
        return (dGenericParam_);
    }

    /**
     * Creates a <code>DSwitch</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DSwitch
     */
    public DSwitch createDSwitch(Element element) {
        DSwitch dSwitch_ = createDSwitch();
        dSwitch_.setup(element);
        return (dSwitch_);
    }

    /**
     * Creates a <code>DCase</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DCase
     */
    public DCase createDCase(Element element) {
        DCase dCase_ = createDCase();
        dCase_.setup(element);
        return (dCase_);
    }

    /**
     * Creates a <code>DJaxmAction</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return DJaxmAction
     */
    public DJaxmAction createDJaxmAction(Element element) {
        DJaxmAction dJaxmAction_ = createDJaxmAction();
        dJaxmAction_.setup(element);
        return (dJaxmAction_);
    }

    /**
     * Creates a <code>DDialog</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DDialog
     */
    public DDialog createDDialog(RStack stack) {
        DDialog dDialog_ = createDDialog();
        dDialog_.setup(stack);
        return (dDialog_);
    }

    /**
     * Creates a <code>DSlot</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DSlot
     */
    public DSlot createDSlot(RStack stack) {
        DSlot dSlot_ = createDSlot();
        dSlot_.setup(stack);
        return (dSlot_);
    }

    /**
     * Creates a <code>DRead</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DRead
     */
    public DRead createDRead(RStack stack) {
        DRead dRead_ = createDRead();
        dRead_.setup(stack);
        return (dRead_);
    }

    /**
     * Creates a <code>DJdbc</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DJdbc
     */
    public DJdbc createDJdbc(RStack stack) {
        DJdbc dJdbc_ = createDJdbc();
        dJdbc_.setup(stack);
        return (dJdbc_);
    }

    /**
     * Creates a <code>DJaxm</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DJaxm
     */
    public DJaxm createDJaxm(RStack stack) {
        DJaxm dJaxm_ = createDJaxm();
        dJaxm_.setup(stack);
        return (dJaxm_);
    }

    /**
     * Creates a <code>DBean</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DBean
     */
    public DBean createDBean(RStack stack) {
        DBean dBean_ = createDBean();
        dBean_.setup(stack);
        return (dBean_);
    }

    /**
     * Creates a <code>DFile</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DFile
     */
    public DFile createDFile(RStack stack) {
        DFile dFile_ = createDFile();
        dFile_.setup(stack);
        return (dFile_);
    }

    /**
     * Creates a <code>DJms</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DJms
     */
    public DJms createDJms(RStack stack) {
        DJms dJms_ = createDJms();
        dJms_.setup(stack);
        return (dJms_);
    }

    /**
     * Creates a <code>DWrite</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DWrite
     */
    public DWrite createDWrite(RStack stack) {
        DWrite dWrite_ = createDWrite();
        dWrite_.setup(stack);
        return (dWrite_);
    }

    /**
     * Creates a <code>DReadWrite</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DReadWrite
     */
    public DReadWrite createDReadWrite(RStack stack) {
        DReadWrite dReadWrite_ = createDReadWrite();
        dReadWrite_.setup(stack);
        return (dReadWrite_);
    }

    /**
     * Creates a <code>DCommand</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DCommand
     */
    public DCommand createDCommand(RStack stack) {
        DCommand dCommand_ = createDCommand();
        dCommand_.setup(stack);
        return (dCommand_);
    }

    /**
     * Creates a <code>DEjbAction</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DEjbAction
     */
    public DEjbAction createDEjbAction(RStack stack) {
        DEjbAction dEjbAction_ = createDEjbAction();
        dEjbAction_.setup(stack);
        return (dEjbAction_);
    }

    /**
     * Creates a <code>DEjbMethod</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DEjbMethod
     */
    public DEjbMethod createDEjbMethod(RStack stack) {
        DEjbMethod dEjbMethod_ = createDEjbMethod();
        dEjbMethod_.setup(stack);
        return (dEjbMethod_);
    }

    /**
     * Creates a <code>DEjbParam</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DEjbParam
     */
    public DEjbParam createDEjbParam(RStack stack) {
        DEjbParam dEjbParam_ = createDEjbParam();
        dEjbParam_.setup(stack);
        return (dEjbParam_);
    }

    /**
     * Creates a <code>DMethodIn</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DMethodIn
     */
    public DMethodIn createDMethodIn(RStack stack) {
        DMethodIn dMethodIn_ = createDMethodIn();
        dMethodIn_.setup(stack);
        return (dMethodIn_);
    }

    /**
     * Creates a <code>DMethodOut</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DMethodOut
     */
    public DMethodOut createDMethodOut(RStack stack) {
        DMethodOut dMethodOut_ = createDMethodOut();
        dMethodOut_.setup(stack);
        return (dMethodOut_);
    }

    /**
     * Creates a <code>DBeanAction</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DBeanAction
     */
    public DBeanAction createDBeanAction(RStack stack) {
        DBeanAction dBeanAction_ = createDBeanAction();
        dBeanAction_.setup(stack);
        return (dBeanAction_);
    }

    /**
     * Creates a <code>DGenericMethod</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DGenericMethod
     */
    public DGenericMethod createDGenericMethod(RStack stack) {
        DGenericMethod dGenericMethod_ = createDGenericMethod();
        dGenericMethod_.setup(stack);
        return (dGenericMethod_);
    }

    /**
     * Creates a <code>DGenericParam</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DGenericParam
     */
    public DGenericParam createDGenericParam(RStack stack) {
        DGenericParam dGenericParam_ = createDGenericParam();
        dGenericParam_.setup(stack);
        return (dGenericParam_);
    }

    /**
     * Creates a <code>DSwitch</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DSwitch
     */
    public DSwitch createDSwitch(RStack stack) {
        DSwitch dSwitch_ = createDSwitch();
        dSwitch_.setup(stack);
        return (dSwitch_);
    }

    /**
     * Creates a <code>DCase</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DCase
     */
    public DCase createDCase(RStack stack) {
        DCase dCase_ = createDCase();
        dCase_.setup(stack);
        return (dCase_);
    }

    /**
     * Creates a <code>DJaxmAction</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DJaxmAction
     */
    public DJaxmAction createDJaxmAction(RStack stack) {
        DJaxmAction dJaxmAction_ = createDJaxmAction();
        dJaxmAction_.setup(stack);
        return (dJaxmAction_);
    }

    /**
     * Creates a <code>DReadAndWrite</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return DReadAndWrite
     */
    public DReadAndWrite createDReadAndWrite(RStack stack) {
        DReadAndWrite dReadAndWrite_ = createDReadAndWrite();
        dReadAndWrite_.setup(stack);
        return (dReadAndWrite_);
    }

    /**
     * Creates a <code>DReadAndWrite</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return DReadAndWrite
     */
    public DReadAndWrite createDReadAndWrite(DReadAndWrite source) {
        DReadAndWrite dReadAndWrite_ = createDReadAndWrite();
        dReadAndWrite_.setup(source);
        return (dReadAndWrite_);
    }
}
