/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.dialog;

import org.w3c.dom.Document;
import org.relaxer.dialog.rDialog.*;
import org.relaxer.dialog.eDialog.EvalContext;

/**
 * AbstractDialogCommand
 *
 * @since   Feb. 26, 2002
 * @version Feb. 27, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class SimpleDialogCommand extends AbstractDialogCommand {
    private DCommand command_;
    private IDialogSpace space_;

    protected SimpleDialogCommand(DCommand command, IDialogSpace space) {
	super(command.getName());
	command_ = command;
	space_ = space;
    }

    public Object execute() {
	try {
	    EvalContext context = new EvalContext();
	    context.space = space_;
	    return (command_.eval(context));
	} catch (Exception e) {
	    return (e);
	}
    }
}
