/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.dialog;

import java.io.IOException;
import javax.jms.*;
import javax.naming.*;
import javax.xml.parsers.*;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.relaxer.xml.UDOM;
import org.relaxer.mom.IMOMFacade;
import org.relaxer.mom.MOMFacadeFactory;
import org.relaxer.monitor.ULog;
import org.relaxer.dialog.rDialog.DJms;

/**
 * JmsEntity
 *
 * @since   Jul. 14, 2001
 * @version Jul. 17, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class JmsEntityAdapter extends AbstractEntityAdapter {
    private String factoryUri_;
    private String destinationUri_;
    private IMOMFacade handler_;

    public JmsEntityAdapter(String factoryUri, String destinationUri) {
	factoryUri_ = factoryUri;
	destinationUri_ = destinationUri;
    }

    public JmsEntityAdapter(DJms method) {
    }

    public void open() throws IOException {
	try {
	    MOMFacadeFactory factory = MOMFacadeFactory.newInstance();
	    handler_ = factory.getMOMFacade(factoryUri_, destinationUri_);
	} catch (NamingException e) {
	    throw (_makeIOException(e));
	} catch (JMSException e) {
	    throw (_makeIOException(e));
	}
    }

    public void close() throws IOException {
    }

    public Document load() throws IOException {
	try {
	    return (handler_.readDocument());
	} catch (JMSException e) {
	    throw (_makeIOException(e));
	}
    }

    public void save(Document doc) throws IOException {
	try {
	    handler_.write(_makeTextMessage(doc));
	} catch (JMSException e) {
	    throw (_makeIOException(e));
	}
    }

    private TextMessage _makeTextMessage(Document doc) throws JMSException {
	TextMessage message = handler_.createTextMessage();
	message.setText(UDOM.makeTextDocument(doc));
	return (message);
    }

    private IOException _makeIOException(String message) {
	return (ULog.makeIOException(message));
    }

    private IOException _makeIOException(Throwable e) {
	return (ULog.makeIOException(e));
    }
}
