package org.relaxer.bus.rConfig;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>CHelp</b> is generated by Relaxer based on application.rxm.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="help">
 *   <tag/>
 *   <mixed>
 *     <hedgeRef label="particle" occurs="*"/>
 *   </mixed>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="help"&gt;
 *   &lt;tag/&gt;
 *   &lt;mixed&gt;
 *     &lt;hedgeRef label="particle" occurs="*"/&gt;
 *   &lt;/mixed&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version application.rxm (Wed Jan 02 23:42:46 JST 2002)
 * @author  Relaxer 0.15.1b (http://www.relaxer.org)
 */
public class CHelp implements java.io.Serializable, IRVisitable, IRNode {
    // List<ICHelpMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>CHelp</code>.
     *
     */
    public CHelp() {
    }

    /**
     * Creates a <code>CHelp</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CHelp(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CHelp</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CHelp(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CHelp</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CHelp(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>CHelp</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CHelp(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>CHelp</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CHelp(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>CHelp</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CHelp(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>CHelp</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CHelp(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>CHelp</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CHelp(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>CHelp</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CHelp(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContent(String text) {
        setContent(new RString(text));
    }

    /**
     * Gets a mixed content as <code>String</code>.
     *
     * @return String
     */
    public String getContentAsString() {
        return (URelaxer.getStringByMixedList(content_));
    }

    /**
     * Initializes the <code>CHelp</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CHelp</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CHelp</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        this.content_.clear();
        while (!stack.isEmpty()) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (CParticle.isMatch(stack)) {
                addContent(new CParticle(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("help");
        int size;
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            ICHelpMixed value = (ICHelpMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>CHelp</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>CHelp</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CHelp</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CHelp</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CHelp</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CHelp</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the ICHelpMixed property <b>content</b>.
     *
     * @return ICHelpMixed[]
     */
    public final ICHelpMixed[] getContent() {
        ICHelpMixed[] array = new ICHelpMixed[content_.size()];
        return ((ICHelpMixed[])content_.toArray(array));
    }

    /**
     * Sets the ICHelpMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(ICHelpMixed[] content) {
        this.content_.clear();
        this.content_.addAll(java.util.Arrays.asList(content));
        for (int i = 0;i < content.length;i++) {
            content[i].setParentRNode(this);
        }
    }

    /**
     * Sets the ICHelpMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(ICHelpMixed content) {
        this.content_.clear();
        this.content_.add(content);
        if (content != null) {
            content.setParentRNode(this);
        }
    }

    /**
     * Adds the ICHelpMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(ICHelpMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.setParentRNode(this);
        }
    }

    /**
     * Gets number of the ICHelpMixed property <b>content</b>.
     *
     * @return int
     */
    public final int getContentCount() {
        return (content_.size());
    }

    /**
     * Gets the ICHelpMixed property <b>content</b> by index.
     *
     * @param index
     * @return ICHelpMixed
     */
    public final ICHelpMixed getContent(int index) {
        return ((ICHelpMixed)content_.get(index));
    }

    /**
     * Sets the ICHelpMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, ICHelpMixed content) {
        this.content_.set(index, content);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<help");
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            ICHelpMixed value = (ICHelpMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</help>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<help");
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            ICHelpMixed value = (ICHelpMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</help>");
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CHelp</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "help")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (CParticle.isMatchHungry(target)) {
                while (CParticle.isMatchHungry(target)) {
                }
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CHelp</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CHelp</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
