package org.relaxer.bus.rConfig;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>CApplication</b> is generated by Relaxer based on application.rxm.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="application">
 *   <tag>
 *     <attribute name="name" required="true" type="normalizedString"/>
 *     <attribute name="version" type="token"/>
 *     <attribute name="build" type="token"/>
 *   </tag>
 *   <sequence>
 *     <element name="author" type="normalizedString"/>
 *     <element name="provider" type="normalizedString"/>
 *     <element name="year" type="string"/>
 *     <ref label="usage" occurs="?"/>
 *     <ref label="help" occurs="?"/>
 *     <hedgeRef label="executable"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="application"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="name" required="true" type="normalizedString"/&gt;
 *     &lt;attribute name="version" type="token"/&gt;
 *     &lt;attribute name="build" type="token"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;element name="author" type="normalizedString"/&gt;
 *     &lt;element name="provider" type="normalizedString"/&gt;
 *     &lt;element name="year" type="string"/&gt;
 *     &lt;ref label="usage" occurs="?"/&gt;
 *     &lt;ref label="help" occurs="?"/&gt;
 *     &lt;hedgeRef label="executable"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version application.rxm (Wed Jan 02 23:42:46 JST 2002)
 * @author  Relaxer 0.15.1b (http://www.relaxer.org)
 */
public class CApplication implements java.io.Serializable, IRVisitable, IRNode {
    private String name_;
    private String version_;
    private String build_;
    private String author_;
    private String provider_;
    private String year_;
    private CUsage usage_;
    private CHelp help_;
    private ICExecutableChoice executable_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>CApplication</code>.
     *
     */
    public CApplication() {
    }

    /**
     * Creates a <code>CApplication</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CApplication(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CApplication</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CApplication(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CApplication</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CApplication(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>CApplication</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CApplication(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>CApplication</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CApplication(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>CApplication</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CApplication(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>CApplication</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CApplication(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>CApplication</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CApplication(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>CApplication</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CApplication(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>CApplication</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CApplication</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CApplication</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        version_ = URelaxer.getAttributePropertyAsString(element, "version");
        build_ = URelaxer.getAttributePropertyAsString(element, "build");
        author_ = URelaxer.getElementPropertyAsString(stack.popElement());
        provider_ = URelaxer.getElementPropertyAsString(stack.popElement());
        year_ = URelaxer.getElementPropertyAsString(stack.popElement());
        if (CUsage.isMatch(stack)) {
            setUsage(new CUsage(stack));
        }
        if (CHelp.isMatch(stack)) {
            setHelp(new CHelp(stack));
        }
        if (CComponent.isMatch(stack)) {
            setExecutable(new CComponent(stack));
        } else if (CPipe.isMatch(stack)) {
            setExecutable(new CPipe(stack));
        } else if (CBus.isMatch(stack)) {
            setExecutable(new CBus(stack));
        } else {
            throw (new IllegalArgumentException());
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("application");
        int size;
        URelaxer.setAttributePropertyByString(element, "name", this.name_);
        if (this.version_ != null) {
            URelaxer.setAttributePropertyByString(element, "version", this.version_);
        }
        if (this.build_ != null) {
            URelaxer.setAttributePropertyByString(element, "build", this.build_);
        }
        URelaxer.setElementPropertyByString(element, "author", this.author_);
        URelaxer.setElementPropertyByString(element, "provider", this.provider_);
        URelaxer.setElementPropertyByString(element, "year", this.year_);
        if (this.usage_ != null) {
            this.usage_.makeElement(element);
        }
        if (this.help_ != null) {
            this.help_.makeElement(element);
        }
        this.executable_.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>CApplication</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>CApplication</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CApplication</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CApplication</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CApplication</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CApplication</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>version</b>.
     *
     * @return String
     */
    public final String getVersion() {
        return (version_);
    }

    /**
     * Sets the String property <b>version</b>.
     *
     * @param version
     */
    public final void setVersion(String version) {
        this.version_ = version;
    }

    /**
     * Gets the String property <b>build</b>.
     *
     * @return String
     */
    public final String getBuild() {
        return (build_);
    }

    /**
     * Sets the String property <b>build</b>.
     *
     * @param build
     */
    public final void setBuild(String build) {
        this.build_ = build;
    }

    /**
     * Gets the String property <b>author</b>.
     *
     * @return String
     */
    public final String getAuthor() {
        return (author_);
    }

    /**
     * Sets the String property <b>author</b>.
     *
     * @param author
     */
    public final void setAuthor(String author) {
        this.author_ = author;
    }

    /**
     * Gets the String property <b>provider</b>.
     *
     * @return String
     */
    public final String getProvider() {
        return (provider_);
    }

    /**
     * Sets the String property <b>provider</b>.
     *
     * @param provider
     */
    public final void setProvider(String provider) {
        this.provider_ = provider;
    }

    /**
     * Gets the String property <b>year</b>.
     *
     * @return String
     */
    public final String getYear() {
        return (year_);
    }

    /**
     * Sets the String property <b>year</b>.
     *
     * @param year
     */
    public final void setYear(String year) {
        this.year_ = year;
    }

    /**
     * Gets the CUsage property <b>usage</b>.
     *
     * @return CUsage
     */
    public final CUsage getUsage() {
        return (usage_);
    }

    /**
     * Sets the CUsage property <b>usage</b>.
     *
     * @param usage
     */
    public final void setUsage(CUsage usage) {
        this.usage_ = usage;
        if (usage != null) {
            usage.setParentRNode(this);
        }
    }

    /**
     * Gets the CHelp property <b>help</b>.
     *
     * @return CHelp
     */
    public final CHelp getHelp() {
        return (help_);
    }

    /**
     * Sets the CHelp property <b>help</b>.
     *
     * @param help
     */
    public final void setHelp(CHelp help) {
        this.help_ = help;
        if (help != null) {
            help.setParentRNode(this);
        }
    }

    /**
     * Gets the ICExecutableChoice property <b>executable</b>.
     *
     * @return ICExecutableChoice
     */
    public final ICExecutableChoice getExecutable() {
        return (executable_);
    }

    /**
     * Sets the ICExecutableChoice property <b>executable</b>.
     *
     * @param executable
     */
    public final void setExecutable(ICExecutableChoice executable) {
        this.executable_ = executable;
        if (executable != null) {
            executable.setParentRNode(this);
        }
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<application");
        buffer.append(" name=\"");
        buffer.append(URelaxer.escapeAttrQuot(getName()));
        buffer.append("\"");
        if (version_ != null) {
            buffer.append(" version=\"");
            buffer.append(URelaxer.escapeAttrQuot(getVersion()));
            buffer.append("\"");
        }
        if (build_ != null) {
            buffer.append(" build=\"");
            buffer.append(URelaxer.escapeAttrQuot(getBuild()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("<author>");
        buffer.append(URelaxer.escapeCharData(getAuthor()));
        buffer.append("</author>");
        buffer.append("<provider>");
        buffer.append(URelaxer.escapeCharData(getProvider()));
        buffer.append("</provider>");
        buffer.append("<year>");
        buffer.append(URelaxer.escapeCharData(getYear()));
        buffer.append("</year>");
        if (usage_ != null) {
            usage_.makeTextElement(buffer);
        }
        if (help_ != null) {
            help_.makeTextElement(buffer);
        }
        executable_.makeTextElement(buffer);
        buffer.append("</application>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<application");
        buffer.print(" name=\"");
        buffer.print(URelaxer.escapeAttrQuot(getName()));
        buffer.print("\"");
        if (version_ != null) {
            buffer.print(" version=\"");
            buffer.print(URelaxer.escapeAttrQuot(getVersion()));
            buffer.print("\"");
        }
        if (build_ != null) {
            buffer.print(" build=\"");
            buffer.print(URelaxer.escapeAttrQuot(getBuild()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("<author>");
        buffer.print(URelaxer.escapeCharData(getAuthor()));
        buffer.print("</author>");
        buffer.print("<provider>");
        buffer.print(URelaxer.escapeCharData(getProvider()));
        buffer.print("</provider>");
        buffer.print("<year>");
        buffer.print(URelaxer.escapeCharData(getYear()));
        buffer.print("</year>");
        if (usage_ != null) {
            usage_.makeTextElement(buffer);
        }
        if (help_ != null) {
            help_.makeTextElement(buffer);
        }
        executable_.makeTextElement(buffer);
        buffer.print("</application>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getVersionAsString() {
        return (URelaxer.getString(getVersion()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getBuildAsString() {
        return (URelaxer.getString(getBuild()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getAuthorAsString() {
        return (URelaxer.getString(getAuthor()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getProviderAsString() {
        return (URelaxer.getString(getProvider()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getYearAsString() {
        return (URelaxer.getString(getYear()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setVersionByString(String string) {
        setVersion(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setBuildByString(String string) {
        setBuild(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setAuthorByString(String string) {
        setAuthor(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setProviderByString(String string) {
        setProvider(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setYearByString(String string) {
        setYear(string);
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        if (usage_ != null) {
            classNodes.add(usage_);
        }
        if (help_ != null) {
            classNodes.add(help_);
        }
        classNodes.add(executable_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CApplication</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "application")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "author")) {
            return (false);
        }
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "provider")) {
            return (false);
        }
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "year")) {
            return (false);
        }
        if (CUsage.isMatchHungry(target)) {
        }
        if (CHelp.isMatchHungry(target)) {
        }
        if (CComponent.isMatchHungry(target)) {
        } else if (CPipe.isMatchHungry(target)) {
        } else if (CBus.isMatchHungry(target)) {
        } else {
            return (false);
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CApplication</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CApplication</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
