/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus.model;

import java.io.*;
import java.net.URL;

/**
 * UIO
 *
 * @since   Jan.  1, 2002
 * @version Jan.  2, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public final class UIO {
    public static byte[] makeBinary(InputStream in) throws IOException {
	ByteArrayOutputStream out = new ByteArrayOutputStream();
	byte[] buffer = new byte[8192];
	int size;
	while ((size = in.read(buffer)) != -1) {
	    out.write(buffer, 0, size);
	}
	return (out.toByteArray());
    }

    public static byte[] makeBinary(File file) throws IOException {
	return (makeBinary(new FileInputStream(file)));
    }

    public static byte[] makeBinary(URL url) throws IOException {
	return (makeBinary(url.openStream()));
    }

    public static String makeText(InputStream in) throws IOException {
	return (makeText(new InputStreamReader(in)));
    }

    public static String makeText(Reader reader) throws IOException {
	CharArrayWriter writer = new CharArrayWriter();
	char[] buffer = new char[4096];
	int size;
	while ((size = reader.read(buffer)) != -1) {
	    writer.write(buffer, 0, size);
	}
	return (writer.toString());
    }

    public static String makeText(File file) throws IOException {
	return (makeText(new FileReader(file)));
    }

    public static String makeText(URL url) throws IOException {
	return (makeText(url.openStream()));
    }
}
