/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus.model;

import java.io.*;
import org.w3c.dom.Document;
import org.relaxer.bus.*;

/**
 * RBusFileValue
 *
 * @since   Jan.  1, 2002
 * @version Jan.  2, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class FileValue implements IRBusValue {
    private String uri_;
    private File file_;

    public FileValue(String uri) {
	uri_ = uri;
	file_ = new File(uri);
    }

    public FileValue(String uri, File file) {
	uri_ = uri;
	file_ = file;
    }

    public String getUri() {
	return (uri_);
    }

    public void setUri(String uri) {
	uri_ = uri;
    }

    // binary
    public byte[] getBinary() throws IOException {
	return (UIO.makeBinary(file_));
    }

    public InputStream getInputStream() throws IOException {
	return (new FileInputStream(file_));
    }

    // string
    public String getText() throws IOException {
	return (UIO.makeText(file_));
    }

    public Reader getReader() throws IOException {
	return (new FileReader(file_));
    }

    // XML
    public Document getDocument() {
	throw (new UnsupportedOperationException());
    }

    // Object
    public Object getObject() {
	throw (new UnsupportedOperationException());
    }
}
