/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus.model;

import java.util.Stack;
import java.beans.Beans;
import java.io.IOException;
import java.lang.reflect.*;
import org.relaxer.bus.*;
import org.relaxer.bus.rConfig.*;
import org.relaxer.bus.framework.*;
import org.relaxer.bus.component.*;

/**
 * ConfigVisitor
 *
 * @since   Dec. 31, 2001
 * @version Jan.  3, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class ConfigVisitor extends RVisitorBase {
    private Application app_;
    private IRBusPart root_;
    private IRBusFramework framework_; // XXX : root?
    private Stack stack_ = new Stack();

    public Application getApplication() {
	return (app_);
    }

    private void _pushFramework(IRBusFramework framework) {
	if (framework_ != null) {
	    framework_.addPart(framework);
	}
	stack_.push(framework_);
	framework_ = framework;
    }

    private IRBusFramework _popFramework() {
	framework_ = (IRBusFramework)stack_.pop();
	return (framework_);
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(CApplication visitable) {
	app_ = new Application();
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(CApplication visitable) {
	app_.setRootPart(root_);
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(CUsage visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(CUsage visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(CHelp visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(CHelp visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(CComponent visitable) {
	try {
	    Object bean = Beans.instantiate(null, visitable.getClassValue());
	    IRBusComponent comp = (IRBusComponent)bean;
	    _setProperties(comp, visitable);
	    if (framework_ != null) {
		framework_.addPart(comp);
	    }
	    if (root_ == null) {
		root_ = comp;
	    }
	    return (false);
	} catch (IOException e) {
	    throw (new InternalError());
	} catch (ClassNotFoundException e) {
	    throw (new InternalError());
	} catch (IllegalAccessException e) {
	    throw (new InternalError());
	} catch (InvocationTargetException e) {
	    throw (new InternalError());
	} catch (NoSuchMethodException e) {
	    throw (new InternalError());
	} catch (InstantiationException e) {
	    throw (new InternalError());
	}
    }

    private void _setProperties(
	IRBusComponent comp,
	CComponent source
    ) throws IllegalAccessException,
	     InvocationTargetException,
	     NoSuchMethodException,
	     InstantiationException {

	int size = source.getPropertyCount();
	for (int i = 0;i < size;i++) {
	    CProperty property = source.getProperty(i);
	    String name = property.getName();
	    String value = property.getContentAsString();
	    _setProperty(comp, name, value);
	}
    }

    private void _setProperty(
	Object object,
	String name,
	String value
    ) throws IllegalAccessException,
	     NoSuchMethodException,
	     InstantiationException,
	     InvocationTargetException {

	Method method = _getMethod(object, name);
	if (method == null) {
	    return;		// XXX
	}
	Class type = method.getParameterTypes()[0];
	Object param = _getParam(type, value);
	method.invoke(object, new Object[] { param });
    }

    private Object _getParam(Class type, String value)
	throws NoSuchMethodException,
	       InstantiationException,
	       IllegalAccessException,
	       InvocationTargetException {

	if (type.equals(String.class)) {
	    return (value);
	} else if (type.equals(Boolean.TYPE) ||
		   type.equals(Boolean.class)) {

	    return (new Boolean(value));
	} else if (type.equals(Byte.TYPE) ||
		   type.equals(Byte.class)) {

	    return (new Byte(value));
	} else if (type.equals(Short.TYPE) ||
		   type.equals(Short.class)) {

	    return (new Short(value));
	} else if (type.equals(Integer.TYPE) ||
		   type.equals(Integer.class)) {

	    return (new Integer(value));
	} else if (type.equals(Long.TYPE) ||
		   type.equals(Long.class)) {

	    return (new Long(value));
	} else if (type.equals(Float.TYPE) ||
		   type.equals(Float.class)) {

	    return (new Float(value));
	} else if (type.equals(Double.TYPE) ||
		   type.equals(Double.class)) {

	    return (new Double(value));
	} else {
	    Constructor constructor
		= type.getConstructor(new Class[] { String.class });
	    return (constructor.newInstance(new Object[] { value }));
	}
    }

    private Method _getMethod(Object object, String name) {
	String methodName =
	    "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
	Method[] methods = object.getClass().getMethods();
	for (int i = 0;i < methods.length;i++) {
	    Method method = methods[i];
	    if (methodName.equals(method.getName()) &&
		method.getParameterTypes().length == 1) {

		return (method);
	    }
	}
	return (null);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(CComponent visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(CPipe visitable) {
	RBusPipe pipe = new RBusPipe();
	_pushFramework(pipe);
	if (root_ == null) {
	    root_ = pipe;
	}
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(CPipe visitable) {
	_popFramework();
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(CBus visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(CBus visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(CSlot visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(CSlot visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(CParticle visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(CParticle visitable) {
    }

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    public boolean enter(RString visitable) {
        return (true);
    }

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    public void leave(RString visitable) {
    }
}
