/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus.component;

import java.io.*;
import org.relaxer.bus.*;
import org.relaxer.bus.model.*;

/**
 * RBusPackager
 *
 * @since   Jan.  2, 2002
 * @version Jan.  3, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RBusPackager extends AbstractRBusComponent {
    private String[] args_;
    private String method_ = "file";

    public void setup(IRBusProperties properties) {
	args_ = properties.getArgs();
    }

    public void setMethod(String method) {
	method_ = method;
    }

    public IRBusSignal stimulas(IRBusSignal signal) {
	try {
	    IRBusValue[] values = signal.getValues();
	    for (int i = 0;i < values.length;i++) {
		IRBusValue value = values[i];
		_package(value);
	    }
	    return (null);
	} catch (IOException e) {
	    throw (new RBusException(e));
	}
    }

    private void _package(IRBusValue value) throws IOException {
	if ("file".equals(method_)) {
	    _packageFile(value);
	} else {
	    throw (new InternalError());
	}
    }

    private void _packageFile(IRBusValue value) throws IOException {
	String uri = value.getUri();
	File file = new File(uri);
	InputStream in = value.getInputStream();
	OutputStream out = new FileOutputStream(file);
	byte[] buffer = new byte[8192];
	int size;
	while ((size = in.read(buffer)) != -1) {
	    out.write(buffer, 0, size);
	}
	out.close();
	in.close();
    }
}
