/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus;

import java.util.*;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import com.AsamiOffice.text.UString;
import com.AsamiOffice.io.UURL;
import org.relaxer.bus.rConfig.*;
import org.relaxer.bus.model.*;

/**
 * RBus
 *
 * @since   Mar. 27, 2000
 * @version Feb. 25, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RBus implements IRBusConstants {
    private RBusMonitor monitor_;
    private String[] args_;
    private CApplication config_;
    private Application app_;

    public RBus() {
    }

    public void setup(URL url)
	throws IOException, SAXException, ParserConfigurationException {

	config_ = new CApplication(url);
	ConfigVisitor visitor = new ConfigVisitor();
	URVisitor.traverse(config_, visitor);
	app_ = visitor.getApplication();
    }

    public void setup(String[] args) {
	args_ = args;
	monitor_ = new RBusMonitor();
	monitor_.setup(args);
	app_.setup(args);
    }

    public void run() {
	_init();
	_startup();
	app_.run();
    }

    private void _init() throws RBusException {
	if (!app_.init()) {
	    monitor_.println(_getCopyright());
	    monitor_.println(_getVersion());
	    monitor_.println();
	    monitor_.println(_getUsage());
	    monitor_.println("  for more information, use -help option");
	    System.exit(1);
	}
    }

    private void _startup() {
	if (_isHelp()) {
	    monitor_.println(_getCopyright());
	    monitor_.println(_getVersion());
	    String[] lines = _getHelpLines();
	    for (int i = 0;i < lines.length;i++) {
		monitor_.println(lines[i]);
	    }
	    System.exit(0);
	} else {
	    monitor_.info(_getCopyright());
	    monitor_.info(_getVersion());
	}
    }

    private String[] _getHelpLines() {
	CHelp help = config_.getHelp();
	if (help != null) {
	    return (new String[0]);
	} else {
	    return (UString.makeStringList(help.getContentAsString()));
	}
    }	    

    private boolean _isHelp() {
	for (int i = 0;i < args_.length;i++) {
	    String arg = args_[i];
	    if ("-help".equals(arg)) {
		return (true);
	    }
	}
	return (false);
    }

    private String _getCopyright() {
	String author = config_.getAuthor();
	String year = config_.getYear();
	StringBuffer copyrightBuffer = new StringBuffer();
	copyrightBuffer.append("Copyright(c) ");
	copyrightBuffer.append(year);
	copyrightBuffer.append(" ");
	copyrightBuffer.append(author);
	copyrightBuffer.append(". All rights reserved.");
	return (new String(copyrightBuffer));
    }

    private String _getVersion() {
	String name = config_.getName();
	String version = config_.getVersion();
	String build = config_.getBuild();
	String provider = config_.getProvider();
	StringBuffer versionBuffer = new StringBuffer();
	versionBuffer.append(name);
	versionBuffer.append(" Version ");
	versionBuffer.append(version);
	if (build != null) {
	    versionBuffer.append(" (");
	    versionBuffer.append(build);
	    versionBuffer.append(")");
	}
	versionBuffer.append(" by ");
	versionBuffer.append(provider);
	return (new String(versionBuffer));
    }

    private String _getUsage() {
	StringBuffer buffer = new StringBuffer();
	buffer.append("Usage: ");
	buffer.append(config_.getUsage());
	return (new String(buffer));
    }

    public void info(String message) {
	monitor_.info(message);
    }

    public void verbose(String message) {
	monitor_.verbose(message);
    }

    public void warning(String message) {
	monitor_.warning(message);
    }

    public void error(String message) {
	monitor_.error(message);
    }

    public void debug(String message) {
	monitor_.debug(message);
    }

    public static void main(String uri, String[] args)
	throws IOException, SAXException, ParserConfigurationException {
	    URL url = _getURL(uri);
	    RBus bus = new RBus();
	    bus.setup(url);
	    bus.setup(args);
	    __setRBus(bus);
	    bus.run();
    }

    public static void main(String[] args)
	throws IOException, SAXException, ParserConfigurationException {

	String uri = args[0];
	String[] appArgs = _makeAppArgs(args);
	main(uri, appArgs);
    }

    private static URL _getURL(String name) {
	try {
	    URL url = new URL(name);
	    return (url);
	} catch (MalformedURLException e) {
	}
	return (RBus.class.getResource(name));
    }

    private static String[] _makeAppArgs(String[] args) {
	String[] appArgs = new String[args.length - 1];
	for (int i = 1;i < args.length;i++) {
	    appArgs[i - 1] = args[i];
	}
	return (appArgs);
    }

    private static void __setRBus(RBus bus) {
	if (bus__ != null) {
	    throw (new InternalError());
	}
	bus__ = bus;
    }

    public static RBus getRBus() {
	return (bus__);
    }

    private static RBus bus__;
}
