/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus;

import java.io.InputStream;
import java.io.Reader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;

/**
 * IRBusValue
 *
 * @since   Dec. 31, 2001
 * @version Jan.  1, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public interface IRBusValue {
    String getUri();
    // binary
    byte[] getBinary() throws IOException;
    InputStream getInputStream() throws IOException;
    // string
    String getText() throws IOException;
    Reader getReader() throws IOException;
    // xml
    Document getDocument()
	throws IOException, SAXException, ParserConfigurationException;
}
