/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus;

/**
 * IRBusPart
 *
 * @since   Dec. 31, 2001
 * @version Jan.  2, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public interface IRBusPart extends IRBusConstants {
    void setup(RBus bus);
    void setup(IRBusFramework framework);
    void setup(IRBusProperties properties);
    boolean init();
    void destroy();
    void start();
    void stop();
    IRBusSignal stimulas(IRBusSignal signal);
}
