/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.util.*;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.*;
import javax.servlet.ServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.relaxer.xml.XMLObject;
import com.AsamiOffice.util.ArrayMap;

/**
 * ServletRequestBean
 *
 * @since   Feb.  1, 2001
 * @version May. 22, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class ServletRequestBean implements Serializable {
    private String className_;
    private String encoding_;
    transient private Map map_;

    public void setClassName(String className) {
	className_ = className;
    }

    public void setEncoding(String encoding) {
	encoding_ = encoding;
    }

    public String getEncoding() {
	return (encoding_);
    }

    public String getClassName() {
	return (className_);
    }

    public void setServletRequest(ServletRequest req)
	throws UnsupportedEncodingException {

	if (encoding_ != null) {
	    req.setCharacterEncoding(encoding_);
	}
	map_ = _makeMap(req);
    }

    public void setMap(Map map) {
	map_ = map;
    }

    public Object getRObject() {
	try {
	    return (_makeRObject(map_));
	} catch (ClassNotFoundException e) {
	    return (null);
	} catch (InstantiationException e) {
	    return (null);
	} catch (IllegalAccessException e) {
	    return (null);
	} catch (NoSuchMethodException e) {
	    return (null);
	} catch (InvocationTargetException e) {
	    return (null);
	} catch (ParserConfigurationException e) {
	    return (null);
	}
    }

    public Object makeRObject() throws 
	ClassNotFoundException,
	InstantiationException,
	IllegalAccessException,
	NoSuchMethodException,
	InvocationTargetException,
	ParserConfigurationException {

	return (_makeRObject(map_));
    }

    // J2EE 1.3 has ServletRequest.getParameterMap
    private Map _makeMap(ServletRequest req) {
//ULog.log("makeMap");
	Map map = new ArrayMap();
	Enumeration enum = req.getParameterNames();
	while (enum.hasMoreElements()) {
	    String key = (String)enum.nextElement();
	    String value = req.getParameter(key).toString();
	    map.put(key, value);
//ULog.log("key = " + key + ", value = " + value);
	}
	return (map);
    }

    private Object _makeRObject(Map map) throws 
	ClassNotFoundException,
	InstantiationException,
	IllegalAccessException,
	NoSuchMethodException,
	InvocationTargetException,
	ParserConfigurationException {

	if (className_ != null) {
	    return (_makeRObjectAsObject(map));
	} else {
	    return (_makeRObjectAsDocument(map));
	}
    }

    private Object _makeRObjectAsObject(Map map) throws 
	ClassNotFoundException,
	InstantiationException,
	IllegalAccessException,
	NoSuchMethodException,
	InvocationTargetException {

	Class rClass = Class.forName(className_);
	Object rObject = rClass.newInstance();
	Class[] types = { Map.class };
	Method setup = rClass.getMethod("setup", types);
	Object[] params = { map };
	setup.invoke(rObject, params);
	return (rObject);
    }

    private Object _makeRObjectAsDocument(Map map)
	throws ParserConfigurationException {

	XMLObject object = new XMLObject();
	object.set(map);
	return (object.getDocument());
    }
}
