/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.relaxer.xml.UDOM;
import org.relaxer.tabular.*;

/**
 * HTMLTableBean
 *
 * @since   Jul. 11, 2001
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class HTMLTableBean implements Serializable {
    private ITabular table_;

    public HTMLTableBean() {
    }

    public void setTabular(ITabular table) {
	table_ = table;
    }

    public ITabular getTabular() {
	return (table_);
    }

    public String makeHTMLTable() {
	if (table_ == null) {
	    return ("no table");
	}
	try {
	    Document doc = makeHTMLTableDocument();
	    Element table = doc.getDocumentElement();
	    return (UDOM.makeTextDocumentVisual(table));
	} catch (ParserConfigurationException e) {
	    return ("no parser");
	}
    }

    public Document makeHTMLTableDocument()
	throws ParserConfigurationException {

	if (table_ == null) {
	    return (null);
	}
	Document html = _createHTMLDocument();
	Element table = html.createElement("TABLE");
	table.setAttribute("FRAME", "BOX");
	Element thead = html.createElement("THEAD");
	Element tbody = html.createElement("TBODY");
	_buildTHead(thead);
	_buildTBody(tbody);
	table.appendChild(thead);
	table.appendChild(tbody);
	html.appendChild(table);
	return (html);
    }

    private Document _createHTMLDocument()
	throws ParserConfigurationException {

	DocumentBuilderFactory factory
	    = DocumentBuilderFactory.newInstance();
	DocumentBuilder builder = factory.newDocumentBuilder();
	return (builder.newDocument());
    }

    private void _buildTHead(Element thead) {
	Document doc = thead.getOwnerDocument();
	int width = table_.getWidth();
	Element tr = doc.createElement("TR");
	for (int x = 0;x < width;x++) {
	    Element th = doc.createElement("TH");
	    th.appendChild(doc.createTextNode(table_.getLabel(x)));
	    tr.appendChild(th);
	}
	thead.appendChild(tr);
    }

    private void _buildTBody(Element tbody) {
	Document doc = tbody.getOwnerDocument();
	int width = table_.getWidth();
	int height = table_.getHeight();
	for (int y = 0;y < height;y++) {
	    Element tr = doc.createElement("TR");
	    for (int x = 0;x < width;x++) {
		Element th = doc.createElement("TD");
		th.appendChild(
		    doc.createTextNode(table_.get(x, y).toString())
		);
		tr.appendChild(th);
	    }
	    tbody.appendChild(tr);
	}
    }
}
