/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import java.rmi.RemoteException;
import javax.rmi.*;
import javax.ejb.*;
import javax.naming.*;

/**
 * EJBSessionBean
 *
 * @since   Sep. 16, 2001
 * @version Sep. 17, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class EJBSessionBean implements Serializable {
    private String uri_;
    private String proxyName_;
    private Object ejbSessionBean_;

    public void setUri(String uri) {
	uri_ = uri;
    }

    public void setProxyName(String proxyName) {
	proxyName_ = proxyName;
    }

    public Object invoke(String methodName, String[] params)
	throws RemoteException, NamingException, CreateException,
	       IllegalAccessException, IllegalArgumentException,
	       InvocationTargetException,
               NoSuchMethodException, InstantiationException,
	       ClassNotFoundException {

	_ensureOpen();
	Method method = _findMethod(methodName, params);
	return (method.invoke(ejbSessionBean_, _makeParams(method, params)));
    }

    private Object[] _makeParams(Method method, String[] tokens)
	throws NoSuchMethodException, IllegalAccessException,
	       InstantiationException, InvocationTargetException {

	Class[] types = method.getParameterTypes();
	if (types.length != tokens.length) {
	    throw (new InternalError());
	}
	Object[] params = new Object[tokens.length];
	for (int i = 0;i < tokens.length;i++) {
	    params[i] = _makeParam(tokens[i], types[i]);
	}
	return (params);
    }

    private Object _makeParam(String token, Class type)
	throws NoSuchMethodException, InstantiationException,
	       IllegalAccessException, InvocationTargetException {

	if (type == Boolean.class ||
	    type == Boolean.TYPE) {

	    if (token.equals("true")) {
		return (Boolean.TRUE);
	    } else {
		return (Boolean.FALSE);
	    }
	} else if (type == Byte.class ||
		   type == Byte.TYPE) {

	    return (new Byte(token));
	} else if (type == Short.class ||
		   type == Short.TYPE) {

	    return (new Short(token));
	} else if (type == Integer.class ||
		   type == Integer.TYPE) {

	    return (new Integer(token));
	} else if (type == Long.class ||
		   type == Long.TYPE) {

	    return (new Long(token));
	} else if (type == Float.class ||
		   type == Float.TYPE) {

	    return (new Float(token));
	} else if (type == Double.class ||
		   type == Double.TYPE) {

	    return (new Double(token));
	} else {
	    Constructor constructor = type.getConstructor(
		new Class[] { String.class }
	    );
	    return (constructor.newInstance(new Object[] { token }));
	}
    }

    private Method _findMethod(String methodName, String[] params)
	throws NoSuchMethodException,
	       InstantiationException {

	Method[] methods = ejbSessionBean_.getClass().getMethods();
	for (int i = 0;i < methods.length;i++) {
	    Method method = methods[i];
	    if (methodName.equals(method.getName()) &&
		method.getParameterTypes().length == params.length) {

		return (method);
	    }
	}
	return (null);
    }

    public void open()
	throws RemoteException, NamingException, CreateException,
	       IllegalAccessException, IllegalArgumentException,
	       InvocationTargetException, NoSuchMethodException,
	       ClassNotFoundException, InstantiationException {

	open(uri_);
    }

    public void open(String uri)
	throws RemoteException, NamingException, CreateException,
	       IllegalAccessException, IllegalArgumentException,
	       InvocationTargetException, NoSuchMethodException,
	       ClassNotFoundException, InstantiationException {

	if (proxyName_ != null) {
	    _openProxy(uri, proxyName_);
	} else {
	    _openDirect(uri);
	}
    }

    private void _openProxy(String uri, String proxyName)
	throws ClassNotFoundException, NoSuchMethodException,
	       InstantiationException, IllegalAccessException,
	       InvocationTargetException {

	Class proxyClass = Class.forName(proxyName);
	Constructor constructor = proxyClass.getConstructor(
	    new Class[] { String.class }
	);
	ejbSessionBean_ = constructor.newInstance(
	    new Object[] { uri }
	);
    }

    private void _openDirect(String uri)
	throws RemoteException, NamingException, CreateException,
	       IllegalAccessException, IllegalArgumentException,
	       InvocationTargetException, NoSuchMethodException {

        Context initialContext = new InitialContext();
        Object home = PortableRemoteObject.narrow(
	    initialContext.lookup(uri),
	    Object.class	// XXX
	);
	Class ejbHome = home.getClass();
	Method createMethod = ejbHome.getMethod("create", new Class[0]);
	if (createMethod == null) {
	    throw (new CreateException());
	}
	ejbSessionBean_ = createMethod.invoke(ejbHome, new Object[0]);
    }

    protected final void _ensureOpen()
	throws RemoteException, NamingException, CreateException,
	       IllegalAccessException, IllegalArgumentException,
	       InvocationTargetException, NoSuchMethodException,
	       ClassNotFoundException, InstantiationException {

	if (ejbSessionBean_ == null) {
	    open();
	}
    }
}
