/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.auth;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/**
 * RAuthManager
 *
 * @since   Sep.  5, 2002
 * @version Sep.  5, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RAuthManager {
    private RAuthFactory factory_;

    public RAuthManager(String uri)
	throws IOException, SAXException, ParserConfigurationException {

	factory_ = new RAuthFactory(uri);
    }

    public RAuthManager(
	String uri,
	String tableName,
	String userName,
	String password
    ) throws IOException, SAXException, ParserConfigurationException {
	factory_ = new RAuthFactory(uri, tableName, userName, password);
    }

    public RAuthManager(File file)
	throws IOException, SAXException, ParserConfigurationException {

	factory_ = new RAuthFactory(file);
    }

    public RAuthPrincipal login(String name, String password) {
	try {
	    RAuthPrincipal principal = factory_.getPrincipal(name);
	    if (principal == null) {
		return (null);
	    }
	    if (principal.isValid(password)) {
		return (principal);
	    } else {
		return (null);
	    }
	} catch (IOException e) {
	    throw (new InternalError());
	}
    }
}
