/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.schema;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * DataType
 *
 * @since   Aug. 17, 1999
 * @version Sep.  6, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class DataType {
    protected String name_;	// NCName
    protected boolean export_;
    protected DataTypeName baseType_;
//    protected Facet[] facets_;   don't need Facet object immediately
    // concrete model
    protected Facets facets_;

    public DataType(Element element) {
	SmartElement se = new SmartElement(element);
	name_ = se.getAttribute("name");
	export_ = se.getAttributeAsBoolean("export", true);
	NodeList nodes = se.getElementsByTagName("basetype");
	int size = nodes.getLength();
	if (size != 1) {
	    throw (new InternalError()); // XXX
	}
	baseType_ = DataTypeName.create((Element)nodes.item(0));
	facets_ = new Facets(se);
    }

    public String getName() {
	return (name_);
    }

    public boolean isExport() {
	return (export_);
    }

    public DataTypeName getBaseTye() {
	return (baseType_);
    }

    public static DataType create(Element root) {
	return (new DataType(root));
    }
}
