package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNZeroOrMore</b> is generated from relaxNg.rxm by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="zeroOrMore">
 *   <tag name="zeroOrMore">
 *     <attribute name="datatypeLibrary" type="ngURI"/>
 *   </tag>
 *   <sequence>
 *     <hedgeRef label="elementHedge" occurs="+"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="zeroOrMore"&gt;
 *   &lt;tag name="zeroOrMore"&gt;
 *     &lt;attribute name="datatypeLibrary" type="ngURI"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;hedgeRef label="elementHedge" occurs="+"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Fri Oct 31 17:09:05 JST 2003)
 * @author  Relaxer 1.0b (http://www.relaxer.org)
 */
public class RNZeroOrMore implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IRNElementHedgeChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    private String datatypeLibrary_;
    // List<IRNElementHedgeChoice>
    private java.util.List elementHedge_ = new java.util.ArrayList();
    private String xmlBase_;
    private Element xmlElement;
    private java.util.Map $directAttributes$_ = new java.util.HashMap();
    private IRNode parentRNode_;
    private RContext rContext_;

    /**
     * Creates a <code>RNZeroOrMore</code>.
     *
     */
    public RNZeroOrMore() {
    }

    /**
     * Creates a <code>RNZeroOrMore</code>.
     *
     * @param source
     */
    public RNZeroOrMore(RNZeroOrMore source) {
        setup(source);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNZeroOrMore(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNZeroOrMore(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNZeroOrMore(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNZeroOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNZeroOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNZeroOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNZeroOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNZeroOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNZeroOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNZeroOrMore</code> by the RNZeroOrMore <code>source</code>.
     *
     * @param source
     */
    public void setup(RNZeroOrMore source) {
        int size;
        setDatatypeLibrary(source.getDatatypeLibrary());
        this.elementHedge_.clear();
        size = source.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            addElementHedge((IRNElementHedgeChoice)source.getElementHedge(i).clone());
        }
        setXmlBase(source.getXmlBase());
    }

    /**
     * Initializes the <code>RNZeroOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNZeroOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNZeroOrMore</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        datatypeLibrary_ = URelaxer.getAttributePropertyAsString(element, "datatypeLibrary");
        elementHedge_.clear();
        while (true) {
            if (RNElement.isMatch(stack)) {
                addElementHedge(factory.createRNElement(stack));
            } else if (RNAttribute.isMatch(stack)) {
                addElementHedge(factory.createRNAttribute(stack));
            } else if (RNData.isMatch(stack)) {
                addElementHedge(factory.createRNData(stack));
            } else if (RNExternalRef.isMatch(stack)) {
                addElementHedge(factory.createRNExternalRef(stack));
            } else if (RNGrammar.isMatch(stack)) {
                addElementHedge(factory.createRNGrammar(stack));
            } else if (RNValue.isMatch(stack)) {
                addElementHedge(factory.createRNValue(stack));
            } else if (RNRef.isMatch(stack)) {
                addElementHedge(factory.createRNRef(stack));
            } else if (RNAnyName.isMatch(stack)) {
                addElementHedge(factory.createRNAnyName(stack));
            } else if (RNParentRef.isMatch(stack)) {
                addElementHedge(factory.createRNParentRef(stack));
            } else if (RNGroup.isMatch(stack)) {
                addElementHedge(factory.createRNGroup(stack));
            } else if (RNInterleave.isMatch(stack)) {
                addElementHedge(factory.createRNInterleave(stack));
            } else if (RNMixed.isMatch(stack)) {
                addElementHedge(factory.createRNMixed(stack));
            } else if (RNOptional.isMatch(stack)) {
                addElementHedge(factory.createRNOptional(stack));
            } else if (RNOneOrMore.isMatch(stack)) {
                addElementHedge(factory.createRNOneOrMore(stack));
            } else if (RNText.isMatch(stack)) {
                addElementHedge(factory.createRNText(stack));
            } else if (RNList.isMatch(stack)) {
                addElementHedge(factory.createRNList(stack));
            } else if (RNEmpty.isMatch(stack)) {
                addElementHedge(factory.createRNEmpty(stack));
            } else if (RNChoice.isMatch(stack)) {
                addElementHedge(factory.createRNChoice(stack));
            } else if (RNZeroOrMore.isMatch(stack)) {
                addElementHedge(factory.createRNZeroOrMore(stack));
            } else if (RNNotAllowed.isMatch(stack)) {
                addElementHedge(factory.createRNNotAllowed(stack));
            } else {
                break;
            }
        }
        xmlBase_ = URelaxer.getAttributePropertyAsString(element, "xml:base");
        URelaxer.getAttributeHungry(stack, "datatypeLibrary");
        URelaxer.getAttributeHungry(stack, "xml:base");
        stack.addDirectAttributes($directAttributes$_);
    }

    /**
     * @return Object
     */
    public Object clone() {
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        return (factory.createRNZeroOrMore(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "zeroOrMore");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.datatypeLibrary_ != null) {
            URelaxer.setAttributePropertyByString(element, "datatypeLibrary", this.datatypeLibrary_);
        }
        size = this.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNElementHedgeChoice value = (IRNElementHedgeChoice)this.elementHedge_.get(i);
            value.makeElement(element);
        }
        if (this.xmlBase_ != null) {
            URelaxer.setAttributePropertyByString(element, "xml:base", this.xmlBase_);
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            element.setAttribute(key, rGetAttribute(key));
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNZeroOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNZeroOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNZeroOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNZeroOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNZeroOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>datatypeLibrary</b>.
     *
     * @return String
     */
    public final String getDatatypeLibrary() {
        return (datatypeLibrary_);
    }

    /**
     * Sets the String property <b>datatypeLibrary</b>.
     *
     * @param datatypeLibrary
     */
    public final void setDatatypeLibrary(String datatypeLibrary) {
        this.datatypeLibrary_ = datatypeLibrary;
    }

    /**
     * Gets the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @return IRNElementHedgeChoice[]
     */
    public final IRNElementHedgeChoice[] getElementHedge() {
        IRNElementHedgeChoice[] array = new IRNElementHedgeChoice[elementHedge_.size()];
        return ((IRNElementHedgeChoice[])elementHedge_.toArray(array));
    }

    /**
     * Sets the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @param elementHedge
     */
    public final void setElementHedge(IRNElementHedgeChoice[] elementHedge) {
        this.elementHedge_.clear();
        for (int i = 0;i < elementHedge.length;i++) {
            addElementHedge(elementHedge[i]);
        }
        for (int i = 0;i < elementHedge.length;i++) {
            elementHedge[i].rSetParentRNode(this);
        }
        for (int i = 0;i < elementHedge.length;i++) {
            elementHedge[i].rSetRContext(rGetRContext());
        }
    }

    /**
     * Sets the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @param elementHedge
     */
    public final void setElementHedge(IRNElementHedgeChoice elementHedge) {
        this.elementHedge_.clear();
        addElementHedge(elementHedge);
        if (elementHedge != null) {
            elementHedge.rSetParentRNode(this);
        }
        if (elementHedge != null) {
            elementHedge.rSetRContext(rGetRContext());
        }
    }

    /**
     * Adds the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @param elementHedge
     */
    public final void addElementHedge(IRNElementHedgeChoice elementHedge) {
        this.elementHedge_.add(elementHedge);
        if (elementHedge != null) {
            elementHedge.rSetParentRNode(this);
        }
        if (elementHedge != null) {
            elementHedge.rSetRContext(rGetRContext());
        }
    }

    /**
     * Adds the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @param elementHedge
     */
    public final void addElementHedge(IRNElementHedgeChoice[] elementHedge) {
        for (int i = 0;i < elementHedge.length;i++) {
            addElementHedge(elementHedge[i]);
        }
        for (int i = 0;i < elementHedge.length;i++) {
            elementHedge[i].rSetParentRNode(this);
        }
        for (int i = 0;i < elementHedge.length;i++) {
            elementHedge[i].rSetRContext(rGetRContext());
        }
    }

    /**
     * Gets number of the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @return int
     */
    public final int sizeElementHedge() {
        return (elementHedge_.size());
    }

    /**
     * Gets the IRNElementHedgeChoice property <b>elementHedge</b> by index.
     *
     * @param index
     * @return IRNElementHedgeChoice
     */
    public final IRNElementHedgeChoice getElementHedge(int index) {
        return ((IRNElementHedgeChoice)elementHedge_.get(index));
    }

    /**
     * Sets the IRNElementHedgeChoice property <b>elementHedge</b> by index.
     *
     * @param index
     * @param elementHedge
     */
    public final void setElementHedge(int index, IRNElementHedgeChoice elementHedge) {
        this.elementHedge_.set(index, elementHedge);
        if (elementHedge != null) {
            elementHedge.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IRNElementHedgeChoice property <b>elementHedge</b> by index.
     *
     * @param index
     * @param elementHedge
     */
    public final void addElementHedge(int index, IRNElementHedgeChoice elementHedge) {
        this.elementHedge_.add(index, elementHedge);
        if (elementHedge != null) {
            elementHedge.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IRNElementHedgeChoice property <b>elementHedge</b> by index.
     *
     * @param index
     */
    public final void removeElementHedge(int index) {
        this.elementHedge_.remove(index);
    }

    /**
     * Remove the IRNElementHedgeChoice property <b>elementHedge</b> by object.
     *
     * @param elementHedge
     */
    public final void removeElementHedge(IRNElementHedgeChoice elementHedge) {
        this.elementHedge_.remove(elementHedge);
    }

    /**
     * Clear the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     */
    public final void clearElementHedge() {
        this.elementHedge_.clear();
    }

    /**
     * Gets the String property <b>xmlBase</b>.
     *
     * @return String
     */
    public final String getXmlBase() {
        return (xmlBase_);
    }

    /**
     * Sets the String property <b>xmlBase</b>.
     *
     * @param xmlBase
     */
    public final void setXmlBase(String xmlBase) {
        this.xmlBase_ = xmlBase;
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "zeroOrMore", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.append(" ");
            buffer.append("datatypeLibrary");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.append("\"");
        }
        size = this.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNElementHedgeChoice value = (IRNElementHedgeChoice)this.elementHedge_.get(i);
            value.makeTextAttribute(buffer);
        }
        if (xmlBase_ != null) {
            buffer.append(" ");
            buffer.append("xml:base");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getXmlBase())));
            buffer.append("\"");
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.append(" ");
            buffer.append(key);
            buffer.append("=\"");
            buffer.append(rGetAttribute(key));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNElementHedgeChoice value = (IRNElementHedgeChoice)this.elementHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "zeroOrMore", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.write("<");
        URelaxer.makeQName(prefix, "zeroOrMore", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.write(" ");
            buffer.write("datatypeLibrary");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.write("\"");
        }
        size = this.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNElementHedgeChoice value = (IRNElementHedgeChoice)this.elementHedge_.get(i);
            value.makeTextAttribute(buffer);
        }
        if (xmlBase_ != null) {
            buffer.write(" ");
            buffer.write("xml:base");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getXmlBase())));
            buffer.write("\"");
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.write(" ");
            buffer.write(key);
            buffer.write("=\"");
            buffer.write(rGetAttribute(key));
            buffer.write("\"");
        }
        buffer.write(">");
        size = this.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNElementHedgeChoice value = (IRNElementHedgeChoice)this.elementHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "zeroOrMore", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "zeroOrMore", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.print(" ");
            buffer.print("datatypeLibrary");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.print("\"");
        }
        size = this.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNElementHedgeChoice value = (IRNElementHedgeChoice)this.elementHedge_.get(i);
            value.makeTextAttribute(buffer);
        }
        if (xmlBase_ != null) {
            buffer.print(" ");
            buffer.print("xml:base");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getXmlBase())));
            buffer.print("\"");
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.print(" ");
            buffer.print(key);
            buffer.print("=\"");
            buffer.print(rGetAttribute(key));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNElementHedgeChoice value = (IRNElementHedgeChoice)this.elementHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "zeroOrMore", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDatatypeLibraryAsString() {
        return (URelaxer.getString(getDatatypeLibrary()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getXmlBaseAsString() {
        return (URelaxer.getString(getXmlBase()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDatatypeLibraryByString(String string) {
        setDatatypeLibrary(URelaxer.getString(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setXmlBaseByString(String string) {
        setXmlBase(URelaxer.getString(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets a value of the attribute.
     *
     * @param qName
     * @return String
     */
    public String rGetAttribute(String qName) {
        return ((String)$directAttributes$_.get(qName));
    }

    /**
     * Sets a value of the attribute.
     *
     * @param qName
     * @param value
     */
    public void rSetAttribute(String qName, String value) {
        $directAttributes$_.put(qName, value);
    }

    /**
     * Gets attribute keys.
     *
     * @return String[]
     */
    public String[] rGetAttributeKeys() {
        java.util.Set keys = $directAttributes$_.keySet();
        String[] result = new String[keys.size()];
        return ((String[])keys.toArray(result));
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(elementHedge_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Gets the RContext property <b>rContext</b>.
     *
     * @return RContext
     */
    public final RContext rGetRContext() {
        return (rContext_);
    }

    /**
     * Sets the RContext property <b>rContext</b>.
     *
     * @param rContext
     */
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = rGetRNodes();
        for (int i = 0;i < contextRNodes.length;i++) {
            contextRNodes[i].rSetRContext(rContext_);
        }
    }

    /**
     * Gets the property "xml:base" which is resolved recursively.
     *
     * @return String
     */
    public String rGetXmlBaseResolved() {
        if (parentRNode_ != null) {
            if (xmlBase_ != null) {
                return (URelaxer.makeUrlString(parentRNode_.rGetXmlBaseResolved(), xmlBase_));
            } else {
                return (parentRNode_.rGetXmlBaseResolved());
            }
        } else {
            RContext rContext = rGetRContextResolved();
            if (rContext != null) {
                return (URelaxer.makeUrlString(rContext.getBaseURL(), xmlBase_));
            } else {
                return (xmlBase_);
            }
        }
    }

    /**
     * Gets the property "rContext" which is resolved recursively.
     *
     * @return RContext
     */
    public RContext rGetRContextResolved() {
        if (rContext_ != null) {
            return (rContext_);
        }
        if (parentRNode_ == null) {
            return (null);
        }
        return (parentRNode_.rGetRContextResolved());
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNZeroOrMore</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "zeroOrMore")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RNElement.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNAttribute.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNData.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNExternalRef.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNGrammar.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNValue.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNRef.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNAnyName.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNParentRef.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNGroup.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNInterleave.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNMixed.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNOptional.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNOneOrMore.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNText.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNList.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNEmpty.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNChoice.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNZeroOrMore.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNNotAllowed.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        while (true) {
            if (RNElement.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNAttribute.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNData.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNExternalRef.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNGrammar.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNRef.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNAnyName.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNParentRef.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNGroup.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNInterleave.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNMixed.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNOptional.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNOneOrMore.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNText.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNList.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNEmpty.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNChoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNZeroOrMore.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNNotAllowed.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNZeroOrMore</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNZeroOrMore</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
