package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNInclude</b> is generated from relaxNg.rxm by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="include">
 *   <tag name="include">
 *     <attribute name="href" type="ngToken"/>
 *     <attribute name="datatypeLibrary" type="ngURI"/>
 *   </tag>
 *   <sequence>
 *     <hedgeRef label="includeContent" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="include"&gt;
 *   &lt;tag name="include"&gt;
 *     &lt;attribute name="href" type="ngToken"/&gt;
 *     &lt;attribute name="datatypeLibrary" type="ngURI"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;hedgeRef label="includeContent" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Fri Oct 31 17:09:05 JST 2003)
 * @author  Relaxer 1.0b (http://www.relaxer.org)
 */
public class RNInclude implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IRNGrammarContentChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    private String href_;
    private String datatypeLibrary_;
    // List<IRNIncludeContentChoice>
    private java.util.List includeContent_ = new java.util.ArrayList();
    private String xmlBase_;
    private Element xmlElement;
    private java.util.Map $directAttributes$_ = new java.util.HashMap();
    private IRNode parentRNode_;
    private RContext rContext_;

    /**
     * Creates a <code>RNInclude</code>.
     *
     */
    public RNInclude() {
    }

    /**
     * Creates a <code>RNInclude</code>.
     *
     * @param source
     */
    public RNInclude(RNInclude source) {
        setup(source);
    }

    /**
     * Creates a <code>RNInclude</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNInclude(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNInclude</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNInclude(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNInclude</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNInclude(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNInclude</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNInclude</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNInclude</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNInclude</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNInclude</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNInclude</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNInclude</code> by the RNInclude <code>source</code>.
     *
     * @param source
     */
    public void setup(RNInclude source) {
        int size;
        setHref(source.getHref());
        setDatatypeLibrary(source.getDatatypeLibrary());
        this.includeContent_.clear();
        size = source.includeContent_.size();
        for (int i = 0;i < size;i++) {
            addIncludeContent((IRNIncludeContentChoice)source.getIncludeContent(i).clone());
        }
        setXmlBase(source.getXmlBase());
    }

    /**
     * Initializes the <code>RNInclude</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNInclude</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNInclude</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        href_ = URelaxer.getAttributePropertyAsString(element, "href");
        datatypeLibrary_ = URelaxer.getAttributePropertyAsString(element, "datatypeLibrary");
        includeContent_.clear();
        while (true) {
            if (RNDefine.isMatch(stack)) {
                addIncludeContent(factory.createRNDefine(stack));
            } else if (RNStart.isMatch(stack)) {
                addIncludeContent(factory.createRNStart(stack));
            } else if (RNDiv.isMatch(stack)) {
                addIncludeContent(factory.createRNDiv(stack));
            } else {
                break;
            }
        }
        xmlBase_ = URelaxer.getAttributePropertyAsString(element, "xml:base");
        URelaxer.getAttributeHungry(stack, "href");
        URelaxer.getAttributeHungry(stack, "datatypeLibrary");
        URelaxer.getAttributeHungry(stack, "xml:base");
        stack.addDirectAttributes($directAttributes$_);
    }

    /**
     * @return Object
     */
    public Object clone() {
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        return (factory.createRNInclude(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "include");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.href_ != null) {
            URelaxer.setAttributePropertyByString(element, "href", this.href_);
        }
        if (this.datatypeLibrary_ != null) {
            URelaxer.setAttributePropertyByString(element, "datatypeLibrary", this.datatypeLibrary_);
        }
        size = this.includeContent_.size();
        for (int i = 0;i < size;i++) {
            IRNIncludeContentChoice value = (IRNIncludeContentChoice)this.includeContent_.get(i);
            value.makeElement(element);
        }
        if (this.xmlBase_ != null) {
            URelaxer.setAttributePropertyByString(element, "xml:base", this.xmlBase_);
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            element.setAttribute(key, rGetAttribute(key));
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNInclude</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNInclude</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNInclude</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNInclude</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNInclude</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNInclude</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>href</b>.
     *
     * @return String
     */
    public final String getHref() {
        return (href_);
    }

    /**
     * Sets the String property <b>href</b>.
     *
     * @param href
     */
    public final void setHref(String href) {
        this.href_ = href;
    }

    /**
     * Gets the String property <b>datatypeLibrary</b>.
     *
     * @return String
     */
    public final String getDatatypeLibrary() {
        return (datatypeLibrary_);
    }

    /**
     * Sets the String property <b>datatypeLibrary</b>.
     *
     * @param datatypeLibrary
     */
    public final void setDatatypeLibrary(String datatypeLibrary) {
        this.datatypeLibrary_ = datatypeLibrary;
    }

    /**
     * Gets the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @return IRNIncludeContentChoice[]
     */
    public final IRNIncludeContentChoice[] getIncludeContent() {
        IRNIncludeContentChoice[] array = new IRNIncludeContentChoice[includeContent_.size()];
        return ((IRNIncludeContentChoice[])includeContent_.toArray(array));
    }

    /**
     * Sets the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @param includeContent
     */
    public final void setIncludeContent(IRNIncludeContentChoice[] includeContent) {
        this.includeContent_.clear();
        for (int i = 0;i < includeContent.length;i++) {
            addIncludeContent(includeContent[i]);
        }
        for (int i = 0;i < includeContent.length;i++) {
            includeContent[i].rSetParentRNode(this);
        }
        for (int i = 0;i < includeContent.length;i++) {
            includeContent[i].rSetRContext(rGetRContext());
        }
    }

    /**
     * Sets the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @param includeContent
     */
    public final void setIncludeContent(IRNIncludeContentChoice includeContent) {
        this.includeContent_.clear();
        addIncludeContent(includeContent);
        if (includeContent != null) {
            includeContent.rSetParentRNode(this);
        }
        if (includeContent != null) {
            includeContent.rSetRContext(rGetRContext());
        }
    }

    /**
     * Adds the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @param includeContent
     */
    public final void addIncludeContent(IRNIncludeContentChoice includeContent) {
        this.includeContent_.add(includeContent);
        if (includeContent != null) {
            includeContent.rSetParentRNode(this);
        }
        if (includeContent != null) {
            includeContent.rSetRContext(rGetRContext());
        }
    }

    /**
     * Adds the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @param includeContent
     */
    public final void addIncludeContent(IRNIncludeContentChoice[] includeContent) {
        for (int i = 0;i < includeContent.length;i++) {
            addIncludeContent(includeContent[i]);
        }
        for (int i = 0;i < includeContent.length;i++) {
            includeContent[i].rSetParentRNode(this);
        }
        for (int i = 0;i < includeContent.length;i++) {
            includeContent[i].rSetRContext(rGetRContext());
        }
    }

    /**
     * Gets number of the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @return int
     */
    public final int sizeIncludeContent() {
        return (includeContent_.size());
    }

    /**
     * Gets the IRNIncludeContentChoice property <b>includeContent</b> by index.
     *
     * @param index
     * @return IRNIncludeContentChoice
     */
    public final IRNIncludeContentChoice getIncludeContent(int index) {
        return ((IRNIncludeContentChoice)includeContent_.get(index));
    }

    /**
     * Sets the IRNIncludeContentChoice property <b>includeContent</b> by index.
     *
     * @param index
     * @param includeContent
     */
    public final void setIncludeContent(int index, IRNIncludeContentChoice includeContent) {
        this.includeContent_.set(index, includeContent);
        if (includeContent != null) {
            includeContent.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IRNIncludeContentChoice property <b>includeContent</b> by index.
     *
     * @param index
     * @param includeContent
     */
    public final void addIncludeContent(int index, IRNIncludeContentChoice includeContent) {
        this.includeContent_.add(index, includeContent);
        if (includeContent != null) {
            includeContent.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IRNIncludeContentChoice property <b>includeContent</b> by index.
     *
     * @param index
     */
    public final void removeIncludeContent(int index) {
        this.includeContent_.remove(index);
    }

    /**
     * Remove the IRNIncludeContentChoice property <b>includeContent</b> by object.
     *
     * @param includeContent
     */
    public final void removeIncludeContent(IRNIncludeContentChoice includeContent) {
        this.includeContent_.remove(includeContent);
    }

    /**
     * Clear the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     */
    public final void clearIncludeContent() {
        this.includeContent_.clear();
    }

    /**
     * Gets the String property <b>xmlBase</b>.
     *
     * @return String
     */
    public final String getXmlBase() {
        return (xmlBase_);
    }

    /**
     * Sets the String property <b>xmlBase</b>.
     *
     * @param xmlBase
     */
    public final void setXmlBase(String xmlBase) {
        this.xmlBase_ = xmlBase;
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "include", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (href_ != null) {
            buffer.append(" ");
            buffer.append("href");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getHref())));
            buffer.append("\"");
        }
        if (datatypeLibrary_ != null) {
            buffer.append(" ");
            buffer.append("datatypeLibrary");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.append("\"");
        }
        size = this.includeContent_.size();
        for (int i = 0;i < size;i++) {
            IRNIncludeContentChoice value = (IRNIncludeContentChoice)this.includeContent_.get(i);
            value.makeTextAttribute(buffer);
        }
        if (xmlBase_ != null) {
            buffer.append(" ");
            buffer.append("xml:base");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getXmlBase())));
            buffer.append("\"");
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.append(" ");
            buffer.append(key);
            buffer.append("=\"");
            buffer.append(rGetAttribute(key));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.includeContent_.size();
        for (int i = 0;i < size;i++) {
            IRNIncludeContentChoice value = (IRNIncludeContentChoice)this.includeContent_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "include", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.write("<");
        URelaxer.makeQName(prefix, "include", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (href_ != null) {
            buffer.write(" ");
            buffer.write("href");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getHref())));
            buffer.write("\"");
        }
        if (datatypeLibrary_ != null) {
            buffer.write(" ");
            buffer.write("datatypeLibrary");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.write("\"");
        }
        size = this.includeContent_.size();
        for (int i = 0;i < size;i++) {
            IRNIncludeContentChoice value = (IRNIncludeContentChoice)this.includeContent_.get(i);
            value.makeTextAttribute(buffer);
        }
        if (xmlBase_ != null) {
            buffer.write(" ");
            buffer.write("xml:base");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getXmlBase())));
            buffer.write("\"");
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.write(" ");
            buffer.write(key);
            buffer.write("=\"");
            buffer.write(rGetAttribute(key));
            buffer.write("\"");
        }
        buffer.write(">");
        size = this.includeContent_.size();
        for (int i = 0;i < size;i++) {
            IRNIncludeContentChoice value = (IRNIncludeContentChoice)this.includeContent_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "include", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "include", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (href_ != null) {
            buffer.print(" ");
            buffer.print("href");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getHref())));
            buffer.print("\"");
        }
        if (datatypeLibrary_ != null) {
            buffer.print(" ");
            buffer.print("datatypeLibrary");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.print("\"");
        }
        size = this.includeContent_.size();
        for (int i = 0;i < size;i++) {
            IRNIncludeContentChoice value = (IRNIncludeContentChoice)this.includeContent_.get(i);
            value.makeTextAttribute(buffer);
        }
        if (xmlBase_ != null) {
            buffer.print(" ");
            buffer.print("xml:base");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getXmlBase())));
            buffer.print("\"");
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.print(" ");
            buffer.print(key);
            buffer.print("=\"");
            buffer.print(rGetAttribute(key));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.includeContent_.size();
        for (int i = 0;i < size;i++) {
            IRNIncludeContentChoice value = (IRNIncludeContentChoice)this.includeContent_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "include", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getHrefAsString() {
        return (URelaxer.getString(getHref()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDatatypeLibraryAsString() {
        return (URelaxer.getString(getDatatypeLibrary()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getXmlBaseAsString() {
        return (URelaxer.getString(getXmlBase()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setHrefByString(String string) {
        setHref(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDatatypeLibraryByString(String string) {
        setDatatypeLibrary(URelaxer.getString(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setXmlBaseByString(String string) {
        setXmlBase(URelaxer.getString(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets a value of the attribute.
     *
     * @param qName
     * @return String
     */
    public String rGetAttribute(String qName) {
        return ((String)$directAttributes$_.get(qName));
    }

    /**
     * Sets a value of the attribute.
     *
     * @param qName
     * @param value
     */
    public void rSetAttribute(String qName, String value) {
        $directAttributes$_.put(qName, value);
    }

    /**
     * Gets attribute keys.
     *
     * @return String[]
     */
    public String[] rGetAttributeKeys() {
        java.util.Set keys = $directAttributes$_.keySet();
        String[] result = new String[keys.size()];
        return ((String[])keys.toArray(result));
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(includeContent_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Gets the RContext property <b>rContext</b>.
     *
     * @return RContext
     */
    public final RContext rGetRContext() {
        return (rContext_);
    }

    /**
     * Sets the RContext property <b>rContext</b>.
     *
     * @param rContext
     */
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = rGetRNodes();
        for (int i = 0;i < contextRNodes.length;i++) {
            contextRNodes[i].rSetRContext(rContext_);
        }
    }

    /**
     * Gets the property "xml:base" which is resolved recursively.
     *
     * @return String
     */
    public String rGetXmlBaseResolved() {
        if (parentRNode_ != null) {
            if (xmlBase_ != null) {
                return (URelaxer.makeUrlString(parentRNode_.rGetXmlBaseResolved(), xmlBase_));
            } else {
                return (parentRNode_.rGetXmlBaseResolved());
            }
        } else {
            RContext rContext = rGetRContextResolved();
            if (rContext != null) {
                return (URelaxer.makeUrlString(rContext.getBaseURL(), xmlBase_));
            } else {
                return (xmlBase_);
            }
        }
    }

    /**
     * Gets the property "rContext" which is resolved recursively.
     *
     * @return RContext
     */
    public RContext rGetRContextResolved() {
        if (rContext_ != null) {
            return (rContext_);
        }
        if (parentRNode_ == null) {
            return (null);
        }
        return (parentRNode_.rGetRContextResolved());
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNInclude</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "include")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (RNDefine.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNStart.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNDiv.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNInclude</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNInclude</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
