package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.File;
import java.net.MalformedURLException;

/**
 * @version relaxNg.rxm 1.0 (Fri Oct 31 17:09:07 JST 2003)
 * @author  Relaxer 1.0b (http://www.relaxer.org)
 */
public class RContext {
    private java.net.URL baseURL;
    private java.util.Map properties_ = new java.util.HashMap();

    /**
     * Creates a <code>RContext</code> by the File <code>file</code>.
     *
     */
    public RContext() {
    }

    /**
     * Creates a <code>RContext</code> by the File <code>file</code>.
     *
     * @param file
     * @exception MalformedURLException
     */
    public RContext(File file) throws MalformedURLException {
        baseURL = file.toURL();
    }

    /**
     * Creates a <code>RContext</code> by the URL <code>url</code>.
     *
     * @param url
     */
    public RContext(java.net.URL url) {
        baseURL = url;
    }

    /**
     * Creates a <code>RContext</code> by the File <code>file</code>.
     *
     * @param uri
     * @exception MalformedURLException
     */
    public RContext(String uri) throws MalformedURLException {
        baseURL = new java.net.URL(uri);
    }

    /**
     * Gets a property value.
     *
     * @param key
     * @return Object
     */
    public Object getProperty(String key) {
        return (properties_.get(key));
    }

    /**
     * Sets a property value.
     *
     * @param key
     * @param value
     */
    public void setProperty(String key, Object value) {
        properties_.put(key, value);
    }

    /**
     * Geneates a id string.
     *
     * @return String
     */
    public String makeAutoID() {
        return (URelaxer.makeAutoID());
    }

    /**
     * Gets the java.net.URL property <b>baseURL</b>.
     *
     * @return java.net.URL
     */
    public final java.net.URL getBaseURL() {
        return (baseURL);
    }

    /**
     * Sets the java.net.URL property <b>baseURL</b>.
     *
     * @param baseURL
     */
    public final void setBaseURL(java.net.URL baseURL) {
        this.baseURL = baseURL;
    }
}
