package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * IRelaxNgFactory is generated by Relaxer based on relaxNg.rxm.
 *
 * @version relaxNg.rxm 1.0 (Fri Oct 31 17:09:07 JST 2003)
 * @author  Relaxer 1.0b (http://www.relaxer.org)
 */
public interface IRelaxNgFactory {
    /**
     * Sets a <b>errorHandler</b>.
     *
     * @param errorHandler
     */
    void setErrorHandler(org.xml.sax.ErrorHandler errorHandler);

    /**
     * Gets a <b>errorHandler</b>.
     *
     * @return org.xml.sax.ErrorHandler
     */
    org.xml.sax.ErrorHandler getErrorHandler();

    /**
     * Sets a <b>entityResolver</b>.
     *
     * @param entityResolver
     */
    void setEntityResolver(org.xml.sax.EntityResolver entityResolver);

    /**
     * Gets a <b>entityResolver</b>.
     *
     * @return org.xml.sax.EntityResolver
     */
    org.xml.sax.EntityResolver getEntityResolver();

    /**
     * Sets a <b>baseUri</b>.
     *
     * @param baseUri
     */
    void setBaseUri(String baseUri);

    /**
     * Gets a <b>baseUri</b>.
     *
     * @return String
     */
    String getBaseUri();

    /**
     * Creates a <code>Object</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Object <code>source</code>.
     *
     * @param source
     * @return IRNode
     */
    IRNode create(IRNode source);

    /**
     * Creates a <code>Object</code> by the Object <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return IRNode
     */
    IRNode create(IRNode source, RContext rContext);

    /**
     * Creates a <code>Object</code> by the Document <code>dom</code>.
     *
     * @param doc
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(Document doc) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(Document doc, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Element <code>element</code>.
     *
     * @param element
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(Element element) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    IRNode create(Element element, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code> by the File <code>file</code>.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code> by the URL <code>url</code>.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNStart</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    RNStart createRNStart(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAttribute</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNsName</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    RNNsName createRNNsName(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExcept</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    RNExcept createRNExcept(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNName</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    RNName createRNName(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNAnyName</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNameChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDefine</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    RNDefine createRNDefine(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNElement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    RNElement createRNElement(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNData</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    RNData createRNData(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParam</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    RNParam createRNParam(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNValue</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    RNValue createRNValue(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    RNRef createRNRef(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNText</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    RNText createRNText(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNNotAllowed</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNEmpty</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextOptional</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    RNList createRNList(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextGroup</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNTextExcept</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNExternalRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNParentRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGroup</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    RNGroup createRNGroup(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    RNChoice createRNChoice(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInterleave</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOneOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNMixed</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    RNMixed createRNMixed(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNOptional</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    RNOptional createRNOptional(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNZeroOrMore</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNInclude</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    RNInclude createRNInclude(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNDiv</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    RNDiv createRNDiv(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>RNGrammar</code>.
     *
     * @return RNGrammar
     */
    RNGrammar createRNGrammar();

    /**
     * Creates a <code>RNStart</code>.
     *
     * @return RNStart
     */
    RNStart createRNStart();

    /**
     * Creates a <code>RNAttribute</code>.
     *
     * @return RNAttribute
     */
    RNAttribute createRNAttribute();

    /**
     * Creates a <code>RNNsName</code>.
     *
     * @return RNNsName
     */
    RNNsName createRNNsName();

    /**
     * Creates a <code>RNExcept</code>.
     *
     * @return RNExcept
     */
    RNExcept createRNExcept();

    /**
     * Creates a <code>RNName</code>.
     *
     * @return RNName
     */
    RNName createRNName();

    /**
     * Creates a <code>RNAnyName</code>.
     *
     * @return RNAnyName
     */
    RNAnyName createRNAnyName();

    /**
     * Creates a <code>RNNameChoice</code>.
     *
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice();

    /**
     * Creates a <code>RNDefine</code>.
     *
     * @return RNDefine
     */
    RNDefine createRNDefine();

    /**
     * Creates a <code>RNElement</code>.
     *
     * @return RNElement
     */
    RNElement createRNElement();

    /**
     * Creates a <code>RNData</code>.
     *
     * @return RNData
     */
    RNData createRNData();

    /**
     * Creates a <code>RNParam</code>.
     *
     * @return RNParam
     */
    RNParam createRNParam();

    /**
     * Creates a <code>RNValue</code>.
     *
     * @return RNValue
     */
    RNValue createRNValue();

    /**
     * Creates a <code>RNRef</code>.
     *
     * @return RNRef
     */
    RNRef createRNRef();

    /**
     * Creates a <code>RNTextOneOrMore</code>.
     *
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore();

    /**
     * Creates a <code>RNText</code>.
     *
     * @return RNText
     */
    RNText createRNText();

    /**
     * Creates a <code>RNNotAllowed</code>.
     *
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed();

    /**
     * Creates a <code>RNEmpty</code>.
     *
     * @return RNEmpty
     */
    RNEmpty createRNEmpty();

    /**
     * Creates a <code>RNTextChoice</code>.
     *
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice();

    /**
     * Creates a <code>RNTextOptional</code>.
     *
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional();

    /**
     * Creates a <code>RNTextZeroOrMore</code>.
     *
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore();

    /**
     * Creates a <code>RNList</code>.
     *
     * @return RNList
     */
    RNList createRNList();

    /**
     * Creates a <code>RNTextGroup</code>.
     *
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup();

    /**
     * Creates a <code>RNTextExcept</code>.
     *
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept();

    /**
     * Creates a <code>RNExternalRef</code>.
     *
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef();

    /**
     * Creates a <code>RNParentRef</code>.
     *
     * @return RNParentRef
     */
    RNParentRef createRNParentRef();

    /**
     * Creates a <code>RNGroup</code>.
     *
     * @return RNGroup
     */
    RNGroup createRNGroup();

    /**
     * Creates a <code>RNChoice</code>.
     *
     * @return RNChoice
     */
    RNChoice createRNChoice();

    /**
     * Creates a <code>RNInterleave</code>.
     *
     * @return RNInterleave
     */
    RNInterleave createRNInterleave();

    /**
     * Creates a <code>RNOneOrMore</code>.
     *
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore();

    /**
     * Creates a <code>RNMixed</code>.
     *
     * @return RNMixed
     */
    RNMixed createRNMixed();

    /**
     * Creates a <code>RNOptional</code>.
     *
     * @return RNOptional
     */
    RNOptional createRNOptional();

    /**
     * Creates a <code>RNZeroOrMore</code>.
     *
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore();

    /**
     * Creates a <code>RNInclude</code>.
     *
     * @return RNInclude
     */
    RNInclude createRNInclude();

    /**
     * Creates a <code>RNDiv</code>.
     *
     * @return RNDiv
     */
    RNDiv createRNDiv();

    /**
     * Creates a <code>RNGrammar</code>.
     *
     * @param rContext
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(RContext rContext);

    /**
     * Creates a <code>RNStart</code>.
     *
     * @param rContext
     * @return RNStart
     */
    RNStart createRNStart(RContext rContext);

    /**
     * Creates a <code>RNAttribute</code>.
     *
     * @param rContext
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(RContext rContext);

    /**
     * Creates a <code>RNNsName</code>.
     *
     * @param rContext
     * @return RNNsName
     */
    RNNsName createRNNsName(RContext rContext);

    /**
     * Creates a <code>RNExcept</code>.
     *
     * @param rContext
     * @return RNExcept
     */
    RNExcept createRNExcept(RContext rContext);

    /**
     * Creates a <code>RNName</code>.
     *
     * @param rContext
     * @return RNName
     */
    RNName createRNName(RContext rContext);

    /**
     * Creates a <code>RNAnyName</code>.
     *
     * @param rContext
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(RContext rContext);

    /**
     * Creates a <code>RNNameChoice</code>.
     *
     * @param rContext
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(RContext rContext);

    /**
     * Creates a <code>RNDefine</code>.
     *
     * @param rContext
     * @return RNDefine
     */
    RNDefine createRNDefine(RContext rContext);

    /**
     * Creates a <code>RNElement</code>.
     *
     * @param rContext
     * @return RNElement
     */
    RNElement createRNElement(RContext rContext);

    /**
     * Creates a <code>RNData</code>.
     *
     * @param rContext
     * @return RNData
     */
    RNData createRNData(RContext rContext);

    /**
     * Creates a <code>RNParam</code>.
     *
     * @param rContext
     * @return RNParam
     */
    RNParam createRNParam(RContext rContext);

    /**
     * Creates a <code>RNValue</code>.
     *
     * @param rContext
     * @return RNValue
     */
    RNValue createRNValue(RContext rContext);

    /**
     * Creates a <code>RNRef</code>.
     *
     * @param rContext
     * @return RNRef
     */
    RNRef createRNRef(RContext rContext);

    /**
     * Creates a <code>RNTextOneOrMore</code>.
     *
     * @param rContext
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(RContext rContext);

    /**
     * Creates a <code>RNText</code>.
     *
     * @param rContext
     * @return RNText
     */
    RNText createRNText(RContext rContext);

    /**
     * Creates a <code>RNNotAllowed</code>.
     *
     * @param rContext
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(RContext rContext);

    /**
     * Creates a <code>RNEmpty</code>.
     *
     * @param rContext
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(RContext rContext);

    /**
     * Creates a <code>RNTextChoice</code>.
     *
     * @param rContext
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(RContext rContext);

    /**
     * Creates a <code>RNTextOptional</code>.
     *
     * @param rContext
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(RContext rContext);

    /**
     * Creates a <code>RNTextZeroOrMore</code>.
     *
     * @param rContext
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(RContext rContext);

    /**
     * Creates a <code>RNList</code>.
     *
     * @param rContext
     * @return RNList
     */
    RNList createRNList(RContext rContext);

    /**
     * Creates a <code>RNTextGroup</code>.
     *
     * @param rContext
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(RContext rContext);

    /**
     * Creates a <code>RNTextExcept</code>.
     *
     * @param rContext
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(RContext rContext);

    /**
     * Creates a <code>RNExternalRef</code>.
     *
     * @param rContext
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(RContext rContext);

    /**
     * Creates a <code>RNParentRef</code>.
     *
     * @param rContext
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(RContext rContext);

    /**
     * Creates a <code>RNGroup</code>.
     *
     * @param rContext
     * @return RNGroup
     */
    RNGroup createRNGroup(RContext rContext);

    /**
     * Creates a <code>RNChoice</code>.
     *
     * @param rContext
     * @return RNChoice
     */
    RNChoice createRNChoice(RContext rContext);

    /**
     * Creates a <code>RNInterleave</code>.
     *
     * @param rContext
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(RContext rContext);

    /**
     * Creates a <code>RNOneOrMore</code>.
     *
     * @param rContext
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(RContext rContext);

    /**
     * Creates a <code>RNMixed</code>.
     *
     * @param rContext
     * @return RNMixed
     */
    RNMixed createRNMixed(RContext rContext);

    /**
     * Creates a <code>RNOptional</code>.
     *
     * @param rContext
     * @return RNOptional
     */
    RNOptional createRNOptional(RContext rContext);

    /**
     * Creates a <code>RNZeroOrMore</code>.
     *
     * @param rContext
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(RContext rContext);

    /**
     * Creates a <code>RNInclude</code>.
     *
     * @param rContext
     * @return RNInclude
     */
    RNInclude createRNInclude(RContext rContext);

    /**
     * Creates a <code>RNDiv</code>.
     *
     * @param rContext
     * @return RNDiv
     */
    RNDiv createRNDiv(RContext rContext);

    /**
     * Creates a <code>RNGrammar</code> by the RNGrammar <code>source</code>.
     *
     * @param source
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(RNGrammar source);

    /**
     * Creates a <code>RNStart</code> by the RNStart <code>source</code>.
     *
     * @param source
     * @return RNStart
     */
    RNStart createRNStart(RNStart source);

    /**
     * Creates a <code>RNAttribute</code> by the RNAttribute <code>source</code>.
     *
     * @param source
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(RNAttribute source);

    /**
     * Creates a <code>RNNsName</code> by the RNNsName <code>source</code>.
     *
     * @param source
     * @return RNNsName
     */
    RNNsName createRNNsName(RNNsName source);

    /**
     * Creates a <code>RNExcept</code> by the RNExcept <code>source</code>.
     *
     * @param source
     * @return RNExcept
     */
    RNExcept createRNExcept(RNExcept source);

    /**
     * Creates a <code>RNName</code> by the RNName <code>source</code>.
     *
     * @param source
     * @return RNName
     */
    RNName createRNName(RNName source);

    /**
     * Creates a <code>RNAnyName</code> by the RNAnyName <code>source</code>.
     *
     * @param source
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(RNAnyName source);

    /**
     * Creates a <code>RNNameChoice</code> by the RNNameChoice <code>source</code>.
     *
     * @param source
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(RNNameChoice source);

    /**
     * Creates a <code>RNDefine</code> by the RNDefine <code>source</code>.
     *
     * @param source
     * @return RNDefine
     */
    RNDefine createRNDefine(RNDefine source);

    /**
     * Creates a <code>RNElement</code> by the RNElement <code>source</code>.
     *
     * @param source
     * @return RNElement
     */
    RNElement createRNElement(RNElement source);

    /**
     * Creates a <code>RNData</code> by the RNData <code>source</code>.
     *
     * @param source
     * @return RNData
     */
    RNData createRNData(RNData source);

    /**
     * Creates a <code>RNParam</code> by the RNParam <code>source</code>.
     *
     * @param source
     * @return RNParam
     */
    RNParam createRNParam(RNParam source);

    /**
     * Creates a <code>RNValue</code> by the RNValue <code>source</code>.
     *
     * @param source
     * @return RNValue
     */
    RNValue createRNValue(RNValue source);

    /**
     * Creates a <code>RNRef</code> by the RNRef <code>source</code>.
     *
     * @param source
     * @return RNRef
     */
    RNRef createRNRef(RNRef source);

    /**
     * Creates a <code>RNTextOneOrMore</code> by the RNTextOneOrMore <code>source</code>.
     *
     * @param source
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(RNTextOneOrMore source);

    /**
     * Creates a <code>RNText</code> by the RNText <code>source</code>.
     *
     * @param source
     * @return RNText
     */
    RNText createRNText(RNText source);

    /**
     * Creates a <code>RNNotAllowed</code> by the RNNotAllowed <code>source</code>.
     *
     * @param source
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(RNNotAllowed source);

    /**
     * Creates a <code>RNEmpty</code> by the RNEmpty <code>source</code>.
     *
     * @param source
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(RNEmpty source);

    /**
     * Creates a <code>RNTextChoice</code> by the RNTextChoice <code>source</code>.
     *
     * @param source
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(RNTextChoice source);

    /**
     * Creates a <code>RNTextOptional</code> by the RNTextOptional <code>source</code>.
     *
     * @param source
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(RNTextOptional source);

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the RNTextZeroOrMore <code>source</code>.
     *
     * @param source
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(RNTextZeroOrMore source);

    /**
     * Creates a <code>RNList</code> by the RNList <code>source</code>.
     *
     * @param source
     * @return RNList
     */
    RNList createRNList(RNList source);

    /**
     * Creates a <code>RNTextGroup</code> by the RNTextGroup <code>source</code>.
     *
     * @param source
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(RNTextGroup source);

    /**
     * Creates a <code>RNTextExcept</code> by the RNTextExcept <code>source</code>.
     *
     * @param source
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(RNTextExcept source);

    /**
     * Creates a <code>RNExternalRef</code> by the RNExternalRef <code>source</code>.
     *
     * @param source
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(RNExternalRef source);

    /**
     * Creates a <code>RNParentRef</code> by the RNParentRef <code>source</code>.
     *
     * @param source
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(RNParentRef source);

    /**
     * Creates a <code>RNGroup</code> by the RNGroup <code>source</code>.
     *
     * @param source
     * @return RNGroup
     */
    RNGroup createRNGroup(RNGroup source);

    /**
     * Creates a <code>RNChoice</code> by the RNChoice <code>source</code>.
     *
     * @param source
     * @return RNChoice
     */
    RNChoice createRNChoice(RNChoice source);

    /**
     * Creates a <code>RNInterleave</code> by the RNInterleave <code>source</code>.
     *
     * @param source
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(RNInterleave source);

    /**
     * Creates a <code>RNOneOrMore</code> by the RNOneOrMore <code>source</code>.
     *
     * @param source
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(RNOneOrMore source);

    /**
     * Creates a <code>RNMixed</code> by the RNMixed <code>source</code>.
     *
     * @param source
     * @return RNMixed
     */
    RNMixed createRNMixed(RNMixed source);

    /**
     * Creates a <code>RNOptional</code> by the RNOptional <code>source</code>.
     *
     * @param source
     * @return RNOptional
     */
    RNOptional createRNOptional(RNOptional source);

    /**
     * Creates a <code>RNZeroOrMore</code> by the RNZeroOrMore <code>source</code>.
     *
     * @param source
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(RNZeroOrMore source);

    /**
     * Creates a <code>RNInclude</code> by the RNInclude <code>source</code>.
     *
     * @param source
     * @return RNInclude
     */
    RNInclude createRNInclude(RNInclude source);

    /**
     * Creates a <code>RNDiv</code> by the RNDiv <code>source</code>.
     *
     * @param source
     * @return RNDiv
     */
    RNDiv createRNDiv(RNDiv source);

    /**
     * Creates a <code>RNGrammar</code> by the RNGrammar <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(RNGrammar source, RContext rContext);

    /**
     * Creates a <code>RNStart</code> by the RNStart <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNStart
     */
    RNStart createRNStart(RNStart source, RContext rContext);

    /**
     * Creates a <code>RNAttribute</code> by the RNAttribute <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(RNAttribute source, RContext rContext);

    /**
     * Creates a <code>RNNsName</code> by the RNNsName <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNNsName
     */
    RNNsName createRNNsName(RNNsName source, RContext rContext);

    /**
     * Creates a <code>RNExcept</code> by the RNExcept <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNExcept
     */
    RNExcept createRNExcept(RNExcept source, RContext rContext);

    /**
     * Creates a <code>RNName</code> by the RNName <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNName
     */
    RNName createRNName(RNName source, RContext rContext);

    /**
     * Creates a <code>RNAnyName</code> by the RNAnyName <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(RNAnyName source, RContext rContext);

    /**
     * Creates a <code>RNNameChoice</code> by the RNNameChoice <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(RNNameChoice source, RContext rContext);

    /**
     * Creates a <code>RNDefine</code> by the RNDefine <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNDefine
     */
    RNDefine createRNDefine(RNDefine source, RContext rContext);

    /**
     * Creates a <code>RNElement</code> by the RNElement <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNElement
     */
    RNElement createRNElement(RNElement source, RContext rContext);

    /**
     * Creates a <code>RNData</code> by the RNData <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNData
     */
    RNData createRNData(RNData source, RContext rContext);

    /**
     * Creates a <code>RNParam</code> by the RNParam <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNParam
     */
    RNParam createRNParam(RNParam source, RContext rContext);

    /**
     * Creates a <code>RNValue</code> by the RNValue <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNValue
     */
    RNValue createRNValue(RNValue source, RContext rContext);

    /**
     * Creates a <code>RNRef</code> by the RNRef <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNRef
     */
    RNRef createRNRef(RNRef source, RContext rContext);

    /**
     * Creates a <code>RNTextOneOrMore</code> by the RNTextOneOrMore <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(RNTextOneOrMore source, RContext rContext);

    /**
     * Creates a <code>RNText</code> by the RNText <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNText
     */
    RNText createRNText(RNText source, RContext rContext);

    /**
     * Creates a <code>RNNotAllowed</code> by the RNNotAllowed <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(RNNotAllowed source, RContext rContext);

    /**
     * Creates a <code>RNEmpty</code> by the RNEmpty <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(RNEmpty source, RContext rContext);

    /**
     * Creates a <code>RNTextChoice</code> by the RNTextChoice <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(RNTextChoice source, RContext rContext);

    /**
     * Creates a <code>RNTextOptional</code> by the RNTextOptional <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(RNTextOptional source, RContext rContext);

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the RNTextZeroOrMore <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(RNTextZeroOrMore source, RContext rContext);

    /**
     * Creates a <code>RNList</code> by the RNList <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNList
     */
    RNList createRNList(RNList source, RContext rContext);

    /**
     * Creates a <code>RNTextGroup</code> by the RNTextGroup <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(RNTextGroup source, RContext rContext);

    /**
     * Creates a <code>RNTextExcept</code> by the RNTextExcept <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(RNTextExcept source, RContext rContext);

    /**
     * Creates a <code>RNExternalRef</code> by the RNExternalRef <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(RNExternalRef source, RContext rContext);

    /**
     * Creates a <code>RNParentRef</code> by the RNParentRef <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(RNParentRef source, RContext rContext);

    /**
     * Creates a <code>RNGroup</code> by the RNGroup <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNGroup
     */
    RNGroup createRNGroup(RNGroup source, RContext rContext);

    /**
     * Creates a <code>RNChoice</code> by the RNChoice <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNChoice
     */
    RNChoice createRNChoice(RNChoice source, RContext rContext);

    /**
     * Creates a <code>RNInterleave</code> by the RNInterleave <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(RNInterleave source, RContext rContext);

    /**
     * Creates a <code>RNOneOrMore</code> by the RNOneOrMore <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(RNOneOrMore source, RContext rContext);

    /**
     * Creates a <code>RNMixed</code> by the RNMixed <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNMixed
     */
    RNMixed createRNMixed(RNMixed source, RContext rContext);

    /**
     * Creates a <code>RNOptional</code> by the RNOptional <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNOptional
     */
    RNOptional createRNOptional(RNOptional source, RContext rContext);

    /**
     * Creates a <code>RNZeroOrMore</code> by the RNZeroOrMore <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(RNZeroOrMore source, RContext rContext);

    /**
     * Creates a <code>RNInclude</code> by the RNInclude <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNInclude
     */
    RNInclude createRNInclude(RNInclude source, RContext rContext);

    /**
     * Creates a <code>RNDiv</code> by the RNDiv <code>source</code>.
     *
     * @param source
     * @param rContext
     * @return RNDiv
     */
    RNDiv createRNDiv(RNDiv source, RContext rContext);

    /**
     * Creates a <code>RNGrammar</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(Document doc);

    /**
     * Creates a <code>RNStart</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNStart
     */
    RNStart createRNStart(Document doc);

    /**
     * Creates a <code>RNAttribute</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(Document doc);

    /**
     * Creates a <code>RNNsName</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNNsName
     */
    RNNsName createRNNsName(Document doc);

    /**
     * Creates a <code>RNExcept</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNExcept
     */
    RNExcept createRNExcept(Document doc);

    /**
     * Creates a <code>RNName</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNName
     */
    RNName createRNName(Document doc);

    /**
     * Creates a <code>RNAnyName</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(Document doc);

    /**
     * Creates a <code>RNNameChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(Document doc);

    /**
     * Creates a <code>RNDefine</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNDefine
     */
    RNDefine createRNDefine(Document doc);

    /**
     * Creates a <code>RNElement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNElement
     */
    RNElement createRNElement(Document doc);

    /**
     * Creates a <code>RNData</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNData
     */
    RNData createRNData(Document doc);

    /**
     * Creates a <code>RNParam</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNParam
     */
    RNParam createRNParam(Document doc);

    /**
     * Creates a <code>RNValue</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNValue
     */
    RNValue createRNValue(Document doc);

    /**
     * Creates a <code>RNRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNRef
     */
    RNRef createRNRef(Document doc);

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(Document doc);

    /**
     * Creates a <code>RNText</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNText
     */
    RNText createRNText(Document doc);

    /**
     * Creates a <code>RNNotAllowed</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(Document doc);

    /**
     * Creates a <code>RNEmpty</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(Document doc);

    /**
     * Creates a <code>RNTextChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(Document doc);

    /**
     * Creates a <code>RNTextOptional</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(Document doc);

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(Document doc);

    /**
     * Creates a <code>RNList</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNList
     */
    RNList createRNList(Document doc);

    /**
     * Creates a <code>RNTextGroup</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(Document doc);

    /**
     * Creates a <code>RNTextExcept</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(Document doc);

    /**
     * Creates a <code>RNExternalRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(Document doc);

    /**
     * Creates a <code>RNParentRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(Document doc);

    /**
     * Creates a <code>RNGroup</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNGroup
     */
    RNGroup createRNGroup(Document doc);

    /**
     * Creates a <code>RNChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNChoice
     */
    RNChoice createRNChoice(Document doc);

    /**
     * Creates a <code>RNInterleave</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(Document doc);

    /**
     * Creates a <code>RNOneOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(Document doc);

    /**
     * Creates a <code>RNMixed</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNMixed
     */
    RNMixed createRNMixed(Document doc);

    /**
     * Creates a <code>RNOptional</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNOptional
     */
    RNOptional createRNOptional(Document doc);

    /**
     * Creates a <code>RNZeroOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(Document doc);

    /**
     * Creates a <code>RNInclude</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNInclude
     */
    RNInclude createRNInclude(Document doc);

    /**
     * Creates a <code>RNDiv</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RNDiv
     */
    RNDiv createRNDiv(Document doc);

    /**
     * Creates a <code>RNGrammar</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(Document doc, RContext rContext);

    /**
     * Creates a <code>RNStart</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNStart
     */
    RNStart createRNStart(Document doc, RContext rContext);

    /**
     * Creates a <code>RNAttribute</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(Document doc, RContext rContext);

    /**
     * Creates a <code>RNNsName</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNNsName
     */
    RNNsName createRNNsName(Document doc, RContext rContext);

    /**
     * Creates a <code>RNExcept</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNExcept
     */
    RNExcept createRNExcept(Document doc, RContext rContext);

    /**
     * Creates a <code>RNName</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNName
     */
    RNName createRNName(Document doc, RContext rContext);

    /**
     * Creates a <code>RNAnyName</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(Document doc, RContext rContext);

    /**
     * Creates a <code>RNNameChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(Document doc, RContext rContext);

    /**
     * Creates a <code>RNDefine</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNDefine
     */
    RNDefine createRNDefine(Document doc, RContext rContext);

    /**
     * Creates a <code>RNElement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNElement
     */
    RNElement createRNElement(Document doc, RContext rContext);

    /**
     * Creates a <code>RNData</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNData
     */
    RNData createRNData(Document doc, RContext rContext);

    /**
     * Creates a <code>RNParam</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNParam
     */
    RNParam createRNParam(Document doc, RContext rContext);

    /**
     * Creates a <code>RNValue</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNValue
     */
    RNValue createRNValue(Document doc, RContext rContext);

    /**
     * Creates a <code>RNRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNRef
     */
    RNRef createRNRef(Document doc, RContext rContext);

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(Document doc, RContext rContext);

    /**
     * Creates a <code>RNText</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNText
     */
    RNText createRNText(Document doc, RContext rContext);

    /**
     * Creates a <code>RNNotAllowed</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(Document doc, RContext rContext);

    /**
     * Creates a <code>RNEmpty</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(Document doc, RContext rContext);

    /**
     * Creates a <code>RNTextChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(Document doc, RContext rContext);

    /**
     * Creates a <code>RNTextOptional</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(Document doc, RContext rContext);

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(Document doc, RContext rContext);

    /**
     * Creates a <code>RNList</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNList
     */
    RNList createRNList(Document doc, RContext rContext);

    /**
     * Creates a <code>RNTextGroup</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(Document doc, RContext rContext);

    /**
     * Creates a <code>RNTextExcept</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(Document doc, RContext rContext);

    /**
     * Creates a <code>RNExternalRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(Document doc, RContext rContext);

    /**
     * Creates a <code>RNParentRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(Document doc, RContext rContext);

    /**
     * Creates a <code>RNGroup</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNGroup
     */
    RNGroup createRNGroup(Document doc, RContext rContext);

    /**
     * Creates a <code>RNChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNChoice
     */
    RNChoice createRNChoice(Document doc, RContext rContext);

    /**
     * Creates a <code>RNInterleave</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(Document doc, RContext rContext);

    /**
     * Creates a <code>RNOneOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(Document doc, RContext rContext);

    /**
     * Creates a <code>RNMixed</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNMixed
     */
    RNMixed createRNMixed(Document doc, RContext rContext);

    /**
     * Creates a <code>RNOptional</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNOptional
     */
    RNOptional createRNOptional(Document doc, RContext rContext);

    /**
     * Creates a <code>RNZeroOrMore</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(Document doc, RContext rContext);

    /**
     * Creates a <code>RNInclude</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNInclude
     */
    RNInclude createRNInclude(Document doc, RContext rContext);

    /**
     * Creates a <code>RNDiv</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @param rContext
     * @return RNDiv
     */
    RNDiv createRNDiv(Document doc, RContext rContext);

    /**
     * Creates a <code>RNGrammar</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(Element element);

    /**
     * Creates a <code>RNStart</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNStart
     */
    RNStart createRNStart(Element element);

    /**
     * Creates a <code>RNAttribute</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(Element element);

    /**
     * Creates a <code>RNNsName</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNNsName
     */
    RNNsName createRNNsName(Element element);

    /**
     * Creates a <code>RNExcept</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNExcept
     */
    RNExcept createRNExcept(Element element);

    /**
     * Creates a <code>RNName</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNName
     */
    RNName createRNName(Element element);

    /**
     * Creates a <code>RNAnyName</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(Element element);

    /**
     * Creates a <code>RNNameChoice</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(Element element);

    /**
     * Creates a <code>RNDefine</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNDefine
     */
    RNDefine createRNDefine(Element element);

    /**
     * Creates a <code>RNElement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNElement
     */
    RNElement createRNElement(Element element);

    /**
     * Creates a <code>RNData</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNData
     */
    RNData createRNData(Element element);

    /**
     * Creates a <code>RNParam</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNParam
     */
    RNParam createRNParam(Element element);

    /**
     * Creates a <code>RNValue</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNValue
     */
    RNValue createRNValue(Element element);

    /**
     * Creates a <code>RNRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNRef
     */
    RNRef createRNRef(Element element);

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(Element element);

    /**
     * Creates a <code>RNText</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNText
     */
    RNText createRNText(Element element);

    /**
     * Creates a <code>RNNotAllowed</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(Element element);

    /**
     * Creates a <code>RNEmpty</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(Element element);

    /**
     * Creates a <code>RNTextChoice</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(Element element);

    /**
     * Creates a <code>RNTextOptional</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(Element element);

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(Element element);

    /**
     * Creates a <code>RNList</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNList
     */
    RNList createRNList(Element element);

    /**
     * Creates a <code>RNTextGroup</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(Element element);

    /**
     * Creates a <code>RNTextExcept</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(Element element);

    /**
     * Creates a <code>RNExternalRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(Element element);

    /**
     * Creates a <code>RNParentRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(Element element);

    /**
     * Creates a <code>RNGroup</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNGroup
     */
    RNGroup createRNGroup(Element element);

    /**
     * Creates a <code>RNChoice</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNChoice
     */
    RNChoice createRNChoice(Element element);

    /**
     * Creates a <code>RNInterleave</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(Element element);

    /**
     * Creates a <code>RNOneOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(Element element);

    /**
     * Creates a <code>RNMixed</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNMixed
     */
    RNMixed createRNMixed(Element element);

    /**
     * Creates a <code>RNOptional</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNOptional
     */
    RNOptional createRNOptional(Element element);

    /**
     * Creates a <code>RNZeroOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(Element element);

    /**
     * Creates a <code>RNInclude</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNInclude
     */
    RNInclude createRNInclude(Element element);

    /**
     * Creates a <code>RNDiv</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RNDiv
     */
    RNDiv createRNDiv(Element element);

    /**
     * Creates a <code>RNGrammar</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(Element element, RContext rContext);

    /**
     * Creates a <code>RNStart</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNStart
     */
    RNStart createRNStart(Element element, RContext rContext);

    /**
     * Creates a <code>RNAttribute</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(Element element, RContext rContext);

    /**
     * Creates a <code>RNNsName</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNNsName
     */
    RNNsName createRNNsName(Element element, RContext rContext);

    /**
     * Creates a <code>RNExcept</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNExcept
     */
    RNExcept createRNExcept(Element element, RContext rContext);

    /**
     * Creates a <code>RNName</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNName
     */
    RNName createRNName(Element element, RContext rContext);

    /**
     * Creates a <code>RNAnyName</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(Element element, RContext rContext);

    /**
     * Creates a <code>RNNameChoice</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(Element element, RContext rContext);

    /**
     * Creates a <code>RNDefine</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNDefine
     */
    RNDefine createRNDefine(Element element, RContext rContext);

    /**
     * Creates a <code>RNElement</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNElement
     */
    RNElement createRNElement(Element element, RContext rContext);

    /**
     * Creates a <code>RNData</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNData
     */
    RNData createRNData(Element element, RContext rContext);

    /**
     * Creates a <code>RNParam</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNParam
     */
    RNParam createRNParam(Element element, RContext rContext);

    /**
     * Creates a <code>RNValue</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNValue
     */
    RNValue createRNValue(Element element, RContext rContext);

    /**
     * Creates a <code>RNRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNRef
     */
    RNRef createRNRef(Element element, RContext rContext);

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(Element element, RContext rContext);

    /**
     * Creates a <code>RNText</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNText
     */
    RNText createRNText(Element element, RContext rContext);

    /**
     * Creates a <code>RNNotAllowed</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(Element element, RContext rContext);

    /**
     * Creates a <code>RNEmpty</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(Element element, RContext rContext);

    /**
     * Creates a <code>RNTextChoice</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(Element element, RContext rContext);

    /**
     * Creates a <code>RNTextOptional</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(Element element, RContext rContext);

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(Element element, RContext rContext);

    /**
     * Creates a <code>RNList</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNList
     */
    RNList createRNList(Element element, RContext rContext);

    /**
     * Creates a <code>RNTextGroup</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(Element element, RContext rContext);

    /**
     * Creates a <code>RNTextExcept</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(Element element, RContext rContext);

    /**
     * Creates a <code>RNExternalRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(Element element, RContext rContext);

    /**
     * Creates a <code>RNParentRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(Element element, RContext rContext);

    /**
     * Creates a <code>RNGroup</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNGroup
     */
    RNGroup createRNGroup(Element element, RContext rContext);

    /**
     * Creates a <code>RNChoice</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNChoice
     */
    RNChoice createRNChoice(Element element, RContext rContext);

    /**
     * Creates a <code>RNInterleave</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(Element element, RContext rContext);

    /**
     * Creates a <code>RNOneOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(Element element, RContext rContext);

    /**
     * Creates a <code>RNMixed</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNMixed
     */
    RNMixed createRNMixed(Element element, RContext rContext);

    /**
     * Creates a <code>RNOptional</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNOptional
     */
    RNOptional createRNOptional(Element element, RContext rContext);

    /**
     * Creates a <code>RNZeroOrMore</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(Element element, RContext rContext);

    /**
     * Creates a <code>RNInclude</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNInclude
     */
    RNInclude createRNInclude(Element element, RContext rContext);

    /**
     * Creates a <code>RNDiv</code> by the Element <code>element</code>.
     *
     * @param element
     * @param rContext
     * @return RNDiv
     */
    RNDiv createRNDiv(Element element, RContext rContext);

    /**
     * Creates a <code>RNGrammar</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(RStack stack);

    /**
     * Creates a <code>RNStart</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNStart
     */
    RNStart createRNStart(RStack stack);

    /**
     * Creates a <code>RNAttribute</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(RStack stack);

    /**
     * Creates a <code>RNNsName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNNsName
     */
    RNNsName createRNNsName(RStack stack);

    /**
     * Creates a <code>RNExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNExcept
     */
    RNExcept createRNExcept(RStack stack);

    /**
     * Creates a <code>RNName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNName
     */
    RNName createRNName(RStack stack);

    /**
     * Creates a <code>RNAnyName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(RStack stack);

    /**
     * Creates a <code>RNNameChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(RStack stack);

    /**
     * Creates a <code>RNDefine</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNDefine
     */
    RNDefine createRNDefine(RStack stack);

    /**
     * Creates a <code>RNElement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNElement
     */
    RNElement createRNElement(RStack stack);

    /**
     * Creates a <code>RNData</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNData
     */
    RNData createRNData(RStack stack);

    /**
     * Creates a <code>RNParam</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNParam
     */
    RNParam createRNParam(RStack stack);

    /**
     * Creates a <code>RNValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNValue
     */
    RNValue createRNValue(RStack stack);

    /**
     * Creates a <code>RNRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNRef
     */
    RNRef createRNRef(RStack stack);

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(RStack stack);

    /**
     * Creates a <code>RNText</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNText
     */
    RNText createRNText(RStack stack);

    /**
     * Creates a <code>RNNotAllowed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(RStack stack);

    /**
     * Creates a <code>RNEmpty</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(RStack stack);

    /**
     * Creates a <code>RNTextChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(RStack stack);

    /**
     * Creates a <code>RNTextOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(RStack stack);

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(RStack stack);

    /**
     * Creates a <code>RNList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNList
     */
    RNList createRNList(RStack stack);

    /**
     * Creates a <code>RNTextGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(RStack stack);

    /**
     * Creates a <code>RNTextExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(RStack stack);

    /**
     * Creates a <code>RNExternalRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(RStack stack);

    /**
     * Creates a <code>RNParentRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(RStack stack);

    /**
     * Creates a <code>RNGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNGroup
     */
    RNGroup createRNGroup(RStack stack);

    /**
     * Creates a <code>RNChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNChoice
     */
    RNChoice createRNChoice(RStack stack);

    /**
     * Creates a <code>RNInterleave</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(RStack stack);

    /**
     * Creates a <code>RNOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(RStack stack);

    /**
     * Creates a <code>RNMixed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNMixed
     */
    RNMixed createRNMixed(RStack stack);

    /**
     * Creates a <code>RNOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNOptional
     */
    RNOptional createRNOptional(RStack stack);

    /**
     * Creates a <code>RNZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(RStack stack);

    /**
     * Creates a <code>RNInclude</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNInclude
     */
    RNInclude createRNInclude(RStack stack);

    /**
     * Creates a <code>RNDiv</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RNDiv
     */
    RNDiv createRNDiv(RStack stack);

    /**
     * Creates a <code>RNGrammar</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNGrammar
     */
    RNGrammar createRNGrammar(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNStart</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNStart
     */
    RNStart createRNStart(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNAttribute</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNAttribute
     */
    RNAttribute createRNAttribute(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNNsName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNNsName
     */
    RNNsName createRNNsName(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNExcept
     */
    RNExcept createRNExcept(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNName
     */
    RNName createRNName(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNAnyName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNAnyName
     */
    RNAnyName createRNAnyName(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNNameChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNNameChoice
     */
    RNNameChoice createRNNameChoice(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNDefine</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNDefine
     */
    RNDefine createRNDefine(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNElement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNElement
     */
    RNElement createRNElement(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNData</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNData
     */
    RNData createRNData(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNParam</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNParam
     */
    RNParam createRNParam(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNValue
     */
    RNValue createRNValue(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNRef
     */
    RNRef createRNRef(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNTextOneOrMore
     */
    RNTextOneOrMore createRNTextOneOrMore(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNText</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNText
     */
    RNText createRNText(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNNotAllowed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNNotAllowed
     */
    RNNotAllowed createRNNotAllowed(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNEmpty</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNEmpty
     */
    RNEmpty createRNEmpty(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNTextChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNTextChoice
     */
    RNTextChoice createRNTextChoice(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNTextOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNTextOptional
     */
    RNTextOptional createRNTextOptional(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNTextZeroOrMore
     */
    RNTextZeroOrMore createRNTextZeroOrMore(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNList
     */
    RNList createRNList(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNTextGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNTextGroup
     */
    RNTextGroup createRNTextGroup(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNTextExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNTextExcept
     */
    RNTextExcept createRNTextExcept(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNExternalRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNExternalRef
     */
    RNExternalRef createRNExternalRef(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNParentRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNParentRef
     */
    RNParentRef createRNParentRef(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNGroup
     */
    RNGroup createRNGroup(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNChoice
     */
    RNChoice createRNChoice(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNInterleave</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNInterleave
     */
    RNInterleave createRNInterleave(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNOneOrMore
     */
    RNOneOrMore createRNOneOrMore(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNMixed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNMixed
     */
    RNMixed createRNMixed(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNOptional
     */
    RNOptional createRNOptional(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNZeroOrMore
     */
    RNZeroOrMore createRNZeroOrMore(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNInclude</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNInclude
     */
    RNInclude createRNInclude(RStack stack, RContext rContext);

    /**
     * Creates a <code>RNDiv</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @param rContext
     * @return RNDiv
     */
    RNDiv createRNDiv(RStack stack, RContext rContext);

    /**
     * Creates a <code>RContext</code>.
     *
     * @return RContext
     */
    RContext createRContext();
}
