package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

/**
 * @version relaxNg.rxm 1.0 (Fri Oct 31 17:09:04 JST 2003)
 * @author  Relaxer 1.0b (http://www.relaxer.org)
 */
public interface IRNode {
    /**
     * Sets parent RNode.
     *
     * @param parent
     */
    void rSetParentRNode(IRNode parent);

    /**
     * Gets parent RNode.
     *
     * @return IRNode
     */
    IRNode rGetParentRNode();

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    IRNode[] rGetRNodes();

    /**
     * Gets the RContext property <b>rContext</b>.
     *
     * @return RContext
     */
    RContext rGetRContext();

    /**
     * Sets the RContext property <b>rContext</b>.
     *
     * @param rContext
     */
    void rSetRContext(RContext rContext);

    /**
     * Gets the property "xml:base" which is resolved recursively.
     *
     * @return String
     */
    String rGetXmlBaseResolved();

    /**
     * Gets the property "rContext" which is resolved recursively.
     *
     * @return RContext
     */
    RContext rGetRContextResolved();
}
