package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * <b>IRNGrammarContentChoice</b> is generated from relaxNg.rxm by Relaxer.
 * Concrete classes of the interface are RNStart, RNDefine, RNInclude and RNDiv.
 *
 * @version relaxNg.rxm (Fri Oct 31 17:09:05 JST 2003)
 * @author  Relaxer 1.0b (http://www.relaxer.org)
 */
public interface IRNGrammarContentChoice extends IRVisitable, IRNode {
    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    void makeElement(Node parent);

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    void makeTextElement(StringBuffer buffer);

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    void makeTextElement(Writer buffer) throws IOException;

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    void makeTextElement(PrintWriter buffer);

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    void makeTextAttribute(StringBuffer buffer);

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    void makeTextAttribute(Writer buffer) throws IOException;

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    void makeTextAttribute(PrintWriter buffer);

    /**
     * Gets a value of the attribute.
     *
     * @param qName
     * @return String
     */
    String rGetAttribute(String qName);

    /**
     * Sets a value of the attribute.
     *
     * @param qName
     * @param value
     */
    void rSetAttribute(String qName, String value);

    /**
     * Gets attribute keys.
     *
     * @return String[]
     */
    String[] rGetAttributeKeys();

    /**
     * @param doc
     */
    void setup(Document doc);

    /**
     * @param element
     */
    void setup(Element element);

    /**
     * @param stack
     */
    void setup(RStack stack);

    /**
     * @return Object
     */
    Object clone();

    /**
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    void setup(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    void setup(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    void setup(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * @exception ParserConfigurationException
     * @return Document
     */
    Document makeDocument() throws ParserConfigurationException;

    /**
     * @return RNSContext
     */
    RNSContext rGetRNSContext();

    /**
     * @param rNSContext
     */
    void rSetRNSContext(RNSContext rNSContext);

    /**
     * @return String
     */
    String getDatatypeLibrary();

    /**
     * @param datatypeLibrary
     */
    void setDatatypeLibrary(String datatypeLibrary);

    /**
     * @return String
     */
    String getXmlBase();

    /**
     * @param xmlBase
     */
    void setXmlBase(String xmlBase);

    /**
     * @return Element
     */
    Element rGetElement();

    /**
     * @return String
     */
    String makeTextDocument();

    /**
     * @return String
     */
    String getDatatypeLibraryAsString();

    /**
     * @return String
     */
    String getXmlBaseAsString();

    /**
     * @param string
     */
    void setDatatypeLibraryByString(String string);

    /**
     * @param string
     */
    void setXmlBaseByString(String string);

    /**
     * @return String
     */
    String toString();
}
