package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * AbstractRelaxNgFactory is generated by Relaxer based on relaxNg.rxm.
 *
 * @version relaxNg.rxm 1.0 (Fri Oct 31 17:09:07 JST 2003)
 * @author  Relaxer 1.0b (http://www.relaxer.org)
 */
public abstract class AbstractRelaxNgFactory implements IRelaxNgFactory {
    protected org.xml.sax.ErrorHandler errorHandler;
    protected org.xml.sax.EntityResolver entityResolver;
    protected String baseUri;

    /**
     * Sets a <b>errorHandler</b>.
     *
     * @param errorHandler
     */
    public void setErrorHandler(org.xml.sax.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /**
     * Gets a <b>errorHandler</b>.
     *
     * @return org.xml.sax.ErrorHandler
     */
    public org.xml.sax.ErrorHandler getErrorHandler() {
        return (errorHandler);
    }

    /**
     * Sets a <b>entityResolver</b>.
     *
     * @param entityResolver
     */
    public void setEntityResolver(org.xml.sax.EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    /**
     * Gets a <b>entityResolver</b>.
     *
     * @return org.xml.sax.EntityResolver
     */
    public org.xml.sax.EntityResolver getEntityResolver() {
        return (entityResolver);
    }

    /**
     * Sets a <b>baseUri</b>.
     *
     * @param baseUri
     */
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    /**
     * Gets a <b>baseUri</b>.
     *
     * @return String
     */
    public String getBaseUri() {
        return (baseUri);
    }

    /**
     * Creates a <code>IRNode</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (create(file, rContext));
    }

    /**
     * Creates a <code>IRNode</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        IRNode node = create(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver), rContext);
        return (node);
    }

    /**
     * Creates a <code>IRNode</code> by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (create(uri, rContext));
    }

    /**
     * Creates a <code>IRNode</code> by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        IRNode node = create(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver), rContext);
        return (node);
    }

    /**
     * Creates a <code>IRNode</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (create(url, rContext));
    }

    /**
     * Creates a <code>IRNode</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        IRNode node = create(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver), rContext);
        return (node);
    }

    /**
     * Creates a <code>IRNode</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (create(in, rContext));
    }

    /**
     * Creates a <code>IRNode</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        IRNode node = create(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver), rContext);
        return (node);
    }

    /**
     * Creates a <code>IRNode</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (create(is, rContext));
    }

    /**
     * Creates a <code>IRNode</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        IRNode node = create(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver), rContext);
        return (node);
    }

    /**
     * Creates a <code>IRNode</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (create(reader, rContext));
    }

    /**
     * Creates a <code>IRNode</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        IRNode node = create(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver), rContext);
        return (node);
    }

    /**
     * Creates a <code>IRNode</code> by the copy <code>IRNode</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return IRNode
     */
    public IRNode create(IRNode source) {
        RContext rContext = createRContext();
        return (create(source, rContext));
    }

    /**
     * Creates a <code>IRNode</code> by the copy <code>IRNode</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return IRNode
     */
    public IRNode create(IRNode source, RContext rContext) {
        if (source instanceof RNGrammar) {
            RNGrammar node = createRNGrammar();
            node.rSetRContext(rContext);
            node.setup((RNGrammar)source);
            return(node);
        } else if (source instanceof RNStart) {
            RNStart node = createRNStart();
            node.rSetRContext(rContext);
            node.setup((RNStart)source);
            return(node);
        } else if (source instanceof RNAttribute) {
            RNAttribute node = createRNAttribute();
            node.rSetRContext(rContext);
            node.setup((RNAttribute)source);
            return(node);
        } else if (source instanceof RNNsName) {
            RNNsName node = createRNNsName();
            node.rSetRContext(rContext);
            node.setup((RNNsName)source);
            return(node);
        } else if (source instanceof RNExcept) {
            RNExcept node = createRNExcept();
            node.rSetRContext(rContext);
            node.setup((RNExcept)source);
            return(node);
        } else if (source instanceof RNName) {
            RNName node = createRNName();
            node.rSetRContext(rContext);
            node.setup((RNName)source);
            return(node);
        } else if (source instanceof RNAnyName) {
            RNAnyName node = createRNAnyName();
            node.rSetRContext(rContext);
            node.setup((RNAnyName)source);
            return(node);
        } else if (source instanceof RNNameChoice) {
            RNNameChoice node = createRNNameChoice();
            node.rSetRContext(rContext);
            node.setup((RNNameChoice)source);
            return(node);
        } else if (source instanceof RNDefine) {
            RNDefine node = createRNDefine();
            node.rSetRContext(rContext);
            node.setup((RNDefine)source);
            return(node);
        } else if (source instanceof RNElement) {
            RNElement node = createRNElement();
            node.rSetRContext(rContext);
            node.setup((RNElement)source);
            return(node);
        } else if (source instanceof RNData) {
            RNData node = createRNData();
            node.rSetRContext(rContext);
            node.setup((RNData)source);
            return(node);
        } else if (source instanceof RNParam) {
            RNParam node = createRNParam();
            node.rSetRContext(rContext);
            node.setup((RNParam)source);
            return(node);
        } else if (source instanceof RNValue) {
            RNValue node = createRNValue();
            node.rSetRContext(rContext);
            node.setup((RNValue)source);
            return(node);
        } else if (source instanceof RNRef) {
            RNRef node = createRNRef();
            node.rSetRContext(rContext);
            node.setup((RNRef)source);
            return(node);
        } else if (source instanceof RNTextOneOrMore) {
            RNTextOneOrMore node = createRNTextOneOrMore();
            node.rSetRContext(rContext);
            node.setup((RNTextOneOrMore)source);
            return(node);
        } else if (source instanceof RNText) {
            RNText node = createRNText();
            node.rSetRContext(rContext);
            node.setup((RNText)source);
            return(node);
        } else if (source instanceof RNNotAllowed) {
            RNNotAllowed node = createRNNotAllowed();
            node.rSetRContext(rContext);
            node.setup((RNNotAllowed)source);
            return(node);
        } else if (source instanceof RNEmpty) {
            RNEmpty node = createRNEmpty();
            node.rSetRContext(rContext);
            node.setup((RNEmpty)source);
            return(node);
        } else if (source instanceof RNTextChoice) {
            RNTextChoice node = createRNTextChoice();
            node.rSetRContext(rContext);
            node.setup((RNTextChoice)source);
            return(node);
        } else if (source instanceof RNTextOptional) {
            RNTextOptional node = createRNTextOptional();
            node.rSetRContext(rContext);
            node.setup((RNTextOptional)source);
            return(node);
        } else if (source instanceof RNTextZeroOrMore) {
            RNTextZeroOrMore node = createRNTextZeroOrMore();
            node.rSetRContext(rContext);
            node.setup((RNTextZeroOrMore)source);
            return(node);
        } else if (source instanceof RNList) {
            RNList node = createRNList();
            node.rSetRContext(rContext);
            node.setup((RNList)source);
            return(node);
        } else if (source instanceof RNTextGroup) {
            RNTextGroup node = createRNTextGroup();
            node.rSetRContext(rContext);
            node.setup((RNTextGroup)source);
            return(node);
        } else if (source instanceof RNTextExcept) {
            RNTextExcept node = createRNTextExcept();
            node.rSetRContext(rContext);
            node.setup((RNTextExcept)source);
            return(node);
        } else if (source instanceof RNExternalRef) {
            RNExternalRef node = createRNExternalRef();
            node.rSetRContext(rContext);
            node.setup((RNExternalRef)source);
            return(node);
        } else if (source instanceof RNParentRef) {
            RNParentRef node = createRNParentRef();
            node.rSetRContext(rContext);
            node.setup((RNParentRef)source);
            return(node);
        } else if (source instanceof RNGroup) {
            RNGroup node = createRNGroup();
            node.rSetRContext(rContext);
            node.setup((RNGroup)source);
            return(node);
        } else if (source instanceof RNChoice) {
            RNChoice node = createRNChoice();
            node.rSetRContext(rContext);
            node.setup((RNChoice)source);
            return(node);
        } else if (source instanceof RNInterleave) {
            RNInterleave node = createRNInterleave();
            node.rSetRContext(rContext);
            node.setup((RNInterleave)source);
            return(node);
        } else if (source instanceof RNOneOrMore) {
            RNOneOrMore node = createRNOneOrMore();
            node.rSetRContext(rContext);
            node.setup((RNOneOrMore)source);
            return(node);
        } else if (source instanceof RNMixed) {
            RNMixed node = createRNMixed();
            node.rSetRContext(rContext);
            node.setup((RNMixed)source);
            return(node);
        } else if (source instanceof RNOptional) {
            RNOptional node = createRNOptional();
            node.rSetRContext(rContext);
            node.setup((RNOptional)source);
            return(node);
        } else if (source instanceof RNZeroOrMore) {
            RNZeroOrMore node = createRNZeroOrMore();
            node.rSetRContext(rContext);
            node.setup((RNZeroOrMore)source);
            return(node);
        } else if (source instanceof RNInclude) {
            RNInclude node = createRNInclude();
            node.rSetRContext(rContext);
            node.setup((RNInclude)source);
            return(node);
        } else if (source instanceof RNDiv) {
            RNDiv node = createRNDiv();
            node.rSetRContext(rContext);
            node.setup((RNDiv)source);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>IRNode</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(Document doc) throws IOException, SAXException, ParserConfigurationException {
        IRNode node = create(doc.getDocumentElement());
        return (node);
    }

    /**
     * Creates a <code>IRNode</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(Document doc, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        IRNode node = create(doc.getDocumentElement(), rContext);
        return (node);
    }

    /**
     * Creates a <code>IRNode</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(Element element) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (create(element, rContext));
    }

    /**
     * Creates a <code>IRNode</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return IRNode
     */
    public IRNode create(Element element, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        if (RNGrammar.isMatch(element)) {
            RNGrammar node = createRNGrammar();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNStart.isMatch(element)) {
            RNStart node = createRNStart();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNAttribute.isMatch(element)) {
            RNAttribute node = createRNAttribute();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNNsName.isMatch(element)) {
            RNNsName node = createRNNsName();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNExcept.isMatch(element)) {
            RNExcept node = createRNExcept();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNName.isMatch(element)) {
            RNName node = createRNName();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNAnyName.isMatch(element)) {
            RNAnyName node = createRNAnyName();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNNameChoice.isMatch(element)) {
            RNNameChoice node = createRNNameChoice();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNDefine.isMatch(element)) {
            RNDefine node = createRNDefine();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNElement.isMatch(element)) {
            RNElement node = createRNElement();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNData.isMatch(element)) {
            RNData node = createRNData();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNParam.isMatch(element)) {
            RNParam node = createRNParam();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNValue.isMatch(element)) {
            RNValue node = createRNValue();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNRef.isMatch(element)) {
            RNRef node = createRNRef();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNTextOneOrMore.isMatch(element)) {
            RNTextOneOrMore node = createRNTextOneOrMore();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNText.isMatch(element)) {
            RNText node = createRNText();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNNotAllowed.isMatch(element)) {
            RNNotAllowed node = createRNNotAllowed();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNEmpty.isMatch(element)) {
            RNEmpty node = createRNEmpty();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNTextChoice.isMatch(element)) {
            RNTextChoice node = createRNTextChoice();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNTextOptional.isMatch(element)) {
            RNTextOptional node = createRNTextOptional();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNTextZeroOrMore.isMatch(element)) {
            RNTextZeroOrMore node = createRNTextZeroOrMore();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNList.isMatch(element)) {
            RNList node = createRNList();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNTextGroup.isMatch(element)) {
            RNTextGroup node = createRNTextGroup();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNTextExcept.isMatch(element)) {
            RNTextExcept node = createRNTextExcept();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNExternalRef.isMatch(element)) {
            RNExternalRef node = createRNExternalRef();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNParentRef.isMatch(element)) {
            RNParentRef node = createRNParentRef();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNGroup.isMatch(element)) {
            RNGroup node = createRNGroup();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNChoice.isMatch(element)) {
            RNChoice node = createRNChoice();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNInterleave.isMatch(element)) {
            RNInterleave node = createRNInterleave();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNOneOrMore.isMatch(element)) {
            RNOneOrMore node = createRNOneOrMore();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNMixed.isMatch(element)) {
            RNMixed node = createRNMixed();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNOptional.isMatch(element)) {
            RNOptional node = createRNOptional();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNZeroOrMore.isMatch(element)) {
            RNZeroOrMore node = createRNZeroOrMore();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNInclude.isMatch(element)) {
            RNInclude node = createRNInclude();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else if (RNDiv.isMatch(element)) {
            RNDiv node = createRNDiv();
            node.rSetRContext(rContext);
            node.setup(element);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>RNGrammar</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGrammar(file, rContext));
    }

    /**
     * Creates a <code>RNStart</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNStart(file, rContext));
    }

    /**
     * Creates a <code>RNAttribute</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAttribute(file, rContext));
    }

    /**
     * Creates a <code>RNNsName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNsName(file, rContext));
    }

    /**
     * Creates a <code>RNExcept</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExcept(file, rContext));
    }

    /**
     * Creates a <code>RNName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNName(file, rContext));
    }

    /**
     * Creates a <code>RNAnyName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAnyName(file, rContext));
    }

    /**
     * Creates a <code>RNNameChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNameChoice(file, rContext));
    }

    /**
     * Creates a <code>RNDefine</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDefine(file, rContext));
    }

    /**
     * Creates a <code>RNElement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNElement(file, rContext));
    }

    /**
     * Creates a <code>RNData</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNData(file, rContext));
    }

    /**
     * Creates a <code>RNParam</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParam(file, rContext));
    }

    /**
     * Creates a <code>RNValue</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNValue(file, rContext));
    }

    /**
     * Creates a <code>RNRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNRef(file, rContext));
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOneOrMore(file, rContext));
    }

    /**
     * Creates a <code>RNText</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNText(file, rContext));
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNotAllowed(file, rContext));
    }

    /**
     * Creates a <code>RNEmpty</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNEmpty(file, rContext));
    }

    /**
     * Creates a <code>RNTextChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextChoice(file, rContext));
    }

    /**
     * Creates a <code>RNTextOptional</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOptional(file, rContext));
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextZeroOrMore(file, rContext));
    }

    /**
     * Creates a <code>RNList</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNList(file, rContext));
    }

    /**
     * Creates a <code>RNTextGroup</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextGroup(file, rContext));
    }

    /**
     * Creates a <code>RNTextExcept</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextExcept(file, rContext));
    }

    /**
     * Creates a <code>RNExternalRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExternalRef(file, rContext));
    }

    /**
     * Creates a <code>RNParentRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParentRef(file, rContext));
    }

    /**
     * Creates a <code>RNGroup</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGroup(file, rContext));
    }

    /**
     * Creates a <code>RNChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNChoice(file, rContext));
    }

    /**
     * Creates a <code>RNInterleave</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInterleave(file, rContext));
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOneOrMore(file, rContext));
    }

    /**
     * Creates a <code>RNMixed</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNMixed(file, rContext));
    }

    /**
     * Creates a <code>RNOptional</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOptional(file, rContext));
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNZeroOrMore(file, rContext));
    }

    /**
     * Creates a <code>RNInclude</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInclude(file, rContext));
    }

    /**
     * Creates a <code>RNDiv</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(File file) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDiv(file, rContext));
    }

    /**
     * Creates a <code>RNGrammar</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNGrammar rNGrammar_ = createRNGrammar(rContext);
        rNGrammar_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNStart rNStart_ = createRNStart(rContext);
        rNStart_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNAttribute rNAttribute_ = createRNAttribute(rContext);
        rNAttribute_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNNsName rNNsName_ = createRNNsName(rContext);
        rNNsName_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNExcept rNExcept_ = createRNExcept(rContext);
        rNExcept_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNName rNName_ = createRNName(rContext);
        rNName_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNAnyName rNAnyName_ = createRNAnyName(rContext);
        rNAnyName_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNNameChoice rNNameChoice_ = createRNNameChoice(rContext);
        rNNameChoice_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNDefine rNDefine_ = createRNDefine(rContext);
        rNDefine_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNElement rNElement_ = createRNElement(rContext);
        rNElement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNData rNData_ = createRNData(rContext);
        rNData_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNParam rNParam_ = createRNParam(rContext);
        rNParam_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNValue rNValue_ = createRNValue(rContext);
        rNValue_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNRef rNRef_ = createRNRef(rContext);
        rNRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore(rContext);
        rNTextOneOrMore_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNText rNText_ = createRNText(rContext);
        rNText_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed(rContext);
        rNNotAllowed_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNEmpty rNEmpty_ = createRNEmpty(rContext);
        rNEmpty_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNTextChoice rNTextChoice_ = createRNTextChoice(rContext);
        rNTextChoice_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNTextOptional rNTextOptional_ = createRNTextOptional(rContext);
        rNTextOptional_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore(rContext);
        rNTextZeroOrMore_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNList rNList_ = createRNList(rContext);
        rNList_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNTextGroup rNTextGroup_ = createRNTextGroup(rContext);
        rNTextGroup_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNTextExcept rNTextExcept_ = createRNTextExcept(rContext);
        rNTextExcept_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNExternalRef rNExternalRef_ = createRNExternalRef(rContext);
        rNExternalRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNParentRef rNParentRef_ = createRNParentRef(rContext);
        rNParentRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNGroup rNGroup_ = createRNGroup(rContext);
        rNGroup_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNChoice rNChoice_ = createRNChoice(rContext);
        rNChoice_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNInterleave rNInterleave_ = createRNInterleave(rContext);
        rNInterleave_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore(rContext);
        rNOneOrMore_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNMixed rNMixed_ = createRNMixed(rContext);
        rNMixed_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNOptional rNOptional_ = createRNOptional(rContext);
        rNOptional_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore(rContext);
        rNZeroOrMore_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNInclude rNInclude_ = createRNInclude(rContext);
        rNInclude_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(File file, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(file.toURL());
        RNDiv rNDiv_ = createRNDiv(rContext);
        rNDiv_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGrammar(uri, rContext));
    }

    /**
     * Creates a <code>RNStart</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNStart(uri, rContext));
    }

    /**
     * Creates a <code>RNAttribute</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAttribute(uri, rContext));
    }

    /**
     * Creates a <code>RNNsName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNsName(uri, rContext));
    }

    /**
     * Creates a <code>RNExcept</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExcept(uri, rContext));
    }

    /**
     * Creates a <code>RNName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNName(uri, rContext));
    }

    /**
     * Creates a <code>RNAnyName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAnyName(uri, rContext));
    }

    /**
     * Creates a <code>RNNameChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNameChoice(uri, rContext));
    }

    /**
     * Creates a <code>RNDefine</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDefine(uri, rContext));
    }

    /**
     * Creates a <code>RNElement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNElement(uri, rContext));
    }

    /**
     * Creates a <code>RNData</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNData(uri, rContext));
    }

    /**
     * Creates a <code>RNParam</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParam(uri, rContext));
    }

    /**
     * Creates a <code>RNValue</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNValue(uri, rContext));
    }

    /**
     * Creates a <code>RNRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNRef(uri, rContext));
    }

    /**
     * Creates a <code>RNTextOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOneOrMore(uri, rContext));
    }

    /**
     * Creates a <code>RNText</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNText(uri, rContext));
    }

    /**
     * Creates a <code>RNNotAllowed</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNotAllowed(uri, rContext));
    }

    /**
     * Creates a <code>RNEmpty</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNEmpty(uri, rContext));
    }

    /**
     * Creates a <code>RNTextChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextChoice(uri, rContext));
    }

    /**
     * Creates a <code>RNTextOptional</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOptional(uri, rContext));
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextZeroOrMore(uri, rContext));
    }

    /**
     * Creates a <code>RNList</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNList(uri, rContext));
    }

    /**
     * Creates a <code>RNTextGroup</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextGroup(uri, rContext));
    }

    /**
     * Creates a <code>RNTextExcept</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextExcept(uri, rContext));
    }

    /**
     * Creates a <code>RNExternalRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExternalRef(uri, rContext));
    }

    /**
     * Creates a <code>RNParentRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParentRef(uri, rContext));
    }

    /**
     * Creates a <code>RNGroup</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGroup(uri, rContext));
    }

    /**
     * Creates a <code>RNChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNChoice(uri, rContext));
    }

    /**
     * Creates a <code>RNInterleave</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInterleave(uri, rContext));
    }

    /**
     * Creates a <code>RNOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOneOrMore(uri, rContext));
    }

    /**
     * Creates a <code>RNMixed</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNMixed(uri, rContext));
    }

    /**
     * Creates a <code>RNOptional</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOptional(uri, rContext));
    }

    /**
     * Creates a <code>RNZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNZeroOrMore(uri, rContext));
    }

    /**
     * Creates a <code>RNInclude</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInclude(uri, rContext));
    }

    /**
     * Creates a <code>RNDiv</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(String uri) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDiv(uri, rContext));
    }

    /**
     * Creates a <code>RNGrammar</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNGrammar rNGrammar_ = createRNGrammar(rContext);
        rNGrammar_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNStart rNStart_ = createRNStart(rContext);
        rNStart_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNAttribute rNAttribute_ = createRNAttribute(rContext);
        rNAttribute_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNNsName rNNsName_ = createRNNsName(rContext);
        rNNsName_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNExcept rNExcept_ = createRNExcept(rContext);
        rNExcept_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNName rNName_ = createRNName(rContext);
        rNName_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNAnyName rNAnyName_ = createRNAnyName(rContext);
        rNAnyName_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNNameChoice rNNameChoice_ = createRNNameChoice(rContext);
        rNNameChoice_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNDefine rNDefine_ = createRNDefine(rContext);
        rNDefine_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNElement rNElement_ = createRNElement(rContext);
        rNElement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNData rNData_ = createRNData(rContext);
        rNData_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNParam rNParam_ = createRNParam(rContext);
        rNParam_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNValue rNValue_ = createRNValue(rContext);
        rNValue_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNRef rNRef_ = createRNRef(rContext);
        rNRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore(rContext);
        rNTextOneOrMore_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNText rNText_ = createRNText(rContext);
        rNText_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed(rContext);
        rNNotAllowed_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNEmpty rNEmpty_ = createRNEmpty(rContext);
        rNEmpty_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNTextChoice rNTextChoice_ = createRNTextChoice(rContext);
        rNTextChoice_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNTextOptional rNTextOptional_ = createRNTextOptional(rContext);
        rNTextOptional_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore(rContext);
        rNTextZeroOrMore_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNList rNList_ = createRNList(rContext);
        rNList_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNTextGroup rNTextGroup_ = createRNTextGroup(rContext);
        rNTextGroup_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNTextExcept rNTextExcept_ = createRNTextExcept(rContext);
        rNTextExcept_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNExternalRef rNExternalRef_ = createRNExternalRef(rContext);
        rNExternalRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNParentRef rNParentRef_ = createRNParentRef(rContext);
        rNParentRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNGroup rNGroup_ = createRNGroup(rContext);
        rNGroup_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNChoice rNChoice_ = createRNChoice(rContext);
        rNChoice_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNInterleave rNInterleave_ = createRNInterleave(rContext);
        rNInterleave_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore(rContext);
        rNOneOrMore_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNMixed rNMixed_ = createRNMixed(rContext);
        rNMixed_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNOptional rNOptional_ = createRNOptional(rContext);
        rNOptional_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore(rContext);
        rNZeroOrMore_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNInclude rNInclude_ = createRNInclude(rContext);
        rNInclude_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(String uri, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(URelaxer.makeURL(uri));
        RNDiv rNDiv_ = createRNDiv(rContext);
        rNDiv_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGrammar(url, rContext));
    }

    /**
     * Creates a <code>RNStart</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNStart(url, rContext));
    }

    /**
     * Creates a <code>RNAttribute</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAttribute(url, rContext));
    }

    /**
     * Creates a <code>RNNsName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNsName(url, rContext));
    }

    /**
     * Creates a <code>RNExcept</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExcept(url, rContext));
    }

    /**
     * Creates a <code>RNName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNName(url, rContext));
    }

    /**
     * Creates a <code>RNAnyName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAnyName(url, rContext));
    }

    /**
     * Creates a <code>RNNameChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNameChoice(url, rContext));
    }

    /**
     * Creates a <code>RNDefine</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDefine(url, rContext));
    }

    /**
     * Creates a <code>RNElement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNElement(url, rContext));
    }

    /**
     * Creates a <code>RNData</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNData(url, rContext));
    }

    /**
     * Creates a <code>RNParam</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParam(url, rContext));
    }

    /**
     * Creates a <code>RNValue</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNValue(url, rContext));
    }

    /**
     * Creates a <code>RNRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNRef(url, rContext));
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOneOrMore(url, rContext));
    }

    /**
     * Creates a <code>RNText</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNText(url, rContext));
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNotAllowed(url, rContext));
    }

    /**
     * Creates a <code>RNEmpty</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNEmpty(url, rContext));
    }

    /**
     * Creates a <code>RNTextChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextChoice(url, rContext));
    }

    /**
     * Creates a <code>RNTextOptional</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOptional(url, rContext));
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextZeroOrMore(url, rContext));
    }

    /**
     * Creates a <code>RNList</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNList(url, rContext));
    }

    /**
     * Creates a <code>RNTextGroup</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextGroup(url, rContext));
    }

    /**
     * Creates a <code>RNTextExcept</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextExcept(url, rContext));
    }

    /**
     * Creates a <code>RNExternalRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExternalRef(url, rContext));
    }

    /**
     * Creates a <code>RNParentRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParentRef(url, rContext));
    }

    /**
     * Creates a <code>RNGroup</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGroup(url, rContext));
    }

    /**
     * Creates a <code>RNChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNChoice(url, rContext));
    }

    /**
     * Creates a <code>RNInterleave</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInterleave(url, rContext));
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOneOrMore(url, rContext));
    }

    /**
     * Creates a <code>RNMixed</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNMixed(url, rContext));
    }

    /**
     * Creates a <code>RNOptional</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOptional(url, rContext));
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNZeroOrMore(url, rContext));
    }

    /**
     * Creates a <code>RNInclude</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInclude(url, rContext));
    }

    /**
     * Creates a <code>RNDiv</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(URL url) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDiv(url, rContext));
    }

    /**
     * Creates a <code>RNGrammar</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNGrammar rNGrammar_ = createRNGrammar(rContext);
        rNGrammar_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNStart rNStart_ = createRNStart(rContext);
        rNStart_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNAttribute rNAttribute_ = createRNAttribute(rContext);
        rNAttribute_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNNsName rNNsName_ = createRNNsName(rContext);
        rNNsName_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNExcept rNExcept_ = createRNExcept(rContext);
        rNExcept_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNName rNName_ = createRNName(rContext);
        rNName_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNAnyName rNAnyName_ = createRNAnyName(rContext);
        rNAnyName_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNNameChoice rNNameChoice_ = createRNNameChoice(rContext);
        rNNameChoice_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNDefine rNDefine_ = createRNDefine(rContext);
        rNDefine_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNElement rNElement_ = createRNElement(rContext);
        rNElement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNData rNData_ = createRNData(rContext);
        rNData_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNParam rNParam_ = createRNParam(rContext);
        rNParam_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNValue rNValue_ = createRNValue(rContext);
        rNValue_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNRef rNRef_ = createRNRef(rContext);
        rNRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore(rContext);
        rNTextOneOrMore_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNText rNText_ = createRNText(rContext);
        rNText_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed(rContext);
        rNNotAllowed_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNEmpty rNEmpty_ = createRNEmpty(rContext);
        rNEmpty_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNTextChoice rNTextChoice_ = createRNTextChoice(rContext);
        rNTextChoice_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNTextOptional rNTextOptional_ = createRNTextOptional(rContext);
        rNTextOptional_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore(rContext);
        rNTextZeroOrMore_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNList rNList_ = createRNList(rContext);
        rNList_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNTextGroup rNTextGroup_ = createRNTextGroup(rContext);
        rNTextGroup_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNTextExcept rNTextExcept_ = createRNTextExcept(rContext);
        rNTextExcept_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNExternalRef rNExternalRef_ = createRNExternalRef(rContext);
        rNExternalRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNParentRef rNParentRef_ = createRNParentRef(rContext);
        rNParentRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNGroup rNGroup_ = createRNGroup(rContext);
        rNGroup_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNChoice rNChoice_ = createRNChoice(rContext);
        rNChoice_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNInterleave rNInterleave_ = createRNInterleave(rContext);
        rNInterleave_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore(rContext);
        rNOneOrMore_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNMixed rNMixed_ = createRNMixed(rContext);
        rNMixed_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNOptional rNOptional_ = createRNOptional(rContext);
        rNOptional_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore(rContext);
        rNZeroOrMore_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNInclude rNInclude_ = createRNInclude(rContext);
        rNInclude_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(URL url, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        rContext.setBaseURL(url);
        RNDiv rNDiv_ = createRNDiv(rContext);
        rNDiv_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGrammar(in, rContext));
    }

    /**
     * Creates a <code>RNStart</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNStart(in, rContext));
    }

    /**
     * Creates a <code>RNAttribute</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAttribute(in, rContext));
    }

    /**
     * Creates a <code>RNNsName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNsName(in, rContext));
    }

    /**
     * Creates a <code>RNExcept</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExcept(in, rContext));
    }

    /**
     * Creates a <code>RNName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNName(in, rContext));
    }

    /**
     * Creates a <code>RNAnyName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAnyName(in, rContext));
    }

    /**
     * Creates a <code>RNNameChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNameChoice(in, rContext));
    }

    /**
     * Creates a <code>RNDefine</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDefine(in, rContext));
    }

    /**
     * Creates a <code>RNElement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNElement(in, rContext));
    }

    /**
     * Creates a <code>RNData</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNData(in, rContext));
    }

    /**
     * Creates a <code>RNParam</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParam(in, rContext));
    }

    /**
     * Creates a <code>RNValue</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNValue(in, rContext));
    }

    /**
     * Creates a <code>RNRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNRef(in, rContext));
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOneOrMore(in, rContext));
    }

    /**
     * Creates a <code>RNText</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNText(in, rContext));
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNotAllowed(in, rContext));
    }

    /**
     * Creates a <code>RNEmpty</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNEmpty(in, rContext));
    }

    /**
     * Creates a <code>RNTextChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextChoice(in, rContext));
    }

    /**
     * Creates a <code>RNTextOptional</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOptional(in, rContext));
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextZeroOrMore(in, rContext));
    }

    /**
     * Creates a <code>RNList</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNList(in, rContext));
    }

    /**
     * Creates a <code>RNTextGroup</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextGroup(in, rContext));
    }

    /**
     * Creates a <code>RNTextExcept</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextExcept(in, rContext));
    }

    /**
     * Creates a <code>RNExternalRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExternalRef(in, rContext));
    }

    /**
     * Creates a <code>RNParentRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParentRef(in, rContext));
    }

    /**
     * Creates a <code>RNGroup</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGroup(in, rContext));
    }

    /**
     * Creates a <code>RNChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNChoice(in, rContext));
    }

    /**
     * Creates a <code>RNInterleave</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInterleave(in, rContext));
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOneOrMore(in, rContext));
    }

    /**
     * Creates a <code>RNMixed</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNMixed(in, rContext));
    }

    /**
     * Creates a <code>RNOptional</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOptional(in, rContext));
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNZeroOrMore(in, rContext));
    }

    /**
     * Creates a <code>RNInclude</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInclude(in, rContext));
    }

    /**
     * Creates a <code>RNDiv</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDiv(in, rContext));
    }

    /**
     * Creates a <code>RNGrammar</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar(rContext);
        rNGrammar_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart(rContext);
        rNStart_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute(rContext);
        rNAttribute_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName(rContext);
        rNNsName_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept(rContext);
        rNExcept_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName(rContext);
        rNName_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName(rContext);
        rNAnyName_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice(rContext);
        rNNameChoice_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine(rContext);
        rNDefine_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement(rContext);
        rNElement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData(rContext);
        rNData_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam(rContext);
        rNParam_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue(rContext);
        rNValue_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef(rContext);
        rNRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore(rContext);
        rNTextOneOrMore_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText(rContext);
        rNText_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed(rContext);
        rNNotAllowed_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty(rContext);
        rNEmpty_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice(rContext);
        rNTextChoice_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional(rContext);
        rNTextOptional_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore(rContext);
        rNTextZeroOrMore_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList(rContext);
        rNList_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextGroup rNTextGroup_ = createRNTextGroup(rContext);
        rNTextGroup_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextExcept rNTextExcept_ = createRNTextExcept(rContext);
        rNTextExcept_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef(rContext);
        rNExternalRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNParentRef rNParentRef_ = createRNParentRef(rContext);
        rNParentRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup(rContext);
        rNGroup_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice(rContext);
        rNChoice_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave(rContext);
        rNInterleave_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore(rContext);
        rNOneOrMore_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed(rContext);
        rNMixed_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional(rContext);
        rNOptional_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore(rContext);
        rNZeroOrMore_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude(rContext);
        rNInclude_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(InputStream in, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv(rContext);
        rNDiv_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGrammar(is, rContext));
    }

    /**
     * Creates a <code>RNStart</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNStart(is, rContext));
    }

    /**
     * Creates a <code>RNAttribute</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAttribute(is, rContext));
    }

    /**
     * Creates a <code>RNNsName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNsName(is, rContext));
    }

    /**
     * Creates a <code>RNExcept</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExcept(is, rContext));
    }

    /**
     * Creates a <code>RNName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNName(is, rContext));
    }

    /**
     * Creates a <code>RNAnyName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAnyName(is, rContext));
    }

    /**
     * Creates a <code>RNNameChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNameChoice(is, rContext));
    }

    /**
     * Creates a <code>RNDefine</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDefine(is, rContext));
    }

    /**
     * Creates a <code>RNElement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNElement(is, rContext));
    }

    /**
     * Creates a <code>RNData</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNData(is, rContext));
    }

    /**
     * Creates a <code>RNParam</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParam(is, rContext));
    }

    /**
     * Creates a <code>RNValue</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNValue(is, rContext));
    }

    /**
     * Creates a <code>RNRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNRef(is, rContext));
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOneOrMore(is, rContext));
    }

    /**
     * Creates a <code>RNText</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNText(is, rContext));
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNotAllowed(is, rContext));
    }

    /**
     * Creates a <code>RNEmpty</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNEmpty(is, rContext));
    }

    /**
     * Creates a <code>RNTextChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextChoice(is, rContext));
    }

    /**
     * Creates a <code>RNTextOptional</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOptional(is, rContext));
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextZeroOrMore(is, rContext));
    }

    /**
     * Creates a <code>RNList</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNList(is, rContext));
    }

    /**
     * Creates a <code>RNTextGroup</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextGroup(is, rContext));
    }

    /**
     * Creates a <code>RNTextExcept</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextExcept(is, rContext));
    }

    /**
     * Creates a <code>RNExternalRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExternalRef(is, rContext));
    }

    /**
     * Creates a <code>RNParentRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParentRef(is, rContext));
    }

    /**
     * Creates a <code>RNGroup</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGroup(is, rContext));
    }

    /**
     * Creates a <code>RNChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNChoice(is, rContext));
    }

    /**
     * Creates a <code>RNInterleave</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInterleave(is, rContext));
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOneOrMore(is, rContext));
    }

    /**
     * Creates a <code>RNMixed</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNMixed(is, rContext));
    }

    /**
     * Creates a <code>RNOptional</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOptional(is, rContext));
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNZeroOrMore(is, rContext));
    }

    /**
     * Creates a <code>RNInclude</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInclude(is, rContext));
    }

    /**
     * Creates a <code>RNDiv</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDiv(is, rContext));
    }

    /**
     * Creates a <code>RNGrammar</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar(rContext);
        rNGrammar_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart(rContext);
        rNStart_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute(rContext);
        rNAttribute_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName(rContext);
        rNNsName_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept(rContext);
        rNExcept_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName(rContext);
        rNName_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName(rContext);
        rNAnyName_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice(rContext);
        rNNameChoice_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine(rContext);
        rNDefine_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement(rContext);
        rNElement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData(rContext);
        rNData_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam(rContext);
        rNParam_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue(rContext);
        rNValue_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef(rContext);
        rNRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore(rContext);
        rNTextOneOrMore_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText(rContext);
        rNText_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed(rContext);
        rNNotAllowed_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty(rContext);
        rNEmpty_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice(rContext);
        rNTextChoice_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional(rContext);
        rNTextOptional_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore(rContext);
        rNTextZeroOrMore_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList(rContext);
        rNList_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextGroup rNTextGroup_ = createRNTextGroup(rContext);
        rNTextGroup_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextExcept rNTextExcept_ = createRNTextExcept(rContext);
        rNTextExcept_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef(rContext);
        rNExternalRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNParentRef rNParentRef_ = createRNParentRef(rContext);
        rNParentRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup(rContext);
        rNGroup_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice(rContext);
        rNChoice_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave(rContext);
        rNInterleave_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore(rContext);
        rNOneOrMore_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed(rContext);
        rNMixed_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional(rContext);
        rNOptional_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore(rContext);
        rNZeroOrMore_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude(rContext);
        rNInclude_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(InputSource is, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv(rContext);
        rNDiv_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGrammar(reader, rContext));
    }

    /**
     * Creates a <code>RNStart</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNStart(reader, rContext));
    }

    /**
     * Creates a <code>RNAttribute</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAttribute(reader, rContext));
    }

    /**
     * Creates a <code>RNNsName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNsName(reader, rContext));
    }

    /**
     * Creates a <code>RNExcept</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExcept(reader, rContext));
    }

    /**
     * Creates a <code>RNName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNName(reader, rContext));
    }

    /**
     * Creates a <code>RNAnyName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNAnyName(reader, rContext));
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNameChoice(reader, rContext));
    }

    /**
     * Creates a <code>RNDefine</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDefine(reader, rContext));
    }

    /**
     * Creates a <code>RNElement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNElement(reader, rContext));
    }

    /**
     * Creates a <code>RNData</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNData(reader, rContext));
    }

    /**
     * Creates a <code>RNParam</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParam(reader, rContext));
    }

    /**
     * Creates a <code>RNValue</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNValue(reader, rContext));
    }

    /**
     * Creates a <code>RNRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNRef(reader, rContext));
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOneOrMore(reader, rContext));
    }

    /**
     * Creates a <code>RNText</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNText(reader, rContext));
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNNotAllowed(reader, rContext));
    }

    /**
     * Creates a <code>RNEmpty</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNEmpty(reader, rContext));
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextChoice(reader, rContext));
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextOptional(reader, rContext));
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextZeroOrMore(reader, rContext));
    }

    /**
     * Creates a <code>RNList</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNList(reader, rContext));
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextGroup(reader, rContext));
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNTextExcept(reader, rContext));
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNExternalRef(reader, rContext));
    }

    /**
     * Creates a <code>RNParentRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNParentRef(reader, rContext));
    }

    /**
     * Creates a <code>RNGroup</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNGroup(reader, rContext));
    }

    /**
     * Creates a <code>RNChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNChoice(reader, rContext));
    }

    /**
     * Creates a <code>RNInterleave</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInterleave(reader, rContext));
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOneOrMore(reader, rContext));
    }

    /**
     * Creates a <code>RNMixed</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNMixed(reader, rContext));
    }

    /**
     * Creates a <code>RNOptional</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNOptional(reader, rContext));
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNZeroOrMore(reader, rContext));
    }

    /**
     * Creates a <code>RNInclude</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNInclude(reader, rContext));
    }

    /**
     * Creates a <code>RNDiv</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        RContext rContext = createRContext();
        return (createRNDiv(reader, rContext));
    }

    /**
     * Creates a <code>RNGrammar</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNGrammar rNGrammar_ = createRNGrammar(rContext);
        rNGrammar_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNStart
     */
    public RNStart createRNStart(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNStart rNStart_ = createRNStart(rContext);
        rNStart_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNAttribute rNAttribute_ = createRNAttribute(rContext);
        rNAttribute_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNsName
     */
    public RNNsName createRNNsName(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNNsName rNNsName_ = createRNNsName(rContext);
        rNNsName_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExcept
     */
    public RNExcept createRNExcept(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNExcept rNExcept_ = createRNExcept(rContext);
        rNExcept_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNName
     */
    public RNName createRNName(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNName rNName_ = createRNName(rContext);
        rNName_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNAnyName rNAnyName_ = createRNAnyName(rContext);
        rNAnyName_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNNameChoice rNNameChoice_ = createRNNameChoice(rContext);
        rNNameChoice_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDefine
     */
    public RNDefine createRNDefine(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNDefine rNDefine_ = createRNDefine(rContext);
        rNDefine_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNElement
     */
    public RNElement createRNElement(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNElement rNElement_ = createRNElement(rContext);
        rNElement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNData
     */
    public RNData createRNData(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNData rNData_ = createRNData(rContext);
        rNData_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParam
     */
    public RNParam createRNParam(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNParam rNParam_ = createRNParam(rContext);
        rNParam_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNValue
     */
    public RNValue createRNValue(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNValue rNValue_ = createRNValue(rContext);
        rNValue_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNRef
     */
    public RNRef createRNRef(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNRef rNRef_ = createRNRef(rContext);
        rNRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore(rContext);
        rNTextOneOrMore_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNText
     */
    public RNText createRNText(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNText rNText_ = createRNText(rContext);
        rNText_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed(rContext);
        rNNotAllowed_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNEmpty rNEmpty_ = createRNEmpty(rContext);
        rNEmpty_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextChoice rNTextChoice_ = createRNTextChoice(rContext);
        rNTextChoice_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextOptional rNTextOptional_ = createRNTextOptional(rContext);
        rNTextOptional_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore(rContext);
        rNTextZeroOrMore_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNList
     */
    public RNList createRNList(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNList rNList_ = createRNList(rContext);
        rNList_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextGroup rNTextGroup_ = createRNTextGroup(rContext);
        rNTextGroup_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNTextExcept rNTextExcept_ = createRNTextExcept(rContext);
        rNTextExcept_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNExternalRef rNExternalRef_ = createRNExternalRef(rContext);
        rNExternalRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNParentRef rNParentRef_ = createRNParentRef(rContext);
        rNParentRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNGroup
     */
    public RNGroup createRNGroup(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNGroup rNGroup_ = createRNGroup(rContext);
        rNGroup_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNChoice
     */
    public RNChoice createRNChoice(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNChoice rNChoice_ = createRNChoice(rContext);
        rNChoice_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNInterleave rNInterleave_ = createRNInterleave(rContext);
        rNInterleave_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore(rContext);
        rNOneOrMore_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNMixed
     */
    public RNMixed createRNMixed(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNMixed rNMixed_ = createRNMixed(rContext);
        rNMixed_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNOptional
     */
    public RNOptional createRNOptional(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNOptional rNOptional_ = createRNOptional(rContext);
        rNOptional_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore(rContext);
        rNZeroOrMore_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNInclude
     */
    public RNInclude createRNInclude(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNInclude rNInclude_ = createRNInclude(rContext);
        rNInclude_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @param rContext
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return RNDiv
     */
    public RNDiv createRNDiv(Reader reader, RContext rContext) throws IOException, SAXException, ParserConfigurationException {
        RNDiv rNDiv_ = createRNDiv(rContext);
        rNDiv_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE, errorHandler, entityResolver));
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> with Context.
     *
     * @param rContext
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(RContext rContext) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.rSetRContext(rContext);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code> with Context.
     *
     * @param rContext
     * @return RNStart
     */
    public RNStart createRNStart(RContext rContext) {
        RNStart rNStart_ = createRNStart();
        rNStart_.rSetRContext(rContext);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code> with Context.
     *
     * @param rContext
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(RContext rContext) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.rSetRContext(rContext);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> with Context.
     *
     * @param rContext
     * @return RNNsName
     */
    public RNNsName createRNNsName(RContext rContext) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.rSetRContext(rContext);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> with Context.
     *
     * @param rContext
     * @return RNExcept
     */
    public RNExcept createRNExcept(RContext rContext) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.rSetRContext(rContext);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> with Context.
     *
     * @param rContext
     * @return RNName
     */
    public RNName createRNName(RContext rContext) {
        RNName rNName_ = createRNName();
        rNName_.rSetRContext(rContext);
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> with Context.
     *
     * @param rContext
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(RContext rContext) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.rSetRContext(rContext);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> with Context.
     *
     * @param rContext
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(RContext rContext) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.rSetRContext(rContext);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code> with Context.
     *
     * @param rContext
     * @return RNDefine
     */
    public RNDefine createRNDefine(RContext rContext) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.rSetRContext(rContext);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> with Context.
     *
     * @param rContext
     * @return RNElement
     */
    public RNElement createRNElement(RContext rContext) {
        RNElement rNElement_ = createRNElement();
        rNElement_.rSetRContext(rContext);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code> with Context.
     *
     * @param rContext
     * @return RNData
     */
    public RNData createRNData(RContext rContext) {
        RNData rNData_ = createRNData();
        rNData_.rSetRContext(rContext);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> with Context.
     *
     * @param rContext
     * @return RNParam
     */
    public RNParam createRNParam(RContext rContext) {
        RNParam rNParam_ = createRNParam();
        rNParam_.rSetRContext(rContext);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> with Context.
     *
     * @param rContext
     * @return RNValue
     */
    public RNValue createRNValue(RContext rContext) {
        RNValue rNValue_ = createRNValue();
        rNValue_.rSetRContext(rContext);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> with Context.
     *
     * @param rContext
     * @return RNRef
     */
    public RNRef createRNRef(RContext rContext) {
        RNRef rNRef_ = createRNRef();
        rNRef_.rSetRContext(rContext);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> with Context.
     *
     * @param rContext
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(RContext rContext) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.rSetRContext(rContext);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code> with Context.
     *
     * @param rContext
     * @return RNText
     */
    public RNText createRNText(RContext rContext) {
        RNText rNText_ = createRNText();
        rNText_.rSetRContext(rContext);
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> with Context.
     *
     * @param rContext
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(RContext rContext) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.rSetRContext(rContext);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> with Context.
     *
     * @param rContext
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(RContext rContext) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.rSetRContext(rContext);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> with Context.
     *
     * @param rContext
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(RContext rContext) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.rSetRContext(rContext);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> with Context.
     *
     * @param rContext
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(RContext rContext) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.rSetRContext(rContext);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> with Context.
     *
     * @param rContext
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(RContext rContext) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.rSetRContext(rContext);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code> with Context.
     *
     * @param rContext
     * @return RNList
     */
    public RNList createRNList(RContext rContext) {
        RNList rNList_ = createRNList();
        rNList_.rSetRContext(rContext);
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code> with Context.
     *
     * @param rContext
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(RContext rContext) {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.rSetRContext(rContext);
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> with Context.
     *
     * @param rContext
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(RContext rContext) {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.rSetRContext(rContext);
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> with Context.
     *
     * @param rContext
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(RContext rContext) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.rSetRContext(rContext);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> with Context.
     *
     * @param rContext
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(RContext rContext) {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.rSetRContext(rContext);
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code> with Context.
     *
     * @param rContext
     * @return RNGroup
     */
    public RNGroup createRNGroup(RContext rContext) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.rSetRContext(rContext);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> with Context.
     *
     * @param rContext
     * @return RNChoice
     */
    public RNChoice createRNChoice(RContext rContext) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.rSetRContext(rContext);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> with Context.
     *
     * @param rContext
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(RContext rContext) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.rSetRContext(rContext);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> with Context.
     *
     * @param rContext
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(RContext rContext) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.rSetRContext(rContext);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code> with Context.
     *
     * @param rContext
     * @return RNMixed
     */
    public RNMixed createRNMixed(RContext rContext) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.rSetRContext(rContext);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> with Context.
     *
     * @param rContext
     * @return RNOptional
     */
    public RNOptional createRNOptional(RContext rContext) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.rSetRContext(rContext);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> with Context.
     *
     * @param rContext
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(RContext rContext) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.rSetRContext(rContext);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code> with Context.
     *
     * @param rContext
     * @return RNInclude
     */
    public RNInclude createRNInclude(RContext rContext) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.rSetRContext(rContext);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> with Context.
     *
     * @param rContext
     * @return RNDiv
     */
    public RNDiv createRNDiv(RContext rContext) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.rSetRContext(rContext);
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(RNGrammar source) {
        RContext rContext = createRContext();
        return (createRNGrammar(source, rContext));
    }

    /**
     * Creates a <code>RNStart</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNStart
     */
    public RNStart createRNStart(RNStart source) {
        RContext rContext = createRContext();
        return (createRNStart(source, rContext));
    }

    /**
     * Creates a <code>RNAttribute</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(RNAttribute source) {
        RContext rContext = createRContext();
        return (createRNAttribute(source, rContext));
    }

    /**
     * Creates a <code>RNNsName</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNNsName
     */
    public RNNsName createRNNsName(RNNsName source) {
        RContext rContext = createRContext();
        return (createRNNsName(source, rContext));
    }

    /**
     * Creates a <code>RNExcept</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNExcept
     */
    public RNExcept createRNExcept(RNExcept source) {
        RContext rContext = createRContext();
        return (createRNExcept(source, rContext));
    }

    /**
     * Creates a <code>RNName</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNName
     */
    public RNName createRNName(RNName source) {
        RContext rContext = createRContext();
        return (createRNName(source, rContext));
    }

    /**
     * Creates a <code>RNAnyName</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(RNAnyName source) {
        RContext rContext = createRContext();
        return (createRNAnyName(source, rContext));
    }

    /**
     * Creates a <code>RNNameChoice</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(RNNameChoice source) {
        RContext rContext = createRContext();
        return (createRNNameChoice(source, rContext));
    }

    /**
     * Creates a <code>RNDefine</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNDefine
     */
    public RNDefine createRNDefine(RNDefine source) {
        RContext rContext = createRContext();
        return (createRNDefine(source, rContext));
    }

    /**
     * Creates a <code>RNElement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNElement
     */
    public RNElement createRNElement(RNElement source) {
        RContext rContext = createRContext();
        return (createRNElement(source, rContext));
    }

    /**
     * Creates a <code>RNData</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNData
     */
    public RNData createRNData(RNData source) {
        RContext rContext = createRContext();
        return (createRNData(source, rContext));
    }

    /**
     * Creates a <code>RNParam</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNParam
     */
    public RNParam createRNParam(RNParam source) {
        RContext rContext = createRContext();
        return (createRNParam(source, rContext));
    }

    /**
     * Creates a <code>RNValue</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNValue
     */
    public RNValue createRNValue(RNValue source) {
        RContext rContext = createRContext();
        return (createRNValue(source, rContext));
    }

    /**
     * Creates a <code>RNRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNRef
     */
    public RNRef createRNRef(RNRef source) {
        RContext rContext = createRContext();
        return (createRNRef(source, rContext));
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(RNTextOneOrMore source) {
        RContext rContext = createRContext();
        return (createRNTextOneOrMore(source, rContext));
    }

    /**
     * Creates a <code>RNText</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNText
     */
    public RNText createRNText(RNText source) {
        RContext rContext = createRContext();
        return (createRNText(source, rContext));
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(RNNotAllowed source) {
        RContext rContext = createRContext();
        return (createRNNotAllowed(source, rContext));
    }

    /**
     * Creates a <code>RNEmpty</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(RNEmpty source) {
        RContext rContext = createRContext();
        return (createRNEmpty(source, rContext));
    }

    /**
     * Creates a <code>RNTextChoice</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(RNTextChoice source) {
        RContext rContext = createRContext();
        return (createRNTextChoice(source, rContext));
    }

    /**
     * Creates a <code>RNTextOptional</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(RNTextOptional source) {
        RContext rContext = createRContext();
        return (createRNTextOptional(source, rContext));
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(RNTextZeroOrMore source) {
        RContext rContext = createRContext();
        return (createRNTextZeroOrMore(source, rContext));
    }

    /**
     * Creates a <code>RNList</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNList
     */
    public RNList createRNList(RNList source) {
        RContext rContext = createRContext();
        return (createRNList(source, rContext));
    }

    /**
     * Creates a <code>RNTextGroup</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(RNTextGroup source) {
        RContext rContext = createRContext();
        return (createRNTextGroup(source, rContext));
    }

    /**
     * Creates a <code>RNTextExcept</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(RNTextExcept source) {
        RContext rContext = createRContext();
        return (createRNTextExcept(source, rContext));
    }

    /**
     * Creates a <code>RNExternalRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(RNExternalRef source) {
        RContext rContext = createRContext();
        return (createRNExternalRef(source, rContext));
    }

    /**
     * Creates a <code>RNParentRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(RNParentRef source) {
        RContext rContext = createRContext();
        return (createRNParentRef(source, rContext));
    }

    /**
     * Creates a <code>RNGroup</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNGroup
     */
    public RNGroup createRNGroup(RNGroup source) {
        RContext rContext = createRContext();
        return (createRNGroup(source, rContext));
    }

    /**
     * Creates a <code>RNChoice</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNChoice
     */
    public RNChoice createRNChoice(RNChoice source) {
        RContext rContext = createRContext();
        return (createRNChoice(source, rContext));
    }

    /**
     * Creates a <code>RNInterleave</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(RNInterleave source) {
        RContext rContext = createRContext();
        return (createRNInterleave(source, rContext));
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(RNOneOrMore source) {
        RContext rContext = createRContext();
        return (createRNOneOrMore(source, rContext));
    }

    /**
     * Creates a <code>RNMixed</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNMixed
     */
    public RNMixed createRNMixed(RNMixed source) {
        RContext rContext = createRContext();
        return (createRNMixed(source, rContext));
    }

    /**
     * Creates a <code>RNOptional</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNOptional
     */
    public RNOptional createRNOptional(RNOptional source) {
        RContext rContext = createRContext();
        return (createRNOptional(source, rContext));
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(RNZeroOrMore source) {
        RContext rContext = createRContext();
        return (createRNZeroOrMore(source, rContext));
    }

    /**
     * Creates a <code>RNInclude</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNInclude
     */
    public RNInclude createRNInclude(RNInclude source) {
        RContext rContext = createRContext();
        return (createRNInclude(source, rContext));
    }

    /**
     * Creates a <code>RNDiv</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return RNDiv
     */
    public RNDiv createRNDiv(RNDiv source) {
        RContext rContext = createRContext();
        return (createRNDiv(source, rContext));
    }

    /**
     * Creates a <code>RNGrammar</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(RNGrammar source, RContext rContext) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.rSetRContext(rContext);
        rNGrammar_.setup(source);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNStart
     */
    public RNStart createRNStart(RNStart source, RContext rContext) {
        RNStart rNStart_ = createRNStart();
        rNStart_.rSetRContext(rContext);
        rNStart_.setup(source);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(RNAttribute source, RContext rContext) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.rSetRContext(rContext);
        rNAttribute_.setup(source);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNNsName
     */
    public RNNsName createRNNsName(RNNsName source, RContext rContext) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.rSetRContext(rContext);
        rNNsName_.setup(source);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNExcept
     */
    public RNExcept createRNExcept(RNExcept source, RContext rContext) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.rSetRContext(rContext);
        rNExcept_.setup(source);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNName
     */
    public RNName createRNName(RNName source, RContext rContext) {
        RNName rNName_ = createRNName();
        rNName_.rSetRContext(rContext);
        rNName_.setup(source);
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(RNAnyName source, RContext rContext) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.rSetRContext(rContext);
        rNAnyName_.setup(source);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(RNNameChoice source, RContext rContext) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.rSetRContext(rContext);
        rNNameChoice_.setup(source);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNDefine
     */
    public RNDefine createRNDefine(RNDefine source, RContext rContext) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.rSetRContext(rContext);
        rNDefine_.setup(source);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNElement
     */
    public RNElement createRNElement(RNElement source, RContext rContext) {
        RNElement rNElement_ = createRNElement();
        rNElement_.rSetRContext(rContext);
        rNElement_.setup(source);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNData
     */
    public RNData createRNData(RNData source, RContext rContext) {
        RNData rNData_ = createRNData();
        rNData_.rSetRContext(rContext);
        rNData_.setup(source);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNParam
     */
    public RNParam createRNParam(RNParam source, RContext rContext) {
        RNParam rNParam_ = createRNParam();
        rNParam_.rSetRContext(rContext);
        rNParam_.setup(source);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNValue
     */
    public RNValue createRNValue(RNValue source, RContext rContext) {
        RNValue rNValue_ = createRNValue();
        rNValue_.rSetRContext(rContext);
        rNValue_.setup(source);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNRef
     */
    public RNRef createRNRef(RNRef source, RContext rContext) {
        RNRef rNRef_ = createRNRef();
        rNRef_.rSetRContext(rContext);
        rNRef_.setup(source);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(RNTextOneOrMore source, RContext rContext) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.rSetRContext(rContext);
        rNTextOneOrMore_.setup(source);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNText
     */
    public RNText createRNText(RNText source, RContext rContext) {
        RNText rNText_ = createRNText();
        rNText_.rSetRContext(rContext);
        rNText_.setup(source);
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(RNNotAllowed source, RContext rContext) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.rSetRContext(rContext);
        rNNotAllowed_.setup(source);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(RNEmpty source, RContext rContext) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.rSetRContext(rContext);
        rNEmpty_.setup(source);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(RNTextChoice source, RContext rContext) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.rSetRContext(rContext);
        rNTextChoice_.setup(source);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(RNTextOptional source, RContext rContext) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.rSetRContext(rContext);
        rNTextOptional_.setup(source);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(RNTextZeroOrMore source, RContext rContext) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.rSetRContext(rContext);
        rNTextZeroOrMore_.setup(source);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNList
     */
    public RNList createRNList(RNList source, RContext rContext) {
        RNList rNList_ = createRNList();
        rNList_.rSetRContext(rContext);
        rNList_.setup(source);
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(RNTextGroup source, RContext rContext) {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.rSetRContext(rContext);
        rNTextGroup_.setup(source);
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(RNTextExcept source, RContext rContext) {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.rSetRContext(rContext);
        rNTextExcept_.setup(source);
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(RNExternalRef source, RContext rContext) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.rSetRContext(rContext);
        rNExternalRef_.setup(source);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(RNParentRef source, RContext rContext) {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.rSetRContext(rContext);
        rNParentRef_.setup(source);
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNGroup
     */
    public RNGroup createRNGroup(RNGroup source, RContext rContext) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.rSetRContext(rContext);
        rNGroup_.setup(source);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNChoice
     */
    public RNChoice createRNChoice(RNChoice source, RContext rContext) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.rSetRContext(rContext);
        rNChoice_.setup(source);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(RNInterleave source, RContext rContext) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.rSetRContext(rContext);
        rNInterleave_.setup(source);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(RNOneOrMore source, RContext rContext) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.rSetRContext(rContext);
        rNOneOrMore_.setup(source);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNMixed
     */
    public RNMixed createRNMixed(RNMixed source, RContext rContext) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.rSetRContext(rContext);
        rNMixed_.setup(source);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNOptional
     */
    public RNOptional createRNOptional(RNOptional source, RContext rContext) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.rSetRContext(rContext);
        rNOptional_.setup(source);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(RNZeroOrMore source, RContext rContext) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.rSetRContext(rContext);
        rNZeroOrMore_.setup(source);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNInclude
     */
    public RNInclude createRNInclude(RNInclude source, RContext rContext) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.rSetRContext(rContext);
        rNInclude_.setup(source);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @param rContext
     * @return RNDiv
     */
    public RNDiv createRNDiv(RNDiv source, RContext rContext) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.rSetRContext(rContext);
        rNDiv_.setup(source);
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Document doc) {
        RContext rContext = createRContext();
        return (createRNGrammar(doc, rContext));
    }

    /**
     * Creates a <code>RNStart</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNStart
     */
    public RNStart createRNStart(Document doc) {
        RContext rContext = createRContext();
        return (createRNStart(doc, rContext));
    }

    /**
     * Creates a <code>RNAttribute</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Document doc) {
        RContext rContext = createRContext();
        return (createRNAttribute(doc, rContext));
    }

    /**
     * Creates a <code>RNNsName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNNsName
     */
    public RNNsName createRNNsName(Document doc) {
        RContext rContext = createRContext();
        return (createRNNsName(doc, rContext));
    }

    /**
     * Creates a <code>RNExcept</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNExcept
     */
    public RNExcept createRNExcept(Document doc) {
        RContext rContext = createRContext();
        return (createRNExcept(doc, rContext));
    }

    /**
     * Creates a <code>RNName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNName
     */
    public RNName createRNName(Document doc) {
        RContext rContext = createRContext();
        return (createRNName(doc, rContext));
    }

    /**
     * Creates a <code>RNAnyName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Document doc) {
        RContext rContext = createRContext();
        return (createRNAnyName(doc, rContext));
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Document doc) {
        RContext rContext = createRContext();
        return (createRNNameChoice(doc, rContext));
    }

    /**
     * Creates a <code>RNDefine</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNDefine
     */
    public RNDefine createRNDefine(Document doc) {
        RContext rContext = createRContext();
        return (createRNDefine(doc, rContext));
    }

    /**
     * Creates a <code>RNElement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNElement
     */
    public RNElement createRNElement(Document doc) {
        RContext rContext = createRContext();
        return (createRNElement(doc, rContext));
    }

    /**
     * Creates a <code>RNData</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNData
     */
    public RNData createRNData(Document doc) {
        RContext rContext = createRContext();
        return (createRNData(doc, rContext));
    }

    /**
     * Creates a <code>RNParam</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNParam
     */
    public RNParam createRNParam(Document doc) {
        RContext rContext = createRContext();
        return (createRNParam(doc, rContext));
    }

    /**
     * Creates a <code>RNValue</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNValue
     */
    public RNValue createRNValue(Document doc) {
        RContext rContext = createRContext();
        return (createRNValue(doc, rContext));
    }

    /**
     * Creates a <code>RNRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNRef
     */
    public RNRef createRNRef(Document doc) {
        RContext rContext = createRContext();
        return (createRNRef(doc, rContext));
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Document doc) {
        RContext rContext = createRContext();
        return (createRNTextOneOrMore(doc, rContext));
    }

    /**
     * Creates a <code>RNText</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNText
     */
    public RNText createRNText(Document doc) {
        RContext rContext = createRContext();
        return (createRNText(doc, rContext));
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Document doc) {
        RContext rContext = createRContext();
        return (createRNNotAllowed(doc, rContext));
    }

    /**
     * Creates a <code>RNEmpty</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Document doc) {
        RContext rContext = createRContext();
        return (createRNEmpty(doc, rContext));
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Document doc) {
        RContext rContext = createRContext();
        return (createRNTextChoice(doc, rContext));
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Document doc) {
        RContext rContext = createRContext();
        return (createRNTextOptional(doc, rContext));
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Document doc) {
        RContext rContext = createRContext();
        return (createRNTextZeroOrMore(doc, rContext));
    }

    /**
     * Creates a <code>RNList</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNList
     */
    public RNList createRNList(Document doc) {
        RContext rContext = createRContext();
        return (createRNList(doc, rContext));
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(Document doc) {
        RContext rContext = createRContext();
        return (createRNTextGroup(doc, rContext));
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(Document doc) {
        RContext rContext = createRContext();
        return (createRNTextExcept(doc, rContext));
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Document doc) {
        RContext rContext = createRContext();
        return (createRNExternalRef(doc, rContext));
    }

    /**
     * Creates a <code>RNParentRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(Document doc) {
        RContext rContext = createRContext();
        return (createRNParentRef(doc, rContext));
    }

    /**
     * Creates a <code>RNGroup</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNGroup
     */
    public RNGroup createRNGroup(Document doc) {
        RContext rContext = createRContext();
        return (createRNGroup(doc, rContext));
    }

    /**
     * Creates a <code>RNChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNChoice
     */
    public RNChoice createRNChoice(Document doc) {
        RContext rContext = createRContext();
        return (createRNChoice(doc, rContext));
    }

    /**
     * Creates a <code>RNInterleave</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Document doc) {
        RContext rContext = createRContext();
        return (createRNInterleave(doc, rContext));
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Document doc) {
        RContext rContext = createRContext();
        return (createRNOneOrMore(doc, rContext));
    }

    /**
     * Creates a <code>RNMixed</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNMixed
     */
    public RNMixed createRNMixed(Document doc) {
        RContext rContext = createRContext();
        return (createRNMixed(doc, rContext));
    }

    /**
     * Creates a <code>RNOptional</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNOptional
     */
    public RNOptional createRNOptional(Document doc) {
        RContext rContext = createRContext();
        return (createRNOptional(doc, rContext));
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Document doc) {
        RContext rContext = createRContext();
        return (createRNZeroOrMore(doc, rContext));
    }

    /**
     * Creates a <code>RNInclude</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNInclude
     */
    public RNInclude createRNInclude(Document doc) {
        RContext rContext = createRContext();
        return (createRNInclude(doc, rContext));
    }

    /**
     * Creates a <code>RNDiv</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return RNDiv
     */
    public RNDiv createRNDiv(Document doc) {
        RContext rContext = createRContext();
        return (createRNDiv(doc, rContext));
    }

    /**
     * Creates a <code>RNGrammar</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Document doc, RContext rContext) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.rSetRContext(rContext);
        rNGrammar_.setup(doc);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNStart
     */
    public RNStart createRNStart(Document doc, RContext rContext) {
        RNStart rNStart_ = createRNStart();
        rNStart_.rSetRContext(rContext);
        rNStart_.setup(doc);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Document doc, RContext rContext) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.rSetRContext(rContext);
        rNAttribute_.setup(doc);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNNsName
     */
    public RNNsName createRNNsName(Document doc, RContext rContext) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.rSetRContext(rContext);
        rNNsName_.setup(doc);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNExcept
     */
    public RNExcept createRNExcept(Document doc, RContext rContext) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.rSetRContext(rContext);
        rNExcept_.setup(doc);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNName
     */
    public RNName createRNName(Document doc, RContext rContext) {
        RNName rNName_ = createRNName();
        rNName_.rSetRContext(rContext);
        rNName_.setup(doc);
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Document doc, RContext rContext) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.rSetRContext(rContext);
        rNAnyName_.setup(doc);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Document doc, RContext rContext) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.rSetRContext(rContext);
        rNNameChoice_.setup(doc);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNDefine
     */
    public RNDefine createRNDefine(Document doc, RContext rContext) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.rSetRContext(rContext);
        rNDefine_.setup(doc);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNElement
     */
    public RNElement createRNElement(Document doc, RContext rContext) {
        RNElement rNElement_ = createRNElement();
        rNElement_.rSetRContext(rContext);
        rNElement_.setup(doc);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNData
     */
    public RNData createRNData(Document doc, RContext rContext) {
        RNData rNData_ = createRNData();
        rNData_.rSetRContext(rContext);
        rNData_.setup(doc);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNParam
     */
    public RNParam createRNParam(Document doc, RContext rContext) {
        RNParam rNParam_ = createRNParam();
        rNParam_.rSetRContext(rContext);
        rNParam_.setup(doc);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNValue
     */
    public RNValue createRNValue(Document doc, RContext rContext) {
        RNValue rNValue_ = createRNValue();
        rNValue_.rSetRContext(rContext);
        rNValue_.setup(doc);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNRef
     */
    public RNRef createRNRef(Document doc, RContext rContext) {
        RNRef rNRef_ = createRNRef();
        rNRef_.rSetRContext(rContext);
        rNRef_.setup(doc);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Document doc, RContext rContext) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.rSetRContext(rContext);
        rNTextOneOrMore_.setup(doc);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNText
     */
    public RNText createRNText(Document doc, RContext rContext) {
        RNText rNText_ = createRNText();
        rNText_.rSetRContext(rContext);
        rNText_.setup(doc);
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Document doc, RContext rContext) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.rSetRContext(rContext);
        rNNotAllowed_.setup(doc);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Document doc, RContext rContext) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.rSetRContext(rContext);
        rNEmpty_.setup(doc);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Document doc, RContext rContext) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.rSetRContext(rContext);
        rNTextChoice_.setup(doc);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Document doc, RContext rContext) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.rSetRContext(rContext);
        rNTextOptional_.setup(doc);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Document doc, RContext rContext) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.rSetRContext(rContext);
        rNTextZeroOrMore_.setup(doc);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNList
     */
    public RNList createRNList(Document doc, RContext rContext) {
        RNList rNList_ = createRNList();
        rNList_.rSetRContext(rContext);
        rNList_.setup(doc);
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(Document doc, RContext rContext) {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.rSetRContext(rContext);
        rNTextGroup_.setup(doc);
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(Document doc, RContext rContext) {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.rSetRContext(rContext);
        rNTextExcept_.setup(doc);
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Document doc, RContext rContext) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.rSetRContext(rContext);
        rNExternalRef_.setup(doc);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(Document doc, RContext rContext) {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.rSetRContext(rContext);
        rNParentRef_.setup(doc);
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNGroup
     */
    public RNGroup createRNGroup(Document doc, RContext rContext) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.rSetRContext(rContext);
        rNGroup_.setup(doc);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNChoice
     */
    public RNChoice createRNChoice(Document doc, RContext rContext) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.rSetRContext(rContext);
        rNChoice_.setup(doc);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Document doc, RContext rContext) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.rSetRContext(rContext);
        rNInterleave_.setup(doc);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Document doc, RContext rContext) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.rSetRContext(rContext);
        rNOneOrMore_.setup(doc);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNMixed
     */
    public RNMixed createRNMixed(Document doc, RContext rContext) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.rSetRContext(rContext);
        rNMixed_.setup(doc);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNOptional
     */
    public RNOptional createRNOptional(Document doc, RContext rContext) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.rSetRContext(rContext);
        rNOptional_.setup(doc);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Document doc, RContext rContext) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.rSetRContext(rContext);
        rNZeroOrMore_.setup(doc);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNInclude
     */
    public RNInclude createRNInclude(Document doc, RContext rContext) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.rSetRContext(rContext);
        rNInclude_.setup(doc);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @param rContext
     * @return RNDiv
     */
    public RNDiv createRNDiv(Document doc, RContext rContext) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.rSetRContext(rContext);
        rNDiv_.setup(doc);
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Element element) {
        RContext rContext = createRContext();
        return (createRNGrammar(element, rContext));
    }

    /**
     * Creates a <code>RNStart</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNStart
     */
    public RNStart createRNStart(Element element) {
        RContext rContext = createRContext();
        return (createRNStart(element, rContext));
    }

    /**
     * Creates a <code>RNAttribute</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Element element) {
        RContext rContext = createRContext();
        return (createRNAttribute(element, rContext));
    }

    /**
     * Creates a <code>RNNsName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNNsName
     */
    public RNNsName createRNNsName(Element element) {
        RContext rContext = createRContext();
        return (createRNNsName(element, rContext));
    }

    /**
     * Creates a <code>RNExcept</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNExcept
     */
    public RNExcept createRNExcept(Element element) {
        RContext rContext = createRContext();
        return (createRNExcept(element, rContext));
    }

    /**
     * Creates a <code>RNName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNName
     */
    public RNName createRNName(Element element) {
        RContext rContext = createRContext();
        return (createRNName(element, rContext));
    }

    /**
     * Creates a <code>RNAnyName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Element element) {
        RContext rContext = createRContext();
        return (createRNAnyName(element, rContext));
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Element element) {
        RContext rContext = createRContext();
        return (createRNNameChoice(element, rContext));
    }

    /**
     * Creates a <code>RNDefine</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNDefine
     */
    public RNDefine createRNDefine(Element element) {
        RContext rContext = createRContext();
        return (createRNDefine(element, rContext));
    }

    /**
     * Creates a <code>RNElement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNElement
     */
    public RNElement createRNElement(Element element) {
        RContext rContext = createRContext();
        return (createRNElement(element, rContext));
    }

    /**
     * Creates a <code>RNData</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNData
     */
    public RNData createRNData(Element element) {
        RContext rContext = createRContext();
        return (createRNData(element, rContext));
    }

    /**
     * Creates a <code>RNParam</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNParam
     */
    public RNParam createRNParam(Element element) {
        RContext rContext = createRContext();
        return (createRNParam(element, rContext));
    }

    /**
     * Creates a <code>RNValue</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNValue
     */
    public RNValue createRNValue(Element element) {
        RContext rContext = createRContext();
        return (createRNValue(element, rContext));
    }

    /**
     * Creates a <code>RNRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNRef
     */
    public RNRef createRNRef(Element element) {
        RContext rContext = createRContext();
        return (createRNRef(element, rContext));
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Element element) {
        RContext rContext = createRContext();
        return (createRNTextOneOrMore(element, rContext));
    }

    /**
     * Creates a <code>RNText</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNText
     */
    public RNText createRNText(Element element) {
        RContext rContext = createRContext();
        return (createRNText(element, rContext));
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Element element) {
        RContext rContext = createRContext();
        return (createRNNotAllowed(element, rContext));
    }

    /**
     * Creates a <code>RNEmpty</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Element element) {
        RContext rContext = createRContext();
        return (createRNEmpty(element, rContext));
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Element element) {
        RContext rContext = createRContext();
        return (createRNTextChoice(element, rContext));
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Element element) {
        RContext rContext = createRContext();
        return (createRNTextOptional(element, rContext));
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Element element) {
        RContext rContext = createRContext();
        return (createRNTextZeroOrMore(element, rContext));
    }

    /**
     * Creates a <code>RNList</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNList
     */
    public RNList createRNList(Element element) {
        RContext rContext = createRContext();
        return (createRNList(element, rContext));
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(Element element) {
        RContext rContext = createRContext();
        return (createRNTextGroup(element, rContext));
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(Element element) {
        RContext rContext = createRContext();
        return (createRNTextExcept(element, rContext));
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Element element) {
        RContext rContext = createRContext();
        return (createRNExternalRef(element, rContext));
    }

    /**
     * Creates a <code>RNParentRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(Element element) {
        RContext rContext = createRContext();
        return (createRNParentRef(element, rContext));
    }

    /**
     * Creates a <code>RNGroup</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNGroup
     */
    public RNGroup createRNGroup(Element element) {
        RContext rContext = createRContext();
        return (createRNGroup(element, rContext));
    }

    /**
     * Creates a <code>RNChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNChoice
     */
    public RNChoice createRNChoice(Element element) {
        RContext rContext = createRContext();
        return (createRNChoice(element, rContext));
    }

    /**
     * Creates a <code>RNInterleave</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Element element) {
        RContext rContext = createRContext();
        return (createRNInterleave(element, rContext));
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Element element) {
        RContext rContext = createRContext();
        return (createRNOneOrMore(element, rContext));
    }

    /**
     * Creates a <code>RNMixed</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNMixed
     */
    public RNMixed createRNMixed(Element element) {
        RContext rContext = createRContext();
        return (createRNMixed(element, rContext));
    }

    /**
     * Creates a <code>RNOptional</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNOptional
     */
    public RNOptional createRNOptional(Element element) {
        RContext rContext = createRContext();
        return (createRNOptional(element, rContext));
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Element element) {
        RContext rContext = createRContext();
        return (createRNZeroOrMore(element, rContext));
    }

    /**
     * Creates a <code>RNInclude</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNInclude
     */
    public RNInclude createRNInclude(Element element) {
        RContext rContext = createRContext();
        return (createRNInclude(element, rContext));
    }

    /**
     * Creates a <code>RNDiv</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return RNDiv
     */
    public RNDiv createRNDiv(Element element) {
        RContext rContext = createRContext();
        return (createRNDiv(element, rContext));
    }

    /**
     * Creates a <code>RNGrammar</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(Element element, RContext rContext) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.rSetRContext(rContext);
        rNGrammar_.setup(element);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNStart
     */
    public RNStart createRNStart(Element element, RContext rContext) {
        RNStart rNStart_ = createRNStart();
        rNStart_.rSetRContext(rContext);
        rNStart_.setup(element);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(Element element, RContext rContext) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.rSetRContext(rContext);
        rNAttribute_.setup(element);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNNsName
     */
    public RNNsName createRNNsName(Element element, RContext rContext) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.rSetRContext(rContext);
        rNNsName_.setup(element);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNExcept
     */
    public RNExcept createRNExcept(Element element, RContext rContext) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.rSetRContext(rContext);
        rNExcept_.setup(element);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNName
     */
    public RNName createRNName(Element element, RContext rContext) {
        RNName rNName_ = createRNName();
        rNName_.rSetRContext(rContext);
        rNName_.setup(element);
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(Element element, RContext rContext) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.rSetRContext(rContext);
        rNAnyName_.setup(element);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(Element element, RContext rContext) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.rSetRContext(rContext);
        rNNameChoice_.setup(element);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNDefine
     */
    public RNDefine createRNDefine(Element element, RContext rContext) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.rSetRContext(rContext);
        rNDefine_.setup(element);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNElement
     */
    public RNElement createRNElement(Element element, RContext rContext) {
        RNElement rNElement_ = createRNElement();
        rNElement_.rSetRContext(rContext);
        rNElement_.setup(element);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNData
     */
    public RNData createRNData(Element element, RContext rContext) {
        RNData rNData_ = createRNData();
        rNData_.rSetRContext(rContext);
        rNData_.setup(element);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNParam
     */
    public RNParam createRNParam(Element element, RContext rContext) {
        RNParam rNParam_ = createRNParam();
        rNParam_.rSetRContext(rContext);
        rNParam_.setup(element);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNValue
     */
    public RNValue createRNValue(Element element, RContext rContext) {
        RNValue rNValue_ = createRNValue();
        rNValue_.rSetRContext(rContext);
        rNValue_.setup(element);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNRef
     */
    public RNRef createRNRef(Element element, RContext rContext) {
        RNRef rNRef_ = createRNRef();
        rNRef_.rSetRContext(rContext);
        rNRef_.setup(element);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(Element element, RContext rContext) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.rSetRContext(rContext);
        rNTextOneOrMore_.setup(element);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNText
     */
    public RNText createRNText(Element element, RContext rContext) {
        RNText rNText_ = createRNText();
        rNText_.rSetRContext(rContext);
        rNText_.setup(element);
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(Element element, RContext rContext) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.rSetRContext(rContext);
        rNNotAllowed_.setup(element);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(Element element, RContext rContext) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.rSetRContext(rContext);
        rNEmpty_.setup(element);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(Element element, RContext rContext) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.rSetRContext(rContext);
        rNTextChoice_.setup(element);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(Element element, RContext rContext) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.rSetRContext(rContext);
        rNTextOptional_.setup(element);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(Element element, RContext rContext) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.rSetRContext(rContext);
        rNTextZeroOrMore_.setup(element);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNList
     */
    public RNList createRNList(Element element, RContext rContext) {
        RNList rNList_ = createRNList();
        rNList_.rSetRContext(rContext);
        rNList_.setup(element);
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(Element element, RContext rContext) {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.rSetRContext(rContext);
        rNTextGroup_.setup(element);
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(Element element, RContext rContext) {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.rSetRContext(rContext);
        rNTextExcept_.setup(element);
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(Element element, RContext rContext) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.rSetRContext(rContext);
        rNExternalRef_.setup(element);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(Element element, RContext rContext) {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.rSetRContext(rContext);
        rNParentRef_.setup(element);
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNGroup
     */
    public RNGroup createRNGroup(Element element, RContext rContext) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.rSetRContext(rContext);
        rNGroup_.setup(element);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNChoice
     */
    public RNChoice createRNChoice(Element element, RContext rContext) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.rSetRContext(rContext);
        rNChoice_.setup(element);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(Element element, RContext rContext) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.rSetRContext(rContext);
        rNInterleave_.setup(element);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(Element element, RContext rContext) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.rSetRContext(rContext);
        rNOneOrMore_.setup(element);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNMixed
     */
    public RNMixed createRNMixed(Element element, RContext rContext) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.rSetRContext(rContext);
        rNMixed_.setup(element);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNOptional
     */
    public RNOptional createRNOptional(Element element, RContext rContext) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.rSetRContext(rContext);
        rNOptional_.setup(element);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(Element element, RContext rContext) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.rSetRContext(rContext);
        rNZeroOrMore_.setup(element);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNInclude
     */
    public RNInclude createRNInclude(Element element, RContext rContext) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.rSetRContext(rContext);
        rNInclude_.setup(element);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @param rContext
     * @return RNDiv
     */
    public RNDiv createRNDiv(Element element, RContext rContext) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.rSetRContext(rContext);
        rNDiv_.setup(element);
        return (rNDiv_);
    }

    /**
     * Creates a <code>RNGrammar</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(RStack stack) {
        RContext rContext = createRContext();
        return (createRNGrammar(stack, rContext));
    }

    /**
     * Creates a <code>RNStart</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNStart
     */
    public RNStart createRNStart(RStack stack) {
        RContext rContext = createRContext();
        return (createRNStart(stack, rContext));
    }

    /**
     * Creates a <code>RNAttribute</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(RStack stack) {
        RContext rContext = createRContext();
        return (createRNAttribute(stack, rContext));
    }

    /**
     * Creates a <code>RNNsName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNNsName
     */
    public RNNsName createRNNsName(RStack stack) {
        RContext rContext = createRContext();
        return (createRNNsName(stack, rContext));
    }

    /**
     * Creates a <code>RNExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNExcept
     */
    public RNExcept createRNExcept(RStack stack) {
        RContext rContext = createRContext();
        return (createRNExcept(stack, rContext));
    }

    /**
     * Creates a <code>RNName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNName
     */
    public RNName createRNName(RStack stack) {
        RContext rContext = createRContext();
        return (createRNName(stack, rContext));
    }

    /**
     * Creates a <code>RNAnyName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(RStack stack) {
        RContext rContext = createRContext();
        return (createRNAnyName(stack, rContext));
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(RStack stack) {
        RContext rContext = createRContext();
        return (createRNNameChoice(stack, rContext));
    }

    /**
     * Creates a <code>RNDefine</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNDefine
     */
    public RNDefine createRNDefine(RStack stack) {
        RContext rContext = createRContext();
        return (createRNDefine(stack, rContext));
    }

    /**
     * Creates a <code>RNElement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNElement
     */
    public RNElement createRNElement(RStack stack) {
        RContext rContext = createRContext();
        return (createRNElement(stack, rContext));
    }

    /**
     * Creates a <code>RNData</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNData
     */
    public RNData createRNData(RStack stack) {
        RContext rContext = createRContext();
        return (createRNData(stack, rContext));
    }

    /**
     * Creates a <code>RNParam</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNParam
     */
    public RNParam createRNParam(RStack stack) {
        RContext rContext = createRContext();
        return (createRNParam(stack, rContext));
    }

    /**
     * Creates a <code>RNValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNValue
     */
    public RNValue createRNValue(RStack stack) {
        RContext rContext = createRContext();
        return (createRNValue(stack, rContext));
    }

    /**
     * Creates a <code>RNRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNRef
     */
    public RNRef createRNRef(RStack stack) {
        RContext rContext = createRContext();
        return (createRNRef(stack, rContext));
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(RStack stack) {
        RContext rContext = createRContext();
        return (createRNTextOneOrMore(stack, rContext));
    }

    /**
     * Creates a <code>RNText</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNText
     */
    public RNText createRNText(RStack stack) {
        RContext rContext = createRContext();
        return (createRNText(stack, rContext));
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(RStack stack) {
        RContext rContext = createRContext();
        return (createRNNotAllowed(stack, rContext));
    }

    /**
     * Creates a <code>RNEmpty</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(RStack stack) {
        RContext rContext = createRContext();
        return (createRNEmpty(stack, rContext));
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(RStack stack) {
        RContext rContext = createRContext();
        return (createRNTextChoice(stack, rContext));
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(RStack stack) {
        RContext rContext = createRContext();
        return (createRNTextOptional(stack, rContext));
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(RStack stack) {
        RContext rContext = createRContext();
        return (createRNTextZeroOrMore(stack, rContext));
    }

    /**
     * Creates a <code>RNList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNList
     */
    public RNList createRNList(RStack stack) {
        RContext rContext = createRContext();
        return (createRNList(stack, rContext));
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(RStack stack) {
        RContext rContext = createRContext();
        return (createRNTextGroup(stack, rContext));
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(RStack stack) {
        RContext rContext = createRContext();
        return (createRNTextExcept(stack, rContext));
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(RStack stack) {
        RContext rContext = createRContext();
        return (createRNExternalRef(stack, rContext));
    }

    /**
     * Creates a <code>RNParentRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(RStack stack) {
        RContext rContext = createRContext();
        return (createRNParentRef(stack, rContext));
    }

    /**
     * Creates a <code>RNGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNGroup
     */
    public RNGroup createRNGroup(RStack stack) {
        RContext rContext = createRContext();
        return (createRNGroup(stack, rContext));
    }

    /**
     * Creates a <code>RNChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNChoice
     */
    public RNChoice createRNChoice(RStack stack) {
        RContext rContext = createRContext();
        return (createRNChoice(stack, rContext));
    }

    /**
     * Creates a <code>RNInterleave</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(RStack stack) {
        RContext rContext = createRContext();
        return (createRNInterleave(stack, rContext));
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(RStack stack) {
        RContext rContext = createRContext();
        return (createRNOneOrMore(stack, rContext));
    }

    /**
     * Creates a <code>RNMixed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNMixed
     */
    public RNMixed createRNMixed(RStack stack) {
        RContext rContext = createRContext();
        return (createRNMixed(stack, rContext));
    }

    /**
     * Creates a <code>RNOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNOptional
     */
    public RNOptional createRNOptional(RStack stack) {
        RContext rContext = createRContext();
        return (createRNOptional(stack, rContext));
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(RStack stack) {
        RContext rContext = createRContext();
        return (createRNZeroOrMore(stack, rContext));
    }

    /**
     * Creates a <code>RNInclude</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNInclude
     */
    public RNInclude createRNInclude(RStack stack) {
        RContext rContext = createRContext();
        return (createRNInclude(stack, rContext));
    }

    /**
     * Creates a <code>RNDiv</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return RNDiv
     */
    public RNDiv createRNDiv(RStack stack) {
        RContext rContext = createRContext();
        return (createRNDiv(stack, rContext));
    }

    /**
     * Creates a <code>RNGrammar</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNGrammar
     */
    public RNGrammar createRNGrammar(RStack stack, RContext rContext) {
        RNGrammar rNGrammar_ = createRNGrammar();
        rNGrammar_.rSetRContext(rContext);
        rNGrammar_.setup(stack);
        return (rNGrammar_);
    }

    /**
     * Creates a <code>RNStart</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNStart
     */
    public RNStart createRNStart(RStack stack, RContext rContext) {
        RNStart rNStart_ = createRNStart();
        rNStart_.rSetRContext(rContext);
        rNStart_.setup(stack);
        return (rNStart_);
    }

    /**
     * Creates a <code>RNAttribute</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNAttribute
     */
    public RNAttribute createRNAttribute(RStack stack, RContext rContext) {
        RNAttribute rNAttribute_ = createRNAttribute();
        rNAttribute_.rSetRContext(rContext);
        rNAttribute_.setup(stack);
        return (rNAttribute_);
    }

    /**
     * Creates a <code>RNNsName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNNsName
     */
    public RNNsName createRNNsName(RStack stack, RContext rContext) {
        RNNsName rNNsName_ = createRNNsName();
        rNNsName_.rSetRContext(rContext);
        rNNsName_.setup(stack);
        return (rNNsName_);
    }

    /**
     * Creates a <code>RNExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNExcept
     */
    public RNExcept createRNExcept(RStack stack, RContext rContext) {
        RNExcept rNExcept_ = createRNExcept();
        rNExcept_.rSetRContext(rContext);
        rNExcept_.setup(stack);
        return (rNExcept_);
    }

    /**
     * Creates a <code>RNName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNName
     */
    public RNName createRNName(RStack stack, RContext rContext) {
        RNName rNName_ = createRNName();
        rNName_.rSetRContext(rContext);
        rNName_.setup(stack);
        return (rNName_);
    }

    /**
     * Creates a <code>RNAnyName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNAnyName
     */
    public RNAnyName createRNAnyName(RStack stack, RContext rContext) {
        RNAnyName rNAnyName_ = createRNAnyName();
        rNAnyName_.rSetRContext(rContext);
        rNAnyName_.setup(stack);
        return (rNAnyName_);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNNameChoice
     */
    public RNNameChoice createRNNameChoice(RStack stack, RContext rContext) {
        RNNameChoice rNNameChoice_ = createRNNameChoice();
        rNNameChoice_.rSetRContext(rContext);
        rNNameChoice_.setup(stack);
        return (rNNameChoice_);
    }

    /**
     * Creates a <code>RNDefine</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNDefine
     */
    public RNDefine createRNDefine(RStack stack, RContext rContext) {
        RNDefine rNDefine_ = createRNDefine();
        rNDefine_.rSetRContext(rContext);
        rNDefine_.setup(stack);
        return (rNDefine_);
    }

    /**
     * Creates a <code>RNElement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNElement
     */
    public RNElement createRNElement(RStack stack, RContext rContext) {
        RNElement rNElement_ = createRNElement();
        rNElement_.rSetRContext(rContext);
        rNElement_.setup(stack);
        return (rNElement_);
    }

    /**
     * Creates a <code>RNData</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNData
     */
    public RNData createRNData(RStack stack, RContext rContext) {
        RNData rNData_ = createRNData();
        rNData_.rSetRContext(rContext);
        rNData_.setup(stack);
        return (rNData_);
    }

    /**
     * Creates a <code>RNParam</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNParam
     */
    public RNParam createRNParam(RStack stack, RContext rContext) {
        RNParam rNParam_ = createRNParam();
        rNParam_.rSetRContext(rContext);
        rNParam_.setup(stack);
        return (rNParam_);
    }

    /**
     * Creates a <code>RNValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNValue
     */
    public RNValue createRNValue(RStack stack, RContext rContext) {
        RNValue rNValue_ = createRNValue();
        rNValue_.rSetRContext(rContext);
        rNValue_.setup(stack);
        return (rNValue_);
    }

    /**
     * Creates a <code>RNRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNRef
     */
    public RNRef createRNRef(RStack stack, RContext rContext) {
        RNRef rNRef_ = createRNRef();
        rNRef_.rSetRContext(rContext);
        rNRef_.setup(stack);
        return (rNRef_);
    }

    /**
     * Creates a <code>RNTextOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNTextOneOrMore
     */
    public RNTextOneOrMore createRNTextOneOrMore(RStack stack, RContext rContext) {
        RNTextOneOrMore rNTextOneOrMore_ = createRNTextOneOrMore();
        rNTextOneOrMore_.rSetRContext(rContext);
        rNTextOneOrMore_.setup(stack);
        return (rNTextOneOrMore_);
    }

    /**
     * Creates a <code>RNText</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNText
     */
    public RNText createRNText(RStack stack, RContext rContext) {
        RNText rNText_ = createRNText();
        rNText_.rSetRContext(rContext);
        rNText_.setup(stack);
        return (rNText_);
    }

    /**
     * Creates a <code>RNNotAllowed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNNotAllowed
     */
    public RNNotAllowed createRNNotAllowed(RStack stack, RContext rContext) {
        RNNotAllowed rNNotAllowed_ = createRNNotAllowed();
        rNNotAllowed_.rSetRContext(rContext);
        rNNotAllowed_.setup(stack);
        return (rNNotAllowed_);
    }

    /**
     * Creates a <code>RNEmpty</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNEmpty
     */
    public RNEmpty createRNEmpty(RStack stack, RContext rContext) {
        RNEmpty rNEmpty_ = createRNEmpty();
        rNEmpty_.rSetRContext(rContext);
        rNEmpty_.setup(stack);
        return (rNEmpty_);
    }

    /**
     * Creates a <code>RNTextChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNTextChoice
     */
    public RNTextChoice createRNTextChoice(RStack stack, RContext rContext) {
        RNTextChoice rNTextChoice_ = createRNTextChoice();
        rNTextChoice_.rSetRContext(rContext);
        rNTextChoice_.setup(stack);
        return (rNTextChoice_);
    }

    /**
     * Creates a <code>RNTextOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNTextOptional
     */
    public RNTextOptional createRNTextOptional(RStack stack, RContext rContext) {
        RNTextOptional rNTextOptional_ = createRNTextOptional();
        rNTextOptional_.rSetRContext(rContext);
        rNTextOptional_.setup(stack);
        return (rNTextOptional_);
    }

    /**
     * Creates a <code>RNTextZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNTextZeroOrMore
     */
    public RNTextZeroOrMore createRNTextZeroOrMore(RStack stack, RContext rContext) {
        RNTextZeroOrMore rNTextZeroOrMore_ = createRNTextZeroOrMore();
        rNTextZeroOrMore_.rSetRContext(rContext);
        rNTextZeroOrMore_.setup(stack);
        return (rNTextZeroOrMore_);
    }

    /**
     * Creates a <code>RNList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNList
     */
    public RNList createRNList(RStack stack, RContext rContext) {
        RNList rNList_ = createRNList();
        rNList_.rSetRContext(rContext);
        rNList_.setup(stack);
        return (rNList_);
    }

    /**
     * Creates a <code>RNTextGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNTextGroup
     */
    public RNTextGroup createRNTextGroup(RStack stack, RContext rContext) {
        RNTextGroup rNTextGroup_ = createRNTextGroup();
        rNTextGroup_.rSetRContext(rContext);
        rNTextGroup_.setup(stack);
        return (rNTextGroup_);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNTextExcept
     */
    public RNTextExcept createRNTextExcept(RStack stack, RContext rContext) {
        RNTextExcept rNTextExcept_ = createRNTextExcept();
        rNTextExcept_.rSetRContext(rContext);
        rNTextExcept_.setup(stack);
        return (rNTextExcept_);
    }

    /**
     * Creates a <code>RNExternalRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNExternalRef
     */
    public RNExternalRef createRNExternalRef(RStack stack, RContext rContext) {
        RNExternalRef rNExternalRef_ = createRNExternalRef();
        rNExternalRef_.rSetRContext(rContext);
        rNExternalRef_.setup(stack);
        return (rNExternalRef_);
    }

    /**
     * Creates a <code>RNParentRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNParentRef
     */
    public RNParentRef createRNParentRef(RStack stack, RContext rContext) {
        RNParentRef rNParentRef_ = createRNParentRef();
        rNParentRef_.rSetRContext(rContext);
        rNParentRef_.setup(stack);
        return (rNParentRef_);
    }

    /**
     * Creates a <code>RNGroup</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNGroup
     */
    public RNGroup createRNGroup(RStack stack, RContext rContext) {
        RNGroup rNGroup_ = createRNGroup();
        rNGroup_.rSetRContext(rContext);
        rNGroup_.setup(stack);
        return (rNGroup_);
    }

    /**
     * Creates a <code>RNChoice</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNChoice
     */
    public RNChoice createRNChoice(RStack stack, RContext rContext) {
        RNChoice rNChoice_ = createRNChoice();
        rNChoice_.rSetRContext(rContext);
        rNChoice_.setup(stack);
        return (rNChoice_);
    }

    /**
     * Creates a <code>RNInterleave</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNInterleave
     */
    public RNInterleave createRNInterleave(RStack stack, RContext rContext) {
        RNInterleave rNInterleave_ = createRNInterleave();
        rNInterleave_.rSetRContext(rContext);
        rNInterleave_.setup(stack);
        return (rNInterleave_);
    }

    /**
     * Creates a <code>RNOneOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNOneOrMore
     */
    public RNOneOrMore createRNOneOrMore(RStack stack, RContext rContext) {
        RNOneOrMore rNOneOrMore_ = createRNOneOrMore();
        rNOneOrMore_.rSetRContext(rContext);
        rNOneOrMore_.setup(stack);
        return (rNOneOrMore_);
    }

    /**
     * Creates a <code>RNMixed</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNMixed
     */
    public RNMixed createRNMixed(RStack stack, RContext rContext) {
        RNMixed rNMixed_ = createRNMixed();
        rNMixed_.rSetRContext(rContext);
        rNMixed_.setup(stack);
        return (rNMixed_);
    }

    /**
     * Creates a <code>RNOptional</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNOptional
     */
    public RNOptional createRNOptional(RStack stack, RContext rContext) {
        RNOptional rNOptional_ = createRNOptional();
        rNOptional_.rSetRContext(rContext);
        rNOptional_.setup(stack);
        return (rNOptional_);
    }

    /**
     * Creates a <code>RNZeroOrMore</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNZeroOrMore
     */
    public RNZeroOrMore createRNZeroOrMore(RStack stack, RContext rContext) {
        RNZeroOrMore rNZeroOrMore_ = createRNZeroOrMore();
        rNZeroOrMore_.rSetRContext(rContext);
        rNZeroOrMore_.setup(stack);
        return (rNZeroOrMore_);
    }

    /**
     * Creates a <code>RNInclude</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNInclude
     */
    public RNInclude createRNInclude(RStack stack, RContext rContext) {
        RNInclude rNInclude_ = createRNInclude();
        rNInclude_.rSetRContext(rContext);
        rNInclude_.setup(stack);
        return (rNInclude_);
    }

    /**
     * Creates a <code>RNDiv</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @param rContext
     * @return RNDiv
     */
    public RNDiv createRNDiv(RStack stack, RContext rContext) {
        RNDiv rNDiv_ = createRNDiv();
        rNDiv_.rSetRContext(rContext);
        rNDiv_.setup(stack);
        return (rNDiv_);
    }

    /**
     * Creates a default <code>RContext</code>.
     * This method is a hook method of the AbstractRelaxNgFactory.
     *
     * @return RContext
     */
    public RContext createRContext() {
        return (new RContext());
    }
}
