/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.raw;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.text.UString;

/**
 * RRule
 *
 * @since   Dec. 15, 1999
 * @version Nov. 17, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class RRule extends RNode {
    protected String label_;
    protected String namespace_;
    protected RNode[] contents_;

    protected RRule(Element element) {
	super(element);
	label_ = UString.checkNull(element.getAttribute("label"));
	namespace_ = UString.checkNull(element.getAttribute("namespace"));
	contents_ = URRelax.buildContents(element);
    }

    public String getLabel() {
	return (label_);
    }

    public String getNamespace() {
	return (namespace_);
    }

    public RNode[] getContents() {
	return (contents_);
    }
}
